/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JCheckBox;

@XStreamAlias(value="CheckIcon")
public class CheckIcon<E extends JCheckBox, D extends IDecoration<E, D>, I extends CheckIcon<E, D, I>>
extends AbstractContent<E, D, I> {
    @XStreamAsAttribute
    protected Stroke stroke;
    @XStreamAsAttribute
    protected Color color;

    public String getId() {
        return "checked";
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d) {
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)this.stroke, (this.stroke != null ? 1 : 0) != 0);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.color);
        int w = bounds.width;
        int h = bounds.height;
        int x = bounds.x;
        int y = bounds.y;
        GeneralPath gp = new GeneralPath();
        gp.moveTo((double)x + (double)w * 0.1875, (double)y + (double)h * 0.375);
        gp.lineTo((double)x + (double)w * 0.4575, (double)y + (double)h * 0.6875);
        gp.lineTo((double)x + (double)w * 0.875, (double)y + (double)h * 0.125);
        g2d.draw(gp);
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
    }

    public I merge(I icon) {
        if (((CheckIcon)icon).stroke != null) {
            this.stroke = ((CheckIcon)icon).stroke;
        }
        if (((CheckIcon)icon).color != null) {
            this.color = ((CheckIcon)icon).color;
        }
        return (I)this;
    }
}

