/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.menu.AdaptivePopupMenuPainter;
import com.alee.laf.menu.IPopupMenuPainter;
import com.alee.laf.menu.PopupMenuPainter;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class WebPopupMenuUI
extends BasicPopupMenuUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SwingConstants {
    @DefaultPainter(value=PopupMenuPainter.class)
    protected IPopupMenuPainter painter;
    protected PopupMenuWay popupMenuWay = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebPopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setHandlesEnableStateMark(this.popupMenu);
        StyleManager.installSkin(this.popupMenu);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.popupMenu);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.popupMenu);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.popupMenu, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.popupMenu, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    public PopupMenuWay getPopupMenuWay() {
        return this.popupMenuWay;
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.popupMenu, new DataRunnable<IPopupMenuPainter>(){

            public void run(IPopupMenuPainter newPainter) {
                WebPopupMenuUI.this.painter = newPainter;
            }
        }, this.painter, painter, IPopupMenuPainter.class, AdaptivePopupMenuPainter.class);
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        Point fixed;
        if (this.painter != null && (fixed = this.painter.preparePopupMenu(popup, popup.getInvoker(), x, y)) != null) {
            x = fixed.x;
            y = fixed.y;
        }
        this.popupMenuWay = null;
        Popup p = super.getPopup(popup, x, y);
        if (this.painter != null) {
            this.painter.configurePopup(popup, popup.getInvoker(), x, y, p);
        }
        return p;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }
}

