/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.extended.window.ComponentMoveBehavior;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.grouping.GroupPane;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.AdaptiveRootPanePainter;
import com.alee.laf.rootpane.IRootPanePainter;
import com.alee.laf.rootpane.RootPanePainter;
import com.alee.laf.rootpane.WebRootPaneLayout;
import com.alee.managers.language.LM;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ImageUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WebRootPaneUI
extends BasicRootPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SwingConstants {
    public static ImageIcon minimizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize.png"));
    public static ImageIcon minimizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize_active.png"));
    public static ImageIcon maximizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize.png"));
    public static ImageIcon maximizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize_active.png"));
    public static ImageIcon restoreIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore.png"));
    public static ImageIcon restoreActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore_active.png"));
    public static ImageIcon closeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close.png"));
    public static ImageIcon closeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close_active.png"));
    protected int iconSize;
    protected String emptyTitleText;
    protected boolean displayTitleComponent;
    protected boolean displayWindowButtons;
    protected boolean displayMinimizeButton;
    protected boolean displayMaximizeButton;
    protected boolean displayCloseButton;
    protected boolean displayMenuBar;
    @DefaultPainter(value=RootPanePainter.class)
    protected IRootPanePainter painter;
    protected JComponent titleComponent;
    protected GroupPane buttonsPanel;
    protected WebButton minimizeButton;
    protected WebButton maximizeButton;
    protected WebButton closeButton;
    protected Insets margin = null;
    protected Insets padding = null;
    protected JRootPane root;
    protected Window window;
    protected Frame frame;
    protected Dialog dialog;
    protected LayoutManager previousLayoutManager;
    protected LayoutManager layoutManager;
    protected PropertyChangeListener titleChangeListener;
    protected PropertyChangeListener resizableChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        this.installWindowDecorations();
        StyleManager.installSkin(this.root);
        Container contentPane = this.root.getContentPane();
        if (contentPane instanceof JComponent) {
            StyleId.rootpaneContent.at(this.root).set((JComponent)contentPane);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.root);
        this.uninstallWindowDecorations();
        this.layoutManager = null;
        this.root = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.root);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        StyleId styleId = StyleManager.setStyleId(this.root, id);
        this.updateWindowDecorations();
        return styleId;
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.root, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.root, new DataRunnable<IRootPanePainter>(){

            public void run(IRootPanePainter newPainter) {
                WebRootPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, IRootPanePainter.class, AdaptiveRootPanePainter.class);
    }

    public boolean isDecorated() {
        return this.painter != null && this.painter.isDecorated();
    }

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(JComponent title) {
        this.titleComponent = title;
        this.root.revalidate();
    }

    public GroupPane getButtonsPanel() {
        return this.buttonsPanel;
    }

    public boolean isDisplayTitleComponent() {
        return this.displayTitleComponent;
    }

    public void setDisplayTitleComponent(boolean display) {
        this.displayTitleComponent = display;
        this.root.revalidate();
    }

    public boolean isDisplayWindowButtons() {
        return this.displayWindowButtons;
    }

    public void setDisplayWindowButtons(boolean display) {
        this.displayWindowButtons = display;
        this.root.revalidate();
    }

    public boolean isDisplayMinimizeButton() {
        return this.displayMinimizeButton;
    }

    public void setDisplayMinimizeButton(boolean display) {
        this.displayMinimizeButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isDisplayMaximizeButton() {
        return this.displayMaximizeButton;
    }

    public void setDisplayMaximizeButton(boolean display) {
        this.displayMaximizeButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isDisplayCloseButton() {
        return this.displayCloseButton;
    }

    public void setDisplayCloseButton(boolean display) {
        this.displayCloseButton = display;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isDisplayMenuBar() {
        return this.displayMenuBar;
    }

    public void setDisplayMenuBar(boolean display) {
        this.displayMenuBar = display;
        this.root.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            this.updateWindowDecorations();
        }
    }

    protected void updateWindowDecorations() {
        if (this.root.isShowing()) {
            throw new RuntimeException("Unable to modify window decoration while it is displayed");
        }
        this.uninstallWindowDecorations();
        this.installWindowDecorations();
    }

    protected void installWindowDecorations() {
        if (this.root.getWindowDecorationStyle() != 0 && this.isDecorated()) {
            this.window = SwingUtils.getWindowAncestor((Component)this.root);
            this.frame = this.window instanceof Frame ? (Frame)this.window : null;
            this.dialog = this.window instanceof Dialog ? (Dialog)this.window : null;
            this.installListeners();
            this.installOpacity();
            this.installLayout();
            this.installDecorationComponents();
        }
    }

    protected void uninstallWindowDecorations() {
        if (this.window != null && this.isDecorated()) {
            this.uninstallDecorationComponents();
            this.uninstallLayout();
            this.uninstallOpacity();
            this.uninstallListeners();
            this.uninstallSettings();
            this.dialog = null;
            this.frame = null;
            this.window = null;
        }
    }

    protected void uninstallSettings() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(null);
        }
    }

    protected void installListeners() {
        this.titleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebRootPaneUI.this.titleComponent.revalidate();
                WebRootPaneUI.this.titleComponent.repaint();
            }
        };
        this.window.addPropertyChangeListener("iconImage", this.titleChangeListener);
        this.window.addPropertyChangeListener("title", this.titleChangeListener);
        this.resizableChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebRootPaneUI.this.updateButtons();
            }
        };
        this.window.addPropertyChangeListener("resizable", this.resizableChangeListener);
    }

    protected void uninstallListeners() {
        this.window.removePropertyChangeListener("iconImage", this.titleChangeListener);
        this.window.removePropertyChangeListener("title", this.titleChangeListener);
        this.window.removePropertyChangeListener("resizable", this.resizableChangeListener);
    }

    protected void installOpacity() {
        if (ProprietaryUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(false);
            ProprietaryUtils.setWindowOpaque(this.window, false);
        }
    }

    protected void uninstallOpacity() {
        if (ProprietaryUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(true);
            ProprietaryUtils.setWindowOpaque(this.window, true);
        }
    }

    protected void installLayout() {
        if (this.layoutManager == null) {
            this.layoutManager = new WebRootPaneLayout();
        }
        this.previousLayoutManager = this.root.getLayout();
        this.root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout() {
        if (this.previousLayoutManager != null) {
            this.root.setLayout(this.previousLayoutManager);
            this.previousLayoutManager = null;
        }
    }

    protected void installDecorationComponents() {
        this.titleComponent = this.createDefaultTitleComponent();
        this.root.add(this.titleComponent);
        this.updateButtons();
    }

    protected void uninstallDecorationComponents() {
        if (this.titleComponent != null) {
            this.root.remove(this.titleComponent);
            this.titleComponent = null;
        }
        if (this.buttonsPanel != null) {
            this.root.remove(this.buttonsPanel);
            this.buttonsPanel = null;
            this.minimizeButton = null;
            this.maximizeButton = null;
            this.closeButton = null;
        }
    }

    protected JComponent createDefaultTitleComponent() {
        StyleId titlePanelId = StyleId.rootpaneTitlePanel.at(this.root);
        WebPanel titlePanel = new WebPanel(titlePanelId, new BorderLayout(5, 0), new Component[0]);
        WebLabel titleIcon = new WebLabel(StyleId.rootpaneTitleIcon.at(titlePanel)){

            @Override
            public Icon getIcon() {
                return WebRootPaneUI.this.getWindowIcon();
            }
        };
        titlePanel.add((Component)titleIcon, (Object)"Before");
        final TitleLabel titleLabel = new TitleLabel(StyleId.rootpaneTitleLabel.at(titlePanel));
        titleLabel.setFont(WebLookAndFeel.globalTitleFont);
        titleLabel.setFontSize(13);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                titleLabel.setHorizontalAlignment(titleLabel.getRequiredSize().width > titleLabel.getWidth() ? 10 : 0);
            }
        });
        titlePanel.add((Component)titleLabel, (Object)"Center");
        ComponentMoveBehavior cma = new ComponentMoveBehavior(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WebRootPaneUI.this.isFrame() && WebRootPaneUI.this.isDisplayMaximizeButton() && SwingUtils.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    if (WebRootPaneUI.this.isMaximized()) {
                        WebRootPaneUI.this.restore();
                    } else {
                        WebRootPaneUI.this.maximize();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.dragging && WebRootPaneUI.this.isMaximized()) {
                    WebRootPaneUI.this.restore();
                }
                super.mouseDragged(e);
            }
        };
        titlePanel.addMouseListener(cma);
        titlePanel.addMouseMotionListener(cma);
        return titlePanel;
    }

    protected void updateButtons() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new GroupPane(StyleId.rootpaneButtonsPanel.at(this.root), new Component[0]);
            this.buttonsPanel.setPaintSides(false, true, true, true);
            this.root.add(this.buttonsPanel);
        }
        if (this.displayMinimizeButton && this.isFrame()) {
            if (this.minimizeButton == null) {
                StyleId minimizeId = StyleId.rootpaneMinimizeButton.at(this.buttonsPanel);
                this.minimizeButton = new WebButton(minimizeId, (Icon)minimizeIcon, (Icon)minimizeActiveIcon);
                this.minimizeButton.setName("minimize");
                this.minimizeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebRootPaneUI.this.iconify();
                    }
                });
            }
            this.buttonsPanel.add((Component)this.minimizeButton);
        } else if (this.minimizeButton != null) {
            this.buttonsPanel.remove((Component)this.minimizeButton);
        }
        if (this.displayMaximizeButton && this.isResizable() && this.isFrame()) {
            if (this.maximizeButton == null) {
                StyleId maximizeId = StyleId.rootpaneMaximizeButton.at(this.buttonsPanel);
                this.maximizeButton = new WebButton(maximizeId, (Icon)maximizeIcon, maximizeActiveIcon){

                    @Override
                    public Icon getIcon() {
                        return WebRootPaneUI.this.isMaximized() ? restoreIcon : maximizeIcon;
                    }

                    @Override
                    public Icon getRolloverIcon() {
                        return WebRootPaneUI.this.isMaximized() ? restoreActiveIcon : maximizeActiveIcon;
                    }
                };
                this.maximizeButton.setName("maximize");
                this.maximizeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WebRootPaneUI.this.isFrame()) {
                            if (WebRootPaneUI.this.isMaximized()) {
                                WebRootPaneUI.this.restore();
                            } else {
                                WebRootPaneUI.this.maximize();
                            }
                        }
                    }
                });
            }
            this.buttonsPanel.add((Component)this.maximizeButton);
        } else if (this.maximizeButton != null) {
            this.buttonsPanel.remove((Component)this.maximizeButton);
        }
        if (this.displayCloseButton) {
            if (this.closeButton == null) {
                StyleId closeId = StyleId.rootpaneCloseButton.at(this.buttonsPanel);
                this.closeButton = new WebButton(closeId, (Icon)closeIcon, (Icon)closeActiveIcon);
                this.closeButton.setName("close");
                this.closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebRootPaneUI.this.close();
                    }
                });
            }
            this.buttonsPanel.add((Component)this.closeButton);
        } else if (this.closeButton != null) {
            this.buttonsPanel.remove((Component)this.closeButton);
        }
    }

    protected String getWindowTitle() {
        if (this.isDialog()) {
            return this.dialog.getTitle();
        }
        if (this.isFrame()) {
            return this.frame.getTitle();
        }
        return null;
    }

    protected ImageIcon getWindowIcon() {
        List<Image> images;
        List<Image> list = images = this.window != null ? this.window.getIconImages() : null;
        if (images != null && images.size() > 1) {
            int bestIndex = 0;
            int bestDiff = Math.abs(images.get(bestIndex).getWidth(null) - this.iconSize);
            for (int i = 1; i < images.size() && bestDiff != 0; ++i) {
                int diff = Math.abs(images.get(i).getWidth(null) - this.iconSize);
                if (diff >= bestDiff) continue;
                bestIndex = i;
                bestDiff = diff;
            }
            return this.generateProperIcon(images.get(bestIndex));
        }
        if (images != null && images.size() == 1) {
            return this.generateProperIcon(images.get(0));
        }
        return new ImageIcon();
    }

    protected ImageIcon generateProperIcon(Image image) {
        if (image.getWidth(null) <= this.iconSize) {
            return new ImageIcon(image);
        }
        return ImageUtils.createPreviewIcon((Image)image, (int)this.iconSize);
    }

    protected void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected void iconify() {
        if (this.frame != null) {
            this.frame.setExtendedState(1);
        }
    }

    protected void maximize() {
        if (this.frame != null) {
            GraphicsConfiguration gc = this.frame.getGraphicsConfiguration().getDevice().getDefaultConfiguration();
            this.frame.setMaximizedBounds(SystemUtils.getMaxWindowBounds((GraphicsConfiguration)gc, (boolean)true));
            this.frame.setExtendedState(6);
        }
    }

    protected void restore() {
        if (this.frame != null) {
            this.frame.setExtendedState(0);
        }
    }

    protected boolean isResizable() {
        return this.isDialog() ? this.dialog.isResizable() : this.isFrame() && this.frame.isResizable();
    }

    public boolean isFrame() {
        return this.frame != null;
    }

    public boolean isIconified() {
        return this.isFrame() && (this.frame.getExtendedState() & 1) == 1;
    }

    public boolean isMaximized() {
        return this.isFrame() && (this.frame.getExtendedState() & 6) == 6;
    }

    public boolean isDialog() {
        return this.dialog != null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public class TitleLabel
    extends WebLabel {
        public TitleLabel(StyleId id) {
            super(id);
        }

        @Override
        public String getText() {
            String title = WebRootPaneUI.this.getWindowTitle();
            String t = !TextUtils.isEmpty((String)title) ? title : (WebRootPaneUI.this.emptyTitleText != null ? LM.get((String)WebRootPaneUI.this.emptyTitleText) : null);
            return !TextUtils.isEmpty((String)t) ? t : " ";
        }

        public Dimension getRequiredSize() {
            return super.getPreferredSize();
        }
    }
}

