/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.CompareUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class TextFieldLayout
extends AbstractLayoutManager {
    public static final String LEADING = "LEADING";
    public static final String TRAILING = "TRAILING";
    private Component leading;
    private Component trailing;

    @Override
    public void addComponent(Component component, Object constraints) {
        if (CompareUtils.equals((Object)constraints, (Object[])new Object[]{LEADING})) {
            this.leading = component;
        } else if (CompareUtils.equals((Object)constraints, (Object[])new Object[]{TRAILING})) {
            this.trailing = component;
        } else {
            String msg = "Component cannot be added to layout: constraint must be either of '%s' or '%s' string value";
            throw new IllegalArgumentException(String.format("Component cannot be added to layout: constraint must be either of '%s' or '%s' string value", LEADING, TRAILING));
        }
    }

    @Override
    public void removeComponent(Component component) {
        if (this.leading == component) {
            this.leading = null;
        } else if (this.trailing == component) {
            this.trailing = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets b = parent.getInsets();
        Dimension l = this.leading != null ? this.leading.getPreferredSize() : new Dimension();
        Dimension t = this.trailing != null ? this.trailing.getPreferredSize() : new Dimension();
        return new Dimension(b.left + l.width + t.width + b.right, b.top + Math.max(l.height, t.height) + b.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        int w;
        Insets b = parent.getInsets();
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        if (this.leading != null) {
            w = this.leading.getPreferredSize().width;
            if (ltr) {
                this.leading.setBounds(b.left - w, b.top, w, parent.getHeight() - b.top - b.bottom);
            } else {
                this.leading.setBounds(parent.getWidth() - b.right, b.top, w, parent.getHeight() - b.top - b.bottom);
            }
        }
        if (this.trailing != null) {
            w = this.trailing.getPreferredSize().width;
            if (ltr) {
                this.trailing.setBounds(parent.getWidth() - b.right, b.top, w, parent.getHeight() - b.top - b.bottom);
            } else {
                this.trailing.setBounds(b.left - w, b.top, w, parent.getHeight() - b.top - b.bottom);
            }
        }
    }
}

