/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.laf.toolbar.IToolBarPainter;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.painter.decoration.AbstractContainerPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.states.Orientation;
import com.alee.utils.CompareUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ToolBarPainter<E extends JToolBar, U extends WebToolBarUI, D extends IDecoration<E, D>>
extends AbstractContainerPainter<E, U, D>
implements IToolBarPainter<E, U> {
    public static final int gripperSpace = 5;
    protected int spacing;
    protected AncestorListener ancestorListener;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.updateLayout(true);
        this.ancestorListener = new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                ToolBarPainter.this.updateLayout(false);
                ToolBarPainter.this.updateDecorationState();
            }
        };
        ((JToolBar)this.component).addAncestorListener(this.ancestorListener);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JToolBar)this.component).removeAncestorListener(this.ancestorListener);
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"floatable", "orientation"})) {
            this.updateLayout(false);
            this.updateDecorationState();
        }
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(Orientation.get(((JToolBar)this.component).getOrientation()).name());
        if (((WebToolBarUI)this.ui).isFloating()) {
            states.add("floating");
        }
        return states;
    }

    protected void updateLayout(boolean install) {
        boolean installed = ((JToolBar)this.component).getLayout() instanceof ToolbarLayout;
        if (!install && !installed) {
            return;
        }
        ToolbarLayout layout = new ToolbarLayout(this.spacing, ((JToolBar)this.component).getOrientation());
        if (installed) {
            ToolbarLayout old = (ToolbarLayout)((JToolBar)this.component).getLayout();
            layout.setConstraints(old.getConstraints());
        }
        ((JToolBar)this.component).setLayout(layout);
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.paintGripper(g2d, c);
    }

    protected void paintGripper(Graphics2D g2d, E c) {
    }
}

