/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tooltip;

import com.alee.laf.tooltip.IToolTipPainter;
import com.alee.laf.tooltip.WebToolTipUI;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.text.View;

public class ToolTipPainter<E extends JToolTip, U extends WebToolTipUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IToolTipPainter<E, U> {
    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.paintText(g2d, bounds, c);
    }

    protected void paintText(Graphics2D g2d, Rectangle bounds, E c) {
        Font font = ((Component)c).getFont();
        Map taa = SwingUtils.setupTextAntialias(g2d);
        Font of = GraphicsUtils.setupFont((Graphics)g2d, (Font)font);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)((Component)c).getForeground());
        Insets i = ((JComponent)c).getInsets();
        Rectangle textR = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - (i.left + i.right), bounds.height - (i.top + i.bottom));
        View htmlView = (View)((JComponent)c).getClientProperty("html");
        if (htmlView != null) {
            htmlView.paint(g2d, textR);
        } else {
            String tipText = ((JToolTip)c).getTipText() != null ? ((JToolTip)c).getTipText() : "";
            FontMetrics fm = SwingUtils.getFontMetrics(c, g2d, font);
            SwingUtils.drawString(g2d, tipText, textR.x, textR.y + fm.getAscent());
        }
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
        GraphicsUtils.restoreFont((Graphics)g2d, (Font)of);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets i = ((JToolTip)this.component).getInsets();
        Dimension prefSize = new Dimension(i.left + i.right, i.top + i.bottom);
        View v = (View)((JToolTip)this.component).getClientProperty("html");
        if (v != null) {
            prefSize.width += (int)v.getPreferredSpan(0);
            prefSize.height += (int)v.getPreferredSpan(1);
        } else {
            Font font = ((JToolTip)this.component).getFont();
            FontMetrics fm = ((JToolTip)this.component).getFontMetrics(font);
            String tipText = ((JToolTip)this.component).getTipText() != null ? ((JToolTip)this.component).getTipText() : "";
            prefSize.width += SwingUtils.stringWidth(fm, tipText);
            prefSize.height += fm.getHeight();
        }
        return prefSize;
    }
}

