/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebExTree;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.managers.drag.DragViewHandler;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class NodesDragViewHandler<E extends DefaultMutableTreeNode>
implements DragViewHandler<List<E>> {
    public abstract int getNodesViewLimit();

    public Insets getMoreTextMargin() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public BufferedImage getView(List<E> nodes, DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dsc;
        if (dragSourceDragEvent.getSource() instanceof DragSourceContext && (dsc = (DragSourceContext)dragSourceDragEvent.getSource()).getComponent() instanceof WebTree) {
            List realNodes;
            WebTree tree = (WebTree)dsc.getComponent();
            if (nodes.get(0) instanceof UniqueNode) {
                WebTree exTree;
                List uniqueNodes = nodes;
                if (tree instanceof WebExTree) {
                    exTree = (WebExTree)tree;
                    realNodes = new ArrayList();
                    for (UniqueNode node : uniqueNodes) {
                        realNodes.add(((WebExTree)exTree).findNode(node.getId()));
                    }
                } else if (tree instanceof WebExTree) {
                    exTree = (WebAsyncTree)tree;
                    realNodes = new ArrayList();
                    for (UniqueNode node : uniqueNodes) {
                        realNodes.add(((WebAsyncTree)exTree).findNode(node.getId()));
                    }
                } else {
                    realNodes = nodes;
                }
            } else {
                realNodes = nodes;
            }
            FontMetrics fm = tree.getFontMetrics(tree.getFont());
            int fmh = fm.getHeight();
            int limit = this.getNodesViewLimit();
            int amount = realNodes.size() - limit;
            String text = amount > 1 ? "And %s more elements" : "And one more element";
            String moreText = limit > 0 ? String.format(text, amount) : null;
            Insets moreTextOffset = this.getMoreTextMargin();
            int width = 0;
            int height = 0;
            int count = 0;
            for (DefaultMutableTreeNode node : realNodes) {
                if (limit <= 0 || limit > count) {
                    Rectangle bounds = tree.getNodeBounds(node);
                    width = Math.max(bounds.width, width);
                    height += bounds.height;
                    ++count;
                    continue;
                }
                width = Math.max(moreTextOffset.left + fm.stringWidth(moreText) + moreTextOffset.right, width);
                height += moreTextOffset.top + fmh + moreTextOffset.bottom;
                break;
            }
            BufferedImage image = ImageUtils.createCompatibleImage((int)width, (int)height, (int)3);
            Graphics2D g2d = image.createGraphics();
            int y = 0;
            count = 0;
            for (DefaultMutableTreeNode node : realNodes) {
                if (limit <= 0 || limit > count) {
                    int row = tree.getRowForNode(node);
                    boolean exp = tree.isExpanded(node);
                    boolean leaf = tree.getModel().isLeaf(node);
                    Component r = tree.getCellRenderer().getTreeCellRendererComponent(tree, node, false, exp, leaf, row, false);
                    Dimension ps = r.getPreferredSize();
                    tree.getCellRendererPane().paintComponent(g2d, r, null, 0, y, ps.width, ps.height);
                    y += ps.height;
                    ++count;
                    continue;
                }
                SwingUtils.setupTextAntialias(g2d);
                g2d.setPaint(Color.BLACK);
                g2d.drawString(moreText, moreTextOffset.left, y + moreTextOffset.top + fmh / 2 + LafUtils.getTextCenterShiftY(fm));
                break;
            }
            g2d.dispose();
            return image;
        }
        return null;
    }

    @Override
    public Point getViewRelativeLocation(List<E> nodes, DragSourceDragEvent dragSourceDragEvent) {
        return new Point(25, 5);
    }

    @Override
    public void dragEnded(List<E> nodes, DragSourceDropEvent event) {
    }
}

