/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.global.GlobalConstants;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.managers.log.Log;
import com.alee.utils.CollectionUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class FocusManager {
    protected static final Object trackersLock = new Object();
    protected static final Map<Component, Map<FocusTracker, Boolean>> trackers = new WeakHashMap<Component, Map<FocusTracker, Boolean>>();
    protected static final Object listenersLock = new Object();
    protected static final List<GlobalFocusListener> globalFocusListeners = new ArrayList<GlobalFocusListener>(2);
    protected static WeakReference<Component> oldFocusOwner;
    protected static WeakReference<Component> focusOwner;
    protected static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof FocusEvent && globalFocusListeners.size() > 0) {
                        FocusEvent focusEvent = (FocusEvent)event;
                        if (focusEvent.getID() == 1005 && focusEvent.getOppositeComponent() == null) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getComponent(), null);
                        } else if (focusEvent.getID() == 1004) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getOppositeComponent(), focusEvent.getComponent());
                        }
                    }
                }
            }, 4L);
            FocusManager.registerGlobalFocusListener(new GlobalFocusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusChanged(Component oldFocus, Component newFocus) {
                    oldFocusOwner = new WeakReference<Component>(oldFocus);
                    focusOwner = new WeakReference<Component>(newFocus);
                    if (GlobalConstants.DEBUG) {
                        String oldName = oldFocus != null ? oldFocus.getClass().getName() : null;
                        String newName = newFocus != null ? newFocus.getClass().getName() : null;
                        Log.debug((Object)this, (String)("Focus changed: " + oldName + " --> " + newName), (Object[])new Object[0]);
                    }
                    for (Map.Entry<Component, Map<FocusTracker, Boolean>> entry : FocusManager.getTrackersCopy().entrySet()) {
                        Component tracked = entry.getKey();
                        if (tracked == null) continue;
                        for (Map.Entry<FocusTracker, Boolean> innerEntry : entry.getValue().entrySet()) {
                            Boolean trackerStateCache;
                            FocusTracker focusTracker = innerEntry.getKey();
                            if (!focusTracker.isTrackingEnabled()) continue;
                            boolean isOldFocused = focusTracker.isInvolved(oldFocus, tracked);
                            boolean isNewFocused = focusTracker.isInvolved(newFocus, tracked);
                            if (!isOldFocused && !isNewFocused || (trackerStateCache = innerEntry.getValue()) != null && trackerStateCache == isNewFocused) continue;
                            focusTracker.focusChanged(isNewFocused);
                            Object object = trackersLock;
                            synchronized (object) {
                                Map<FocusTracker, Boolean> ct = trackers.get(tracked);
                                if (ct != null && ct.containsKey(focusTracker)) {
                                    ct.put(focusTracker, isNewFocused);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Component, Map<FocusTracker, Boolean>> getTrackersCopy() {
        Object object = trackersLock;
        synchronized (object) {
            HashMap<Component, Map<FocusTracker, Boolean>> copy = new HashMap<Component, Map<FocusTracker, Boolean>>(trackers.size());
            for (Map.Entry<Component, Map<FocusTracker, Boolean>> entry : trackers.entrySet()) {
                Map<FocusTracker, Boolean> trackers = entry.getValue();
                HashMap<FocusTracker, Boolean> trackersCopy = new HashMap<FocusTracker, Boolean>(trackers.size());
                for (Map.Entry<FocusTracker, Boolean> innerEntry : trackers.entrySet()) {
                    trackersCopy.put(innerEntry.getKey(), innerEntry.getValue());
                }
                copy.put(entry.getKey(), trackersCopy);
            }
            return copy;
        }
    }

    public static Component getFocusOwner() {
        return focusOwner != null ? (Component)focusOwner.get() : null;
    }

    public static Component getOldFocusOwner() {
        return (Component)oldFocusOwner.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalFocusListener(GlobalFocusListener listener) {
        Object object = listenersLock;
        synchronized (object) {
            globalFocusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobalFocusListener(GlobalFocusListener listener) {
        Object object = listenersLock;
        synchronized (object) {
            globalFocusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireGlobalFocusChanged(Component oldComponent, Component newComponent) {
        ArrayList listeners;
        Iterator iterator = listenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(globalFocusListeners);
        }
        for (GlobalFocusListener listener : listeners) {
            listener.focusChanged(oldComponent, newComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFocusTracker(Component component, FocusTracker focusTracker) {
        Object object = trackersLock;
        synchronized (object) {
            Map<FocusTracker, Boolean> componentTrackers = trackers.get(component);
            if (componentTrackers == null) {
                componentTrackers = new WeakHashMap<FocusTracker, Boolean>();
                trackers.put(component, componentTrackers);
            }
            componentTrackers.put(focusTracker, focusTracker.isInvolved(FocusManager.getFocusOwner(), component));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFocusTracker(FocusTracker focusTracker) {
        Object object = trackersLock;
        synchronized (object) {
            Iterator<Map.Entry<Component, Map<FocusTracker, Boolean>>> iterator = trackers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Component, Map<FocusTracker, Boolean>> entry = iterator.next();
                Map<FocusTracker, Boolean> componentTrackers = entry.getValue();
                componentTrackers.remove(focusTracker);
                if (componentTrackers.size() != 0) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFocusTrackers(Component component) {
        Object object = trackersLock;
        synchronized (object) {
            Map<FocusTracker, Boolean> allTrackers = trackers.get(component);
            if (allTrackers != null && allTrackers.size() > 0) {
                allTrackers.clear();
            }
            trackers.remove(component);
        }
    }

    static {
        initialized = false;
    }
}

