/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.extended.date.DateListener;
import com.alee.extended.date.WebDateField;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.util.Date;

public class WebDateFieldSettingsProcessor
extends SettingsProcessor<WebDateField, Long> {
    private DateListener selectionListener;

    public WebDateFieldSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    protected void doInit(WebDateField dateField) {
        this.selectionListener = new DateListener(){

            @Override
            public void dateChanged(Date date) {
                WebDateFieldSettingsProcessor.this.save();
            }
        };
        dateField.addDateListener(this.selectionListener);
    }

    protected void doDestroy(WebDateField dateField) {
        dateField.removeDateListener(this.selectionListener);
        this.selectionListener = null;
    }

    protected void doLoad(WebDateField dateField) {
        Long date = (Long)this.loadValue();
        Date value = date != null ? new Date(date) : null;
        dateField.setDate(value);
    }

    protected void doSave(WebDateField dateField) {
        Date date = dateField.getDate();
        Long value = date != null ? Long.valueOf(date.getTime()) : null;
        this.saveValue(value);
    }
}

