/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.PainterStyle;
import com.alee.managers.style.data.StyleConverterUtils;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;

public final class PainterStyleConverter
extends ReflectionConverter {
    public PainterStyleConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return Painter.class.isAssignableFrom(type);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String styleId = (String)context.get((Object)"style.id");
        Class parent = (Class)context.get((Object)"painter.class");
        Class<? extends Painter> defaultPainter = StyleConverterUtils.getDefaultPainter(parent, reader.getNodeName());
        Class painterClass = PainterStyleConverter.unmarshalPainterClass(reader, context, defaultPainter, styleId);
        context.put((Object)"painter.class", (Object)painterClass);
        LinkedHashMap<String, Object> painterProperties = new LinkedHashMap<String, Object>();
        StyleConverterUtils.readProperties(reader, context, painterProperties, painterClass, styleId);
        PainterStyle painterStyle = new PainterStyle();
        painterStyle.setPainterClass(painterClass.getCanonicalName());
        painterStyle.setProperties(painterProperties);
        context.put((Object)"painter.class", (Object)parent);
        return painterStyle;
    }

    public static Class unmarshalPainterClass(HierarchicalStreamReader reader, UnmarshallingContext context, Class<? extends Painter> defaultPainterClass, String styleId) {
        String painterClassName = reader.getAttribute("class");
        if (painterClassName != null) {
            Class painterClass = ReflectUtils.getClassSafely((String)painterClassName);
            if (painterClass == null) {
                String skinClassName = (String)context.get((Object)"skin.class");
                Class skinClass = ReflectUtils.getClassSafely((String)skinClassName);
                if (skinClass == null) {
                    throw new StyleException("Class \"" + painterClassName + "\" for style \"" + styleId + "\" cannot be found");
                }
                String skinPackage = skinClass.getPackage().getName();
                painterClassName = skinPackage + "." + painterClassName;
                painterClass = ReflectUtils.getClassSafely((String)painterClassName);
                if (painterClass == null) {
                    throw new StyleException("Class \"" + painterClassName + "\" for style \"" + styleId + "\" cannot be found");
                }
            }
            return painterClass;
        }
        if (defaultPainterClass != null) {
            return defaultPainterClass;
        }
        throw new StyleException("Painter class for style \"" + styleId + "\" was not specified ");
    }
}

