/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.utils.CompareUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceLocation;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SkinInfoConverter
extends ReflectionConverter {
    public static final String ID_NODE = "id";
    public static final String ICON_NODE = "icon";
    public static final String TITLE_NODE = "title";
    public static final String DESCRIPTION_NODE = "description";
    public static final String AUTHOR_NODE = "author";
    public static final String SUPPORTED_SYSTEMS_NODE = "supportedSystems";
    public static final String CLASS_NODE = "class";
    public static final String INCLUDE_NODE = "include";
    public static final String STYLE_NODE = "style";
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";
    public static final String SUBSEQUENT_SKIN = "subsequent.skin";
    public static final String SKIN_CLASS = "skin.class";
    private static final Object skinLock = new Object();
    private static final Map<String, Map<String, String>> resourceMap = new LinkedHashMap<String, Map<String, String>>();
    private static boolean subsequentSkin = false;
    private static String skinClass = null;

    public SkinInfoConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public static void addCustomResource(String nearClass, String src, String xml) {
        Map<String, String> nearClassMap = resourceMap.get(nearClass);
        if (nearClassMap == null) {
            nearClassMap = new LinkedHashMap<String, String>();
            resourceMap.put(nearClass, nearClassMap);
        }
        nearClassMap.put(src, xml);
    }

    public boolean canConvert(Class type) {
        return type.equals(SkinInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object object = skinLock;
        synchronized (object) {
            SkinInfo skinInfo;
            String superSkinClass = skinClass;
            boolean wasSubsequent = subsequentSkin;
            try {
                context.put((Object)SUBSEQUENT_SKIN, (Object)subsequentSkin);
                context.put((Object)SKIN_CLASS, (Object)skinClass);
                SkinInfo skinInfo2 = new SkinInfo();
                ArrayList<ComponentStyle> styles = new ArrayList<ComponentStyle>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String nodeName = reader.getNodeName();
                    if (nodeName.equals(ID_NODE)) {
                        skinInfo2.setId(reader.getValue());
                    } else if (!nodeName.equals(ICON_NODE)) {
                        if (nodeName.equals(TITLE_NODE)) {
                            skinInfo2.setTitle(reader.getValue());
                        } else if (nodeName.equals(DESCRIPTION_NODE)) {
                            skinInfo2.setDescription(reader.getValue());
                        } else if (nodeName.equals(AUTHOR_NODE)) {
                            skinInfo2.setAuthor(reader.getValue());
                        } else if (nodeName.equals(SUPPORTED_SYSTEMS_NODE)) {
                            skinInfo2.setSupportedSystems(reader.getValue());
                        } else if (nodeName.equals(CLASS_NODE)) {
                            skinInfo2.setSkinClass(reader.getValue());
                            skinClass = skinInfo2.getSkinClass();
                            context.put((Object)SKIN_CLASS, (Object)skinClass);
                        } else if (nodeName.equals(STYLE_NODE)) {
                            styles.add((ComponentStyle)context.convertAnother(styles, ComponentStyle.class));
                        } else if (nodeName.equals(INCLUDE_NODE)) {
                            String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
                            String file = reader.getValue();
                            ResourceFile resourceFile = new ResourceFile(ResourceLocation.nearClass, file, nearClass);
                            styles.addAll(this.readInclude(context, wasSubsequent, skinInfo2, resourceFile));
                        }
                    }
                    reader.moveUp();
                }
                skinInfo2.setStyles(styles);
                if (!subsequentSkin) {
                    LinkedHashMap<StyleableComponent, Map<String, ComponentStyle>> stylesCache = new LinkedHashMap<StyleableComponent, Map<String, ComponentStyle>>(StyleableComponent.values().length);
                    this.performOverride(styles);
                    this.buildStyles(styles);
                    this.gatherStyles(styles, stylesCache);
                    skinInfo2.setStylesCache(stylesCache);
                }
                skinInfo = skinInfo2;
                skinClass = superSkinClass;
            }
            catch (Throwable throwable) {
                skinClass = superSkinClass;
                context.put((Object)SKIN_CLASS, (Object)skinClass);
                throw throwable;
            }
            context.put((Object)SKIN_CLASS, (Object)skinClass);
            return skinInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentStyle> readInclude(UnmarshallingContext context, boolean wasSubsequent, SkinInfo skinInfo, ResourceFile resourceFile) {
        try {
            subsequentSkin = true;
            context.put((Object)SUBSEQUENT_SKIN, (Object)subsequentSkin);
            if (resourceFile.getClassName() == null) {
                String skinClass = skinInfo.getSkinClass();
                if (skinClass == null) {
                    throw new StyleException("Included skin file \"" + resourceFile.getSource() + "\" specified but skin \"" + CLASS_NODE + "\" is not set");
                }
                resourceFile.setClassName(skinClass);
            }
            SkinInfo include = this.loadSkinInfo(resourceFile);
            List<ComponentStyle> list = include.getStyles();
            return list;
        }
        finally {
            subsequentSkin = wasSubsequent;
            context.put((Object)SUBSEQUENT_SKIN, (Object)subsequentSkin);
        }
    }

    private void performOverride(List<ComponentStyle> styles) {
        int i;
        for (i = 0; i < styles.size(); ++i) {
            ComponentStyle currentStyle = styles.get(i);
            for (int j = i + 1; j < styles.size(); ++j) {
                ComponentStyle style = styles.get(j);
                if (style.getType() != currentStyle.getType() || !CompareUtils.equals((Object)style.getId(), (Object[])new Object[]{currentStyle.getId()})) continue;
                styles.set(i, currentStyle.clone().merge(styles.remove(j--)));
            }
        }
        for (i = 0; i < styles.size(); ++i) {
            this.performOverride(styles, styles, i);
        }
    }

    private void performOverride(List<ComponentStyle> globalStyles, List<ComponentStyle> levelStyles, int index) {
        ComponentStyle style = levelStyles.get(index);
        if (style.getStylesCount() > 0) {
            for (int i = 0; i < style.getStylesCount(); ++i) {
                this.performOverride(globalStyles, style.getStyles(), i);
            }
        }
        StyleableComponent type = style.getType();
        String completeId = style.getCompleteId();
        String defaultStyleId = type.getDefaultStyleId().getCompleteId();
        ComponentStyle extendedStyle = null;
        if (!TextUtils.isEmpty((String)style.getExtendsId())) {
            String extendsId = style.getExtendsId();
            if (extendsId.equals(completeId)) {
                String msg = "Component style '%s:%s' extends itself";
                throw new StyleException(String.format("Component style '%s:%s' extends itself", new Object[]{type, completeId}));
            }
            extendedStyle = this.findStyle(type, extendsId, style.getId(), levelStyles, globalStyles, index);
            if (extendedStyle == null) {
                String msg = "Component style '%s:%s' missing style '%s'";
                throw new StyleException(String.format("Component style '%s:%s' missing style '%s'", new Object[]{type, completeId, extendsId}));
            }
        }
        if (extendedStyle == null) {
            extendedStyle = this.findOverrideStyle(globalStyles, style);
        }
        if (extendedStyle == null && !CompareUtils.equals((Object)completeId, (Object[])new Object[]{defaultStyleId}) && (extendedStyle = this.findStyle(type, defaultStyleId, style.getId(), levelStyles, globalStyles, index)) == null) {
            String msg = "Component style '%s:%s' missing default style '%s'";
            throw new StyleException(String.format("Component style '%s:%s' missing default style '%s'", new Object[]{type, completeId, defaultStyleId}));
        }
        if (extendedStyle != null) {
            levelStyles.set(index, extendedStyle.clone().merge(style));
        }
    }

    private ComponentStyle findOverrideStyle(List<ComponentStyle> globalStyles, ComponentStyle style) {
        ArrayList<ComponentStyle> componentStyles = new ArrayList<ComponentStyle>();
        componentStyles.add(style);
        while (((ComponentStyle)componentStyles.get(0)).getParent() != null) {
            componentStyles.add(0, ((ComponentStyle)componentStyles.get(0)).getParent());
        }
        ComponentStyle oldStyle = null;
        while (!componentStyles.isEmpty()) {
            int maxIndex;
            ComponentStyle currentStyle = (ComponentStyle)componentStyles.remove(0);
            List<ComponentStyle> styles = oldStyle == null ? globalStyles : oldStyle.getStyles();
            int n = maxIndex = oldStyle == null ? globalStyles.indexOf(currentStyle) : Integer.MAX_VALUE;
            oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getId(), styles, maxIndex);
            if (oldStyle != null || (oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getExtendsId(), styles, maxIndex)) != null || (oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getType().toString(), styles, maxIndex)) != null) continue;
            break;
        }
        return oldStyle;
    }

    private void gatherStyles(List<ComponentStyle> styles, Map<StyleableComponent, Map<String, ComponentStyle>> stylesCache) {
        if (styles != null) {
            for (ComponentStyle style : styles) {
                StyleableComponent type = style.getType();
                Map<String, ComponentStyle> componentStyles = stylesCache.get((Object)type);
                if (componentStyles == null) {
                    componentStyles = new LinkedHashMap<String, ComponentStyle>(1);
                    stylesCache.put(type, componentStyles);
                }
                componentStyles.put(style.getCompleteId(), style);
                this.gatherStyles(style.getStyles(), stylesCache);
            }
        }
    }

    private void buildStyles(List<ComponentStyle> styles) {
        HashMap<StyleableComponent, List<String>> builtStyles = new HashMap<StyleableComponent, List<String>>();
        for (StyleableComponent type : StyleableComponent.values()) {
            builtStyles.put(type, new ArrayList(1));
        }
        ArrayList<String> building = new ArrayList<String>();
        for (int i = 0; i < styles.size(); ++i) {
            this.buildStyle(styles, i, building, builtStyles);
        }
    }

    private ComponentStyle buildStyle(List<ComponentStyle> levelStyles, int index, List<String> building, Map<StyleableComponent, List<String>> builtStyles) {
        ComponentStyle style = levelStyles.get(index);
        StyleableComponent type = style.getType();
        String completeId = style.getCompleteId();
        String uniqueId = (Object)((Object)type) + ":" + completeId;
        if (building.contains(uniqueId)) {
            throw new StyleException("Style " + uniqueId + " is used within cyclic references");
        }
        if (builtStyles.get((Object)type).contains(completeId)) {
            return style;
        }
        building.add(uniqueId);
        if (style.getStylesCount() > 0) {
            for (int i = 0; i < style.getStylesCount(); ++i) {
                this.buildStyle(style.getStyles(), i, building, builtStyles);
            }
        }
        builtStyles.get((Object)type).add(completeId);
        building.remove(uniqueId);
        return style;
    }

    private ComponentStyle findStyle(StyleableComponent type, String id, String excludeId, List<ComponentStyle> levelStyles, List<ComponentStyle> styles, int maxIndex) {
        ComponentStyle style;
        if (levelStyles != null && levelStyles != styles && (style = this.findStyle(type, id, levelStyles, maxIndex)) != null && !CompareUtils.equals((Object)style.getId(), (Object[])new Object[]{excludeId})) {
            return style;
        }
        return this.findStyle(type, id, styles, Integer.MAX_VALUE);
    }

    private ComponentStyle findStyle(StyleableComponent type, String id, List<ComponentStyle> styles, int maxIndex) {
        ComponentStyle fstyle = null;
        for (int i = 0; i < styles.size() && i < maxIndex; ++i) {
            ComponentStyle style = styles.get(i);
            if (style.getType() != type || !CompareUtils.equals((Object)style.getId(), (Object[])new Object[]{id})) continue;
            fstyle = style;
        }
        return fstyle;
    }

    protected SkinInfo loadSkinInfo(ResourceFile resourceFile) {
        try {
            Map<String, String> nearClassMap = resourceMap.get(resourceFile.getClassName());
            if (nearClassMap != null) {
                String xml = nearClassMap.get(resourceFile.getSource());
                if (xml != null) {
                    return (SkinInfo)XmlUtils.fromXML((String)xml);
                }
                return (SkinInfo)XmlUtils.fromXML((ResourceFile)resourceFile, (boolean)false);
            }
            return (SkinInfo)XmlUtils.fromXML((ResourceFile)resourceFile, (boolean)false);
        }
        catch (Throwable e) {
            throw new StyleException("Included skin file \"" + resourceFile.getSource() + "\" cannot be read", e);
        }
    }
}

