/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.painter.AbstractPainter;
import com.alee.painter.common.NinePatchState;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class NinePatchStatePainter<E extends JComponent, U extends ComponentUI>
extends AbstractPainter<E, U> {
    protected Map<String, NinePatchIcon> stateIcons;

    public NinePatchStatePainter() {
        this.stateIcons = new HashMap<String, NinePatchIcon>();
    }

    public NinePatchStatePainter(Map<String, NinePatchIcon> stateIcons) {
        this.stateIcons = stateIcons;
    }

    public Map<String, NinePatchIcon> getStateIcons() {
        return this.stateIcons;
    }

    public void setStateIcons(Map<String, NinePatchIcon> stateIcons) {
        this.stateIcons = stateIcons;
        this.updateAll();
    }

    public void addStateIcon(String state, NinePatchIcon ninePatchIcon) {
        this.stateIcons.put(state, ninePatchIcon);
        this.updateAll();
    }

    public void removeStateIcon(String state) {
        this.stateIcons.remove(state);
        this.updateAll();
    }

    public boolean hasStateIcons() {
        return this.stateIcons != null && this.stateIcons.size() > 0;
    }

    protected boolean isFocused(E component) {
        return ((Component)component).isFocusOwner();
    }

    protected NinePatchIcon getComponentBackground(E component) {
        return this.getStateIcon(((Component)component).isEnabled() ? NinePatchState.normal : NinePatchState.disabled);
    }

    protected NinePatchIcon getButtonBackground(AbstractButton button) {
        ButtonModel bm = button.getModel();
        if (bm.isPressed()) {
            return this.getStateIcon(bm.isSelected() ? NinePatchState.selectedPressed : NinePatchState.pressed);
        }
        if (bm.isSelected()) {
            if (bm.isEnabled()) {
                return this.getStateIcon(bm.isRollover() ? NinePatchState.selectedRollover : NinePatchState.selected);
            }
            return this.getStateIcon(NinePatchState.selectedDisabled);
        }
        if (bm.isEnabled()) {
            return this.getStateIcon(bm.isRollover() ? NinePatchState.rollover : NinePatchState.normal);
        }
        return this.getStateIcon(NinePatchState.disabled);
    }

    protected NinePatchIcon getToolBarBackground(JToolBar toolbar) {
        if (toolbar.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)toolbar.getUI()).isFloating()) {
            return this.getStateIcon(toolbar.isEnabled() ? NinePatchState.floating : NinePatchState.floatingDisabled);
        }
        return this.getStateIcon(toolbar.isEnabled() ? NinePatchState.normal : NinePatchState.disabled);
    }

    public NinePatchIcon getExactStateIcon(String state) {
        return this.stateIcons.get(state);
    }

    public NinePatchIcon getStateIcon(String state) {
        if (state.equals(NinePatchState.normal)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : null;
        }
        if (state.equals(NinePatchState.rollover)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.normal);
        }
        if (state.equals(NinePatchState.disabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.normal);
        }
        if (state.equals(NinePatchState.pressed)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.selected);
        }
        if (state.equals(NinePatchState.selected)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.normal);
        }
        if (state.equals(NinePatchState.selectedRollover)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.selected);
        }
        if (state.equals(NinePatchState.selectedDisabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.selected);
        }
        if (state.equals(NinePatchState.selectedPressed)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.pressed);
        }
        if (state.equals(NinePatchState.focused)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : null;
        }
        if (state.equals(NinePatchState.floating)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.normal);
        }
        if (state.equals(NinePatchState.floatingDisabled)) {
            return this.stateIcons.containsKey(state) ? this.stateIcons.get(state) : this.getStateIcon(NinePatchState.floating);
        }
        return null;
    }

    @Override
    public Insets getBorders() {
        Insets margin = super.getBorders();
        if (this.hasStateIcons()) {
            Insets maxInsets = this.i(0, 0, 0, 0);
            for (NinePatchIcon npi : this.stateIcons.values()) {
                npi.setComponent(this.component);
                maxInsets = SwingUtils.max(maxInsets, npi.getMargin());
            }
            return SwingUtils.max(margin, maxInsets);
        }
        return margin;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        if (this.hasStateIcons() && c != null) {
            NinePatchIcon focusIcon;
            NinePatchIcon stateIcon = c instanceof AbstractButton ? this.getButtonBackground((AbstractButton)c) : (c instanceof JToolBar ? this.getToolBarBackground((JToolBar)c) : this.getComponentBackground(c));
            if (stateIcon != null) {
                stateIcon.setComponent((Component)c);
                stateIcon.paintIcon(g2d, bounds);
            }
            if (this.isFocused(c) && (focusIcon = this.getExactStateIcon(NinePatchState.focused)) != null) {
                focusIcon.setComponent((Component)c);
                focusIcon.paintIcon(g2d, bounds);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.hasStateIcons()) {
            Dimension maxDimension = new Dimension(0, 0);
            for (NinePatchIcon npi : this.stateIcons.values()) {
                npi.setComponent(this.component);
                maxDimension = SwingUtils.max(maxDimension, npi.getPreferredSize());
            }
            return maxDimension;
        }
        return super.getPreferredSize();
    }
}

