/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.painter.common.BorderPainter;
import com.alee.painter.common.TitlePosition;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;

public class TitledBorderPainter<E extends JComponent, U extends ComponentUI>
extends BorderPainter<E, U>
implements SwingConstants {
    protected int titleOffset = 4;
    protected int titleBorderGap = 3;
    protected TitlePosition titlePosition = TitlePosition.insideLine;
    protected Color foreground = null;
    protected Color background = null;
    protected boolean clipTitleBackground = true;
    protected int titleAlignment;
    protected int titleSide;
    protected String titleText;
    protected int w;
    protected int h;
    protected int sw;
    protected boolean emptyTitle;
    protected FontMetrics fontMetrics;
    protected int titleAreaHeight;
    protected int titleWidth;
    protected int titleX;
    protected int titleY;
    protected double borderCenter;
    protected double borderPosition;
    protected Shape borderShape;
    protected boolean doClip;

    public TitledBorderPainter() {
        this((String)null);
    }

    public TitledBorderPainter(String titleText) {
        this(titleText, 10);
    }

    public TitledBorderPainter(String titleText, int titleAlignment) {
        this(titleText, titleAlignment, 1);
    }

    public TitledBorderPainter(String titleText, int titleAlignment, int titleSide) {
        this.titleText = titleText;
        this.titleAlignment = titleAlignment;
        this.titleSide = titleSide;
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int titleOffset) {
        this.titleOffset = titleOffset;
        this.updateAll();
    }

    public int getTitleBorderGap() {
        return this.titleBorderGap;
    }

    public void setTitleBorderGap(int titleBorderGap) {
        this.titleBorderGap = titleBorderGap;
        this.updateAll();
    }

    public int getTitleSide() {
        return this.titleSide;
    }

    public void setTitleSide(int titleSide) {
        this.titleSide = titleSide;
        this.updateAll();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public TitlePosition getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(TitlePosition titlePosition) {
        this.titlePosition = titlePosition;
        this.repaint();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.repaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.repaint();
    }

    public boolean isClipTitleBackground() {
        return this.clipTitleBackground;
    }

    public void setClipTitleBackground(boolean clipTitleBackground) {
        this.clipTitleBackground = clipTitleBackground;
        this.repaint();
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
        this.updateAll();
    }

    @Override
    public Insets getBorders() {
        Insets m = super.getBorders();
        if (!this.isEmptyTitle()) {
            switch (this.titleSide) {
                case 1: {
                    m.top += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 2: {
                    m.left += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 3: {
                    m.bottom += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 4: {
                    m.right += this.getTitleAreaHeight(this.component);
                }
            }
        }
        return m;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.w = ((JComponent)c).getWidth();
        this.h = ((JComponent)c).getHeight();
        this.sw = this.getStrokeWidth();
        this.emptyTitle = this.isEmptyTitle();
        this.fontMetrics = this.emptyTitle ? null : ((JComponent)c).getFontMetrics(((Component)c).getFont());
        this.titleWidth = this.emptyTitle ? 0 : this.fontMetrics.stringWidth(this.titleText);
        this.titleAreaHeight = this.getTitleAreaHeight(c);
        this.titleX = this.getTitleX(c);
        this.titleY = this.getTitleY();
        this.borderCenter = (double)this.sw / 2.0;
        this.borderPosition = this.getBorderPosition();
        this.borderShape = this.getBorderShape();
        this.doClip = this.clipTitleBackground && !this.emptyTitle && this.titlePosition.equals((Object)TitlePosition.insideLine);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)this.stroke, (this.stroke != null ? 1 : 0) != 0);
        if (this.background != null && !this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        Shape clipShape = this.doClip ? this.getBorderClipShape() : null;
        Shape oldClip = GraphicsUtils.subtractClip((Graphics)g2d, (Shape)clipShape, (boolean)this.doClip);
        if (this.background != null && this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        g2d.setPaint(this.color);
        g2d.draw(this.borderShape);
        GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)oldClip, (boolean)this.doClip);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os, (this.stroke != null ? 1 : 0) != 0);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        if (!this.emptyTitle) {
            g2d.setPaint(this.foreground != null ? this.foreground : ((Component)c).getForeground());
            switch (this.titleSide) {
                case 1: 
                case 3: {
                    Map hints = SwingUtils.setupTextAntialias(g2d);
                    g2d.drawString(this.titleText, this.titleX, this.titleY);
                    SwingUtils.restoreTextAntialias(g2d, hints);
                    break;
                }
            }
        }
    }

    protected int getTitleX(E c) {
        if (this.titleAlignment == 2 || this.titleAlignment == 10 && this.ltr || this.titleAlignment == 11 && !this.ltr) {
            return Math.max(this.sw, this.round) + this.titleOffset + this.titleBorderGap;
        }
        if (this.titleAlignment == 4 || this.titleAlignment == 11 && this.ltr || this.titleAlignment == 10 && !this.ltr) {
            return this.w - Math.max(this.sw, this.round) - this.titleOffset - this.titleBorderGap - this.titleWidth;
        }
        return this.w / 2 - this.titleWidth / 2;
    }

    protected int getTitleY() {
        int fontDescent = this.fontMetrics != null ? this.fontMetrics.getDescent() : 0;
        switch (this.titleSide) {
            case 1: {
                return this.titlePosition.equals((Object)TitlePosition.aboveLive) ? this.titleAreaHeight - this.sw - fontDescent : this.titleAreaHeight - fontDescent;
            }
            case 3: {
                return this.titlePosition.equals((Object)TitlePosition.belowLine) ? this.h - this.sw - fontDescent : this.h - fontDescent;
            }
            case 2: {
                break;
            }
        }
        return 0;
    }

    protected double getBorderPosition() {
        if (this.emptyTitle) {
            return this.borderCenter;
        }
        if (this.titlePosition.equals((Object)TitlePosition.insideLine)) {
            return (double)this.titleAreaHeight / 2.0;
        }
        if (this.titlePosition.equals((Object)TitlePosition.aboveLive)) {
            return (double)this.titleAreaHeight - this.borderCenter;
        }
        return this.borderCenter;
    }

    protected int getTitleAreaHeight(E c) {
        if (this.isEmptyTitle()) {
            return this.sw;
        }
        int height = ((JComponent)c).getFontMetrics(((Component)c).getFont()).getHeight();
        return this.titlePosition.equals((Object)TitlePosition.insideLine) ? height : height + this.sw;
    }

    protected boolean isEmptyTitle() {
        return this.titleText == null;
    }

    protected Shape getBorderShape() {
        RectangularShape rect = null;
        switch (this.titleSide) {
            case 1: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderPosition, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 2: {
                rect = new Rectangle2D.Double(this.borderPosition, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
                break;
            }
            case 3: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 4: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
            }
        }
        return this.round > 0 ? new RoundRectangle2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight(), this.round * 2, this.round * 2) : rect;
    }

    protected Shape getBorderClipShape() {
        if (this.emptyTitle) {
            return null;
        }
        switch (this.titleSide) {
            case 1: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 3: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, (double)this.h - this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 2: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isEmptyTitle()) {
            return super.getPreferredSize();
        }
        int titleAreaHeight = this.getTitleAreaHeight(this.component);
        int titleWidth = this.component.getFontMetrics(this.component.getFont()).stringWidth(this.titleText);
        int border = Math.max(this.getStrokeWidth(), this.round);
        int title = Math.max(titleAreaHeight, border);
        switch (this.titleSide) {
            case 1: 
            case 3: {
                return new Dimension(border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2, title + border);
            }
            case 2: 
            case 4: {
                return new Dimension(title + border, border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2);
            }
        }
        return null;
    }
}

