/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractTextureBackground;
import com.alee.utils.ImageUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

@XStreamAlias(value="AlphaLayerBackground")
public class AlphaLayerBackground<E extends JComponent, D extends IDecoration<E, D>, I extends AlphaLayerBackground<E, D, I>>
extends AbstractTextureBackground<E, D, I> {
    @XStreamAsAttribute
    protected Dimension size;
    @XStreamAsAttribute
    protected Color darkColor;
    @XStreamAsAttribute
    protected Color lightColor;

    @Override
    protected boolean isPaintable() {
        return this.size != null && this.size.width > 0 && this.size.height > 0 && (this.darkColor != null || this.lightColor != null);
    }

    @Override
    protected TexturePaint getTexturePaint(Rectangle bounds) {
        BufferedImage image = ImageUtils.createCompatibleImage((int)(this.size.width * 2), (int)(this.size.height * 2), (int)3);
        Graphics2D g2d = image.createGraphics();
        if (this.darkColor != null) {
            g2d.setPaint(this.darkColor);
            g2d.fillRect(0, 0, this.size.width, this.size.height);
            g2d.fillRect(this.size.width, this.size.height, this.size.width, this.size.height);
        }
        if (this.lightColor != null) {
            g2d.setPaint(this.lightColor);
            g2d.fillRect(this.size.width, 0, this.size.width, this.size.height);
            g2d.fillRect(0, this.size.height, this.size.width, this.size.height);
        }
        g2d.dispose();
        return new TexturePaint(image, new Rectangle(bounds.x, bounds.y, image.getWidth(), image.getHeight()));
    }

    @Override
    public I merge(I background) {
        super.merge(background);
        return (I)this;
    }
}

