/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shadow;

import com.alee.global.StyleConstants;
import com.alee.graphics.filters.ShadowFilter;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shadow.AbstractShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.IShape;
import com.alee.painter.decoration.shape.StretchInfo;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

@XStreamAlias(value="WebShadow")
public class WebShadow<E extends JComponent, D extends WebDecoration<E, D>, I extends WebShadow<E, D, I>>
extends AbstractShadow<E, D, I> {
    protected static final transient Map<String, WeakReference<NinePatchIcon>> shadowIconsCache = new HashMap<String, WeakReference<NinePatchIcon>>(100);
    protected static final transient Map<String, WeakReference<BufferedImage>> shadowImagesCache = new HashMap<String, WeakReference<BufferedImage>>(20);
    protected static final String separator = ",";
    protected transient NinePatchIcon shadowIcon;
    protected transient BufferedImage shadowImage;

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        int width = this.getWidth();
        float opacity = this.getOpacity();
        if (width > 0 && opacity > 0.0f) {
            ShadowType type = this.getType();
            Rectangle b = this.getShadeBounds(type, shape, width);
            IShape shapeType = ((WebDecoration)d).getShape();
            StretchInfo stretch = shapeType.getStretchInfo(bounds, c, d);
            Object[] settings = shapeType.getShapeSettings(bounds, c, d);
            if (stretch != null && stretch.isStretchable()) {
                if (type == ShadowType.outer) {
                    this.shadowIcon = this.getShadeIcon(stretch, b, width, opacity, this.getColor(), shape, settings);
                    this.shadowIcon.paintIcon(g2d, b.x, b.y, b.width, b.height);
                    this.shadowImage = null;
                } else {
                    this.shadowIcon = this.getInnerShadeIcon(stretch, b, width, opacity, this.getColor(), shape, settings);
                    this.shadowIcon.paintIcon(g2d, b.x, b.y, b.width, b.height);
                    this.shadowImage = null;
                }
            } else if (type == ShadowType.outer) {
                this.shadowImage = WebShadow.getShadeImage(b, width, opacity, this.getColor(), shape, settings);
                g2d.drawImage(this.shadowImage, b.x, b.y, b.width, b.height, null);
                this.shadowIcon = null;
            } else {
                this.shadowImage = WebShadow.getInnerShadeImage(b, width, opacity, this.getColor(), shape, settings);
                g2d.drawImage(this.shadowImage, b.x, b.y, b.width, b.height, null);
                this.shadowIcon = null;
            }
        } else {
            this.shadowIcon = null;
            this.shadowImage = null;
        }
    }

    protected Rectangle getShadeBounds(ShadowType type, Shape shape, int width) {
        Rectangle sb = shape.getBounds();
        if (type == ShadowType.outer) {
            return new Rectangle(sb.x - width, sb.y - width, sb.width + width * 2, sb.height + width * 2);
        }
        return new Rectangle(sb.x, sb.y, sb.width, sb.height);
    }

    protected NinePatchIcon getShadeIcon(StretchInfo stretchInfo, Rectangle bounds, int width, float opacity, Color color, Shape shape, Object ... settings) {
        NinePatchIcon shadow;
        int hor = stretchInfo.getHorizontalStretch() == null ? bounds.width : 0;
        int ver = stretchInfo.getVerticalStretch() == null ? bounds.height : 0;
        String key = TextUtils.getSettingsKey((Object[])new Object[]{ShadowType.outer, hor, ver, width, Float.valueOf(opacity), color, settings});
        NinePatchIcon ninePatchIcon = shadow = shadowIconsCache.containsKey(key) ? (NinePatchIcon)shadowIconsCache.get(key).get() : null;
        if (shadow == null) {
            shadow = WebShadow.createShadeIcon(stretchInfo, bounds, width, opacity, color, shape);
            shadowIconsCache.put(key, new WeakReference<NinePatchIcon>(shadow));
        }
        return shadow;
    }

    public static NinePatchIcon createShadeIcon(StretchInfo stretchInfo, Rectangle bounds, int width, float opacity, Color color, Shape shape) {
        BufferedImage image = WebShadow.createShadeImage(bounds, width, opacity, color, shape);
        NinePatchIcon icon = NinePatchIcon.create(image);
        Pair<Integer, Integer> hor = stretchInfo.getHorizontalStretch();
        if (hor != null) {
            int x0 = (Integer)hor.getKey() - bounds.x;
            int x1 = (Integer)hor.getValue() - bounds.x;
            icon.addHorizontalStretch(0, x0 - 1, true);
            icon.addHorizontalStretch(x0, x1, false);
            icon.addHorizontalStretch(x1 + 1, image.getWidth(), true);
        } else {
            icon.addHorizontalStretch(0, image.getWidth(), true);
        }
        Pair<Integer, Integer> ver = stretchInfo.getVerticalStretch();
        if (ver != null) {
            int y0 = (Integer)ver.getKey() - bounds.y;
            int y1 = (Integer)ver.getValue() - bounds.y;
            icon.addVerticalStretch(0, y0 - 1, true);
            icon.addVerticalStretch(y0, y1, false);
            icon.addVerticalStretch(y1 + 1, image.getHeight(), true);
        } else {
            icon.addVerticalStretch(0, image.getHeight(), true);
        }
        icon.setMargin(width);
        return icon;
    }

    public static BufferedImage getShadeImage(Rectangle bounds, int width, float opacity, Color color, Shape shape, Object ... settings) {
        BufferedImage shadow;
        String key = TextUtils.getSettingsKey((Object[])new Object[]{ShadowType.outer, bounds.width, bounds.height, width, Float.valueOf(opacity), color, settings});
        BufferedImage bufferedImage = shadow = shadowImagesCache.containsKey(key) ? (BufferedImage)shadowImagesCache.get(key).get() : null;
        if (shadow == null) {
            shadow = WebShadow.createShadeImage(bounds, width, opacity, color, shape);
            shadowImagesCache.put(key, new WeakReference<BufferedImage>(shadow));
        }
        return shadow;
    }

    public static BufferedImage createShadeImage(Rectangle bounds, int width, float opacity, Color color, Shape shape) {
        BufferedImage bi = ImageUtils.createCompatibleImage((int)bounds.width, (int)bounds.height, (int)3);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias((Graphics2D)ig);
        ig.translate(-bounds.x, -bounds.y);
        ig.setPaint(Color.BLACK);
        ig.fill(shape);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter((float)width, 0.0f, 0.0f, opacity);
        sf.setShadowColor(Color.BLACK.getRGB());
        BufferedImage shadow = sf.filter(bi, null);
        Graphics2D g2d = shadow.createGraphics();
        GraphicsUtils.setupAntialias((Graphics2D)g2d);
        g2d.translate(-bounds.x, -bounds.y);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setPaint(StyleConstants.transparent);
        g2d.fill(shape);
        g2d.setPaint(color);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.fillRect(0, 0, bounds.width, bounds.height);
        g2d.dispose();
        return shadow;
    }

    protected NinePatchIcon getInnerShadeIcon(StretchInfo stretchInfo, Rectangle bounds, int width, float opacity, Color color, Shape shape, Object ... settings) {
        NinePatchIcon shadow;
        int hor = stretchInfo.getHorizontalStretch() == null ? bounds.width : 0;
        int ver = stretchInfo.getVerticalStretch() == null ? bounds.height : 0;
        String key = TextUtils.getSettingsKey((Object[])new Object[]{ShadowType.inner, hor, ver, width, Float.valueOf(opacity), color, settings});
        NinePatchIcon ninePatchIcon = shadow = shadowIconsCache.containsKey(key) ? (NinePatchIcon)shadowIconsCache.get(key).get() : null;
        if (shadow == null) {
            shadow = WebShadow.createInnerShadeIcon(stretchInfo, bounds, width, opacity, color, shape);
            shadowIconsCache.put(key, new WeakReference<NinePatchIcon>(shadow));
        }
        return shadow;
    }

    public static NinePatchIcon createInnerShadeIcon(StretchInfo stretchInfo, Rectangle bounds, int width, float opacity, Color color, Shape shape) {
        BufferedImage image = WebShadow.createInnerShadeImage(bounds, width, opacity, color, shape);
        NinePatchIcon icon = NinePatchIcon.create(image);
        Pair<Integer, Integer> hor = stretchInfo.getHorizontalStretch();
        if (hor != null) {
            int x0 = (Integer)hor.getKey() - bounds.x;
            int x1 = (Integer)hor.getValue() - bounds.x;
            icon.addHorizontalStretch(0, x0 - 1, true);
            icon.addHorizontalStretch(x0, x1, false);
            icon.addHorizontalStretch(x1 + 1, image.getWidth(), true);
        } else {
            icon.addHorizontalStretch(0, image.getWidth(), true);
        }
        Pair<Integer, Integer> ver = stretchInfo.getVerticalStretch();
        if (ver != null) {
            int y0 = (Integer)ver.getKey() - bounds.y;
            int y1 = (Integer)ver.getValue() - bounds.y;
            icon.addVerticalStretch(0, y0 - 1, true);
            icon.addVerticalStretch(y0, y1, false);
            icon.addVerticalStretch(y1 + 1, image.getHeight(), true);
        } else {
            icon.addVerticalStretch(0, image.getHeight(), true);
        }
        icon.setMargin(width);
        return icon;
    }

    public static BufferedImage getInnerShadeImage(Rectangle bounds, int width, float opacity, Color color, Shape shape, Object ... settings) {
        BufferedImage shadow;
        String key = TextUtils.getSettingsKey((Object[])new Object[]{ShadowType.inner, bounds.width, bounds.height, width, Float.valueOf(opacity), color, settings});
        BufferedImage bufferedImage = shadow = shadowImagesCache.containsKey(key) ? (BufferedImage)shadowImagesCache.get(key).get() : null;
        if (shadow == null) {
            shadow = WebShadow.createInnerShadeImage(bounds, width, opacity, color, shape);
            shadowImagesCache.put(key, new WeakReference<BufferedImage>(shadow));
        }
        return shadow;
    }

    public static BufferedImage createInnerShadeImage(Rectangle bounds, int width, float opacity, Color color, Shape shape) {
        Rectangle b = new Rectangle(bounds.x - width * 2, bounds.y - width * 2, bounds.width + width * 4, bounds.height + width * 4);
        BufferedImage bi = ImageUtils.createCompatibleImage((int)b.width, (int)b.height, (int)3);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias((Graphics2D)ig);
        ig.translate(-b.x, -b.y);
        Area area = new Area(new Rectangle(b.x, b.y, b.width, b.height));
        area.exclusiveOr(new Area(shape));
        ig.setPaint(Color.BLACK);
        ig.fill(area);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter((float)width, 0.0f, 0.0f, opacity);
        sf.setShadowColor(Color.BLACK.getRGB());
        BufferedImage shadow = sf.filter(bi, null);
        Graphics2D g2d = shadow.createGraphics();
        GraphicsUtils.setupAntialias((Graphics2D)g2d);
        g2d.translate(-b.x, -b.y);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setPaint(StyleConstants.transparent);
        g2d.fill(area);
        g2d.setPaint(color);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.fillRect(0, 0, b.width, b.height);
        g2d.dispose();
        return shadow.getSubimage(width * 2, width * 2, b.width - width * 4, b.height - width * 4);
    }
}

