/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.NetUtil;
import de.sciss.net.OSCBundle;
import de.sciss.net.OSCChannel;
import de.sciss.net.OSCConnectionListener;
import de.sciss.net.OSCException;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public abstract class OSCReceiver
implements OSCChannel,
Runnable {
    private final List<OSCListener> collListeners = new ArrayList<OSCListener>();
    protected final List<OSCConnectionListener> connListeners = new ArrayList<OSCConnectionListener>();
    protected Thread thread = null;
    protected final Object generalSync = new Object();
    protected final Object threadSync = new Object();
    protected boolean isListening = false;
    private final Object bufSync = new Object();
    private int bufSize = 8192;
    protected ByteBuffer byteBuf = null;
    protected boolean allocBuf = true;
    private int dumpMode = 0;
    private PrintStream printStream = null;
    private OSCPacketCodec c;
    private final String protocol;
    protected final InetSocketAddress localAddress;
    protected final boolean revivable;
    protected SocketAddress target = null;

    protected OSCReceiver(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress, boolean bl) {
        this.c = oSCPacketCodec;
        this.protocol = string;
        this.localAddress = inetSocketAddress;
        this.revivable = bl;
    }

    public static OSCReceiver newUsing(String string) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), string);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, String string) throws IOException {
        return OSCReceiver.newUsing(oSCPacketCodec, string, 0);
    }

    public static OSCReceiver newUsing(String string, int n) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), string, 0);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, String string, int n) throws IOException {
        return OSCReceiver.newUsing(oSCPacketCodec, string, 0, false);
    }

    public static OSCReceiver newUsing(String string, int n, boolean bl) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), string, n, bl);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, String string, int n, boolean bl) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(bl ? "127.0.0.1" : "0.0.0.0", n);
        return OSCReceiver.newUsing(oSCPacketCodec, string, inetSocketAddress);
    }

    public static OSCReceiver newUsing(String string, InetSocketAddress inetSocketAddress) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), string, inetSocketAddress);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress) throws IOException {
        if (string.equals("udp")) {
            return new UDPOSCReceiver(oSCPacketCodec, inetSocketAddress);
        }
        if (string.equals("tcp")) {
            return new TCPOSCReceiver(oSCPacketCodec, inetSocketAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + string);
    }

    public static OSCReceiver newUsing(DatagramChannel datagramChannel) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), datagramChannel);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, DatagramChannel datagramChannel) throws IOException {
        return new UDPOSCReceiver(oSCPacketCodec, datagramChannel);
    }

    public static OSCReceiver newUsing(SocketChannel socketChannel) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), socketChannel);
    }

    public static OSCReceiver newUsing(OSCPacketCodec oSCPacketCodec, SocketChannel socketChannel) throws IOException {
        return new TCPOSCReceiver(oSCPacketCodec, socketChannel);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public abstract void setTarget(SocketAddress var1);

    @Override
    public void setCodec(OSCPacketCodec oSCPacketCodec) {
        this.c = oSCPacketCodec;
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOSCListener(OSCListener oSCListener) {
        List<OSCListener> list = this.collListeners;
        synchronized (list) {
            if (this.collListeners.contains(oSCListener)) {
                return;
            }
            this.collListeners.add(oSCListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOSCListener(OSCListener oSCListener) {
        List<OSCListener> list = this.collListeners;
        synchronized (list) {
            this.collListeners.remove(oSCListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.add(oSCConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.remove(oSCConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() throws IOException {
        Object object = this.generalSync;
        synchronized (object) {
            if (Thread.currentThread() == this.thread) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotInThisThread"));
            }
            if (this.isListening && (this.thread == null || !this.thread.isAlive())) {
                this.isListening = false;
            }
            if (!this.isListening) {
                if (!this.isConnected()) {
                    this.connect();
                }
                this.isListening = true;
                this.thread = new Thread((Runnable)this, "OSCReceiver");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.generalSync;
        synchronized (object) {
            return this.isListening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() throws IOException {
        Object object = this.generalSync;
        synchronized (object) {
            if (Thread.currentThread() == this.thread) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotInThisThread"));
            }
            if (this.isListening) {
                this.isListening = false;
                if (this.thread != null && this.thread.isAlive()) {
                    try {
                        Object object2 = this.threadSync;
                        synchronized (object2) {
                            this.sendGuardSignal();
                            this.threadSync.wait(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        NetUtil.log(Level.INFO, "", interruptedException);
                    }
                    finally {
                        if (this.thread != null && this.thread.isAlive()) {
                            try {
                                NetUtil.log(Level.INFO, "OSCReceiver.stopListening : rude task killing (" + this.hashCode() + ")");
                                this.closeChannel();
                            }
                            catch (IOException iOException) {
                                NetUtil.log(Level.INFO, "", iOException);
                            }
                        }
                        this.thread = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferSize(int n) {
        Object object = this.bufSync;
        synchronized (object) {
            if (this.isListening) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
            }
            if (this.bufSize != n) {
                this.bufSize = n;
                this.allocBuf = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferSize() {
        Object object = this.bufSync;
        synchronized (object) {
            return this.bufSize;
        }
    }

    @Override
    public void dumpOSC(int n, PrintStream printStream) {
        this.dumpMode = n;
        this.printStream = printStream == null ? System.err : printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.stopListening();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.closeChannel();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        List<Object> list = this.collListeners;
        synchronized (list) {
            this.collListeners.clear();
        }
        list = this.connListeners;
        synchronized (list) {
            this.connListeners.clear();
        }
        this.byteBuf = null;
    }

    protected abstract void sendGuardSignal() throws IOException;

    protected abstract void setChannel(SelectableChannel var1) throws IOException;

    protected abstract void closeChannel() throws IOException;

    protected static String debugTimeString() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    protected void flipDecodeDispatch(SocketAddress socketAddress) throws IOException {
        block5: {
            try {
                this.byteBuf.flip();
                OSCPacket oSCPacket = this.c.decode(this.byteBuf);
                if (this.dumpMode != 0) {
                    this.printStream.print("r: ");
                    if ((this.dumpMode & 1) != 0) {
                        OSCPacket.printTextOn(this.printStream, oSCPacket);
                    }
                    if ((this.dumpMode & 2) != 0) {
                        this.byteBuf.flip();
                        OSCPacket.printHexOn(this.printStream, this.byteBuf);
                    }
                }
                this.dispatchPacket(oSCPacket, socketAddress, 1L);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                if (!this.isListening) break block5;
                NetUtil.log(Level.SEVERE, "", bufferUnderflowException);
            }
        }
    }

    private void dispatchPacket(OSCPacket oSCPacket, SocketAddress socketAddress, long l) {
        if (oSCPacket instanceof OSCMessage) {
            this.dispatchMessage((OSCMessage)oSCPacket, socketAddress, l);
        } else if (oSCPacket instanceof OSCBundle) {
            OSCBundle oSCBundle = (OSCBundle)oSCPacket;
            l = oSCBundle.getTimeTag();
            for (int i = 0; i < oSCBundle.getPacketCount(); ++i) {
                this.dispatchPacket(oSCBundle.getPacket(i), socketAddress, l);
            }
        } else assert (false) : oSCPacket.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
        OSCListener[] oSCListenerArray = this.collListeners;
        synchronized (this.collListeners) {
            OSCListener[] oSCListenerArray2 = new OSCListener[this.collListeners.size()];
            this.collListeners.toArray(oSCListenerArray2);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            for (OSCListener oSCListener : oSCListenerArray2) {
                oSCListener.messageReceived(oSCMessage, socketAddress, l);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBuffer() {
        Object object = this.bufSync;
        synchronized (object) {
            if (this.allocBuf) {
                this.byteBuf = ByteBuffer.allocateDirect(this.bufSize);
                this.allocBuf = false;
            }
        }
    }

    protected InetSocketAddress getLocalAddress(InetAddress inetAddress, int n) throws UnknownHostException {
        return new InetSocketAddress(inetAddress.getHostName().equals("0.0.0.0") ? InetAddress.getLocalHost() : inetAddress, n);
    }

    public abstract void connect() throws IOException;

    public abstract boolean isConnected();

    private static class TCPOSCReceiver
    extends OSCReceiver {
        private SocketChannel sch = null;

        protected TCPOSCReceiver(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) {
            super(oSCPacketCodec, "tcp", inetSocketAddress, true);
        }

        protected TCPOSCReceiver(OSCPacketCodec oSCPacketCodec, SocketChannel socketChannel) {
            super(oSCPacketCodec, "tcp", new InetSocketAddress(socketChannel.socket().getLocalAddress(), socketChannel.socket().getLocalPort()), false);
            this.sch = socketChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setChannel(SelectableChannel selectableChannel) throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                this.sch = (SocketChannel)selectableChannel;
                if (!this.sch.isBlocking()) {
                    this.sch.configureBlocking(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.sch != null) {
                    Socket socket = this.sch.socket();
                    return this.getLocalAddress(socket.getLocalAddress(), socket.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTarget(SocketAddress socketAddress) {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isConnected()) {
                    throw new AlreadyConnectedException();
                }
                this.target = socketAddress;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            OSCConnectionListener[] oSCConnectionListenerArray;
            Object object = this.generalSync;
            synchronized (object) {
                OSCConnectionListener[] oSCConnectionListenerArray2;
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                if (this.sch != null && !this.sch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.sch = null;
                }
                if (this.sch == null) {
                    oSCConnectionListenerArray2 = SocketChannel.open();
                    oSCConnectionListenerArray2.socket().bind(this.localAddress);
                    this.sch = oSCConnectionListenerArray2;
                }
                if (!this.sch.isConnected()) {
                    this.sch.connect(this.target);
                }
                oSCConnectionListenerArray2 = this.connListeners;
                synchronized (oSCConnectionListenerArray2) {
                    oSCConnectionListenerArray = new OSCConnectionListener[this.connListeners.size()];
                    this.connListeners.toArray(oSCConnectionListenerArray);
                }
            }
            object = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
            for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray) {
                oSCConnectionListener.onConnected(this.localAddress, (InetSocketAddress)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.generalSync;
            synchronized (object) {
                return this.sch != null && this.sch.isConnected();
            }
        }

        @Override
        protected void closeChannel() throws IOException {
            if (this.sch != null) {
                try {
                    this.sch.close();
                }
                finally {
                    this.sch = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            SocketAddress socketAddress = this.sch.socket().getRemoteSocketAddress();
            this.checkBuffer();
            block17: while (true) {
                while (this.isListening) {
                    Object object;
                    try {
                        int n;
                        this.byteBuf.rewind().limit(4);
                        do {
                            if ((n = this.sch.read(this.byteBuf)) != -1) continue;
                            return;
                        } while (this.byteBuf.hasRemaining());
                        this.byteBuf.rewind();
                        int n2 = this.byteBuf.getInt();
                        this.byteBuf.rewind().limit(n2);
                        while (this.byteBuf.hasRemaining()) {
                            n = this.sch.read(this.byteBuf);
                            if (n != -1) continue;
                            return;
                        }
                        this.flipDecodeDispatch(socketAddress);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!this.isListening) continue;
                        object = new OSCException(6, illegalArgumentException.toString());
                        NetUtil.log(Level.WARNING, "", (Throwable)object);
                    }
                    catch (ClosedChannelException closedChannelException) {
                        if (this.isListening) {
                            NetUtil.log(Level.WARNING, "", closedChannelException);
                        }
                        object = this.threadSync;
                        synchronized (object) {
                            this.thread = null;
                            this.threadSync.notifyAll();
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (!this.isListening) continue block17;
                            NetUtil.log(Level.WARNING, "", iOException);
                            continue block17;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = this.threadSync;
                synchronized (object) {
                    this.thread = null;
                    this.threadSync.notifyAll();
                }
            }
        }

        @Override
        protected void sendGuardSignal() throws IOException {
            this.sch.socket().shutdownInput();
        }
    }

    private static class UDPOSCReceiver
    extends OSCReceiver {
        private DatagramChannel dch;

        protected UDPOSCReceiver(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) throws IOException {
            super(oSCPacketCodec, "udp", inetSocketAddress, true);
        }

        protected UDPOSCReceiver(OSCPacketCodec oSCPacketCodec, DatagramChannel datagramChannel) throws IOException {
            super(oSCPacketCodec, "udp", new InetSocketAddress(datagramChannel.socket().getLocalAddress(), datagramChannel.socket().getLocalPort()), false);
            this.dch = datagramChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setChannel(SelectableChannel selectableChannel) throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                this.dch = (DatagramChannel)selectableChannel;
                if (!this.dch.isBlocking()) {
                    this.dch.configureBlocking(true);
                }
                if (this.dch.isConnected()) {
                    throw new IllegalStateException(NetUtil.getResourceString("errChannelConnected"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.dch != null) {
                    DatagramSocket datagramSocket = this.dch.socket();
                    return this.getLocalAddress(datagramSocket.getLocalAddress(), datagramSocket.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        @Override
        public void setTarget(SocketAddress socketAddress) {
            this.target = socketAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            OSCConnectionListener[] oSCConnectionListenerArray;
            Object object = this.generalSync;
            synchronized (object) {
                OSCConnectionListener[] oSCConnectionListenerArray2;
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                if (this.dch != null && !this.dch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.dch = null;
                }
                if (this.dch == null) {
                    oSCConnectionListenerArray2 = DatagramChannel.open();
                    oSCConnectionListenerArray2.socket().bind(this.localAddress);
                    this.setChannel((SelectableChannel)oSCConnectionListenerArray2);
                }
                oSCConnectionListenerArray2 = this.connListeners;
                synchronized (oSCConnectionListenerArray2) {
                    oSCConnectionListenerArray = new OSCConnectionListener[this.connListeners.size()];
                    this.connListeners.toArray(oSCConnectionListenerArray);
                }
            }
            object = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
            for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray) {
                oSCConnectionListener.onConnected(this.localAddress, (InetSocketAddress)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.generalSync;
            synchronized (object) {
                return this.dch != null && this.dch.isOpen();
            }
        }

        @Override
        protected void closeChannel() throws IOException {
            if (this.dch != null) {
                try {
                    this.dch.close();
                }
                finally {
                    this.dch = null;
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected void sendGuardSignal() throws IOException {
            DatagramSocket datagramSocket = new DatagramSocket();
            DatagramPacket datagramPacket = new DatagramPacket(new byte[0], 0);
            datagramPacket.setSocketAddress(this.getLocalAddress());
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
    }
}

