/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.NetUtil;
import de.sciss.net.OSCBidi;
import de.sciss.net.OSCConnectionListener;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import de.sciss.net.OSCReceiver;
import de.sciss.net.OSCTransmitter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class OSCServer
implements OSCBidi {
    protected final List<OSCConnectionListener> connListeners = new ArrayList<OSCConnectionListener>();
    protected OSCPacketCodec defaultCodec;
    private final String protocol;

    protected OSCServer(OSCPacketCodec oSCPacketCodec, String string) {
        this.defaultCodec = oSCPacketCodec;
        this.protocol = string;
    }

    public static OSCServer newUsing(String string) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), string);
    }

    public static OSCServer newUsing(OSCPacketCodec oSCPacketCodec, String string) throws IOException {
        return OSCServer.newUsing(oSCPacketCodec, string, 0);
    }

    public static OSCServer newUsing(String string, int n) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), string, n);
    }

    public static OSCServer newUsing(OSCPacketCodec oSCPacketCodec, String string, int n) throws IOException {
        return OSCServer.newUsing(oSCPacketCodec, string, n, false);
    }

    public static OSCServer newUsing(String string, int n, boolean bl) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), string, n, bl);
    }

    public static OSCServer newUsing(OSCPacketCodec oSCPacketCodec, String string, int n, boolean bl) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(bl ? "127.0.0.1" : "0.0.0.0", n);
        return OSCServer.newUsing(oSCPacketCodec, string, inetSocketAddress);
    }

    public static OSCServer newUsing(String string, InetSocketAddress inetSocketAddress) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), string, inetSocketAddress);
    }

    public static OSCServer newUsing(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress) throws IOException {
        if (string.equals("udp")) {
            return new UDPOSCServer(oSCPacketCodec, inetSocketAddress);
        }
        if (string.equals("tcp")) {
            return new TCPOSCServer(oSCPacketCodec, inetSocketAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + string);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public abstract void send(OSCPacket var1, SocketAddress var2) throws IOException;

    public abstract void sendAll(OSCPacket var1) throws IOException;

    public abstract void addOSCListener(OSCListener var1);

    public abstract void removeOSCListener(OSCListener var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.add(oSCConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.remove(oSCConnectionListener);
        }
    }

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract boolean isActive();

    @Override
    public abstract void stop() throws IOException;

    @Override
    public abstract void setBufferSize(int var1);

    @Override
    public abstract int getBufferSize();

    @Override
    public void setCodec(OSCPacketCodec oSCPacketCodec) {
        this.defaultCodec = oSCPacketCodec;
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.defaultCodec;
    }

    public abstract void setCodec(OSCPacketCodec var1, SocketAddress var2) throws IOException;

    public abstract OSCPacketCodec getCodec(SocketAddress var1) throws IOException;

    @Override
    public final void dumpOSC(int n, PrintStream printStream) {
        this.dumpIncomingOSC(n, printStream);
        this.dumpOutgoingOSC(n, printStream);
    }

    @Override
    public abstract void dumpIncomingOSC(int var1, PrintStream var2);

    @Override
    public abstract void dumpOutgoingOSC(int var1, PrintStream var2);

    @Override
    public abstract void dispose();

    protected InetSocketAddress getLocalAddress(InetAddress inetAddress, int n) throws UnknownHostException {
        return new InetSocketAddress(inetAddress.getHostName().equals("0.0.0.0") ? InetAddress.getLocalHost() : inetAddress, n);
    }

    private static class TCPOSCServer
    extends OSCServer
    implements Runnable,
    OSCListener {
        private final Map<SocketAddress, OSCReceiver> mapRcv = new HashMap<SocketAddress, OSCReceiver>();
        private final Map<SocketAddress, OSCTransmitter> mapTrns = new HashMap<SocketAddress, OSCTransmitter>();
        private final List<OSCListener> collListeners = new ArrayList<OSCListener>();
        private Thread thread = null;
        private final Object startStopSync = new Object();
        private final Object threadSync = new Object();
        private final Object connSync = new Object();
        private boolean isListening = false;
        private int bufSize = 8192;
        private int inMode = 0;
        private int outMode = 0;
        private PrintStream inStream = null;
        private PrintStream outStream = null;
        private final ServerSocketChannel ssch = ServerSocketChannel.open();

        protected TCPOSCServer(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) throws IOException {
            super(oSCPacketCodec, "tcp");
            this.ssch.socket().bind(inetSocketAddress);
        }

        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            ServerSocket serverSocket = this.ssch.socket();
            return this.getLocalAddress(serverSocket.getInetAddress(), serverSocket.getLocalPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOSCListener(OSCListener oSCListener) {
            List<OSCListener> list = this.collListeners;
            synchronized (list) {
                this.collListeners.add(oSCListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOSCListener(OSCListener oSCListener) {
            List<OSCListener> list = this.collListeners;
            synchronized (list) {
                this.collListeners.remove(oSCListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCodec(OSCPacketCodec oSCPacketCodec) {
            Object object = this.connSync;
            synchronized (object) {
                for (OSCTransmitter oSCTransmitter : this.mapTrns.values()) {
                    if (oSCTransmitter.getCodec() != this.defaultCodec) continue;
                    oSCTransmitter.setCodec(oSCPacketCodec);
                }
            }
            super.setCodec(oSCPacketCodec);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCodec(OSCPacketCodec oSCPacketCodec, SocketAddress socketAddress) throws IOException {
            OSCTransmitter oSCTransmitter;
            Object object = this.connSync;
            synchronized (object) {
                oSCTransmitter = this.mapTrns.get(socketAddress);
            }
            if (oSCTransmitter == null) {
                throw new NotYetConnectedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OSCPacketCodec getCodec(SocketAddress socketAddress) throws IOException {
            OSCTransmitter oSCTransmitter;
            Object object = this.connSync;
            synchronized (object) {
                oSCTransmitter = this.mapTrns.get(socketAddress);
            }
            if (oSCTransmitter == null) {
                throw new NotYetConnectedException();
            }
            return oSCTransmitter.getCodec();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws IOException {
            Object object = this.startStopSync;
            synchronized (object) {
                if (Thread.currentThread() == this.thread) {
                    throw new IllegalStateException("Cannot call startListening() in the server body thread");
                }
                if (this.isListening && (this.thread == null || !this.thread.isAlive())) {
                    this.isListening = false;
                }
                if (!this.isListening) {
                    this.isListening = true;
                    this.thread = new Thread((Runnable)this, "TCPServerBody");
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() throws IOException {
            Object object = this.startStopSync;
            synchronized (object) {
                if (Thread.currentThread() == this.thread) {
                    throw new IllegalStateException("Cannot call stopListening() in the server body thread");
                }
                if (this.isListening) {
                    this.isListening = false;
                    if (this.thread != null && this.thread.isAlive()) {
                        try {
                            Object object2 = this.threadSync;
                            synchronized (object2) {
                                SocketChannel socketChannel = SocketChannel.open();
                                socketChannel.connect(this.ssch.socket().getLocalSocketAddress());
                                socketChannel.close();
                                this.threadSync.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            NetUtil.log(Level.WARNING, "", interruptedException);
                        }
                        catch (IOException iOException) {
                            NetUtil.log(Level.WARNING, "", iOException);
                            throw iOException;
                        }
                        finally {
                            if (this.thread != null && this.thread.isAlive()) {
                                try {
                                    NetUtil.log(Level.WARNING, "TCPServerBody.stopListening : rude task killing (" + this.hashCode() + ")");
                                    this.ssch.close();
                                }
                                catch (IOException iOException) {
                                    NetUtil.log(Level.SEVERE, "TCPServerBody.stopListening 2: ", iOException);
                                }
                            }
                            this.thread = null;
                            this.stopAll();
                        }
                    }
                }
            }
        }

        @Override
        public boolean isActive() {
            return this.isListening;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
            OSCTransmitter oSCTransmitter;
            Object object = this.connSync;
            synchronized (object) {
                oSCTransmitter = this.mapTrns.get(socketAddress);
                if (oSCTransmitter == null) {
                    throw new NotYetConnectedException();
                }
                if (!oSCTransmitter.isConnected()) {
                    this.mapTrns.remove(socketAddress);
                    throw new NotYetConnectedException();
                }
            }
            oSCTransmitter.send(oSCPacket);
        }

        @Override
        public void sendAll(OSCPacket oSCPacket) throws IOException {
            IOException iOException = null;
            for (OSCTransmitter oSCTransmitter : this.mapTrns.values()) {
                try {
                    oSCTransmitter.send(oSCPacket);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }

        @Override
        public void dispose() {
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ssch.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAll() {
            Object object = this.connSync;
            synchronized (object) {
                for (OSCReceiver oSCChannel : new LinkedList<OSCReceiver>(this.mapRcv.values())) {
                    oSCChannel.dispose();
                }
                this.mapRcv.clear();
                for (OSCTransmitter oSCTransmitter : new LinkedList<OSCTransmitter>(this.mapTrns.values())) {
                    oSCTransmitter.dispose();
                }
                this.mapTrns.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBufferSize(int n) {
            Object object = this.connSync;
            synchronized (object) {
                this.bufSize = n;
                for (OSCReceiver oSCChannel : this.mapRcv.values()) {
                    oSCChannel.setBufferSize(n);
                }
                for (OSCTransmitter oSCTransmitter : this.mapTrns.values()) {
                    oSCTransmitter.setBufferSize(n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBufferSize() {
            Object object = this.connSync;
            synchronized (object) {
                return this.bufSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpIncomingOSC(int n, PrintStream printStream) {
            Object object = this.connSync;
            synchronized (object) {
                this.inMode = n;
                this.inStream = printStream;
                for (OSCReceiver oSCReceiver : this.mapRcv.values()) {
                    oSCReceiver.dumpOSC(n, printStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpOutgoingOSC(int n, PrintStream printStream) {
            Object object = this.connSync;
            synchronized (object) {
                this.outMode = n;
                this.outStream = printStream;
                for (OSCTransmitter oSCTransmitter : this.mapTrns.values()) {
                    oSCTransmitter.dumpOSC(n, printStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            block19: while (true) {
                while (this.isListening) {
                    Object object2;
                    try {
                        SocketChannel socketChannel = this.ssch.accept();
                        if (!this.isListening) {
                            return;
                        }
                        if (socketChannel == null) continue;
                        SocketAddress socketAddress = socketChannel.socket().getRemoteSocketAddress();
                        object = this.connSync;
                        synchronized (object) {
                            object2 = (InetSocketAddress)socketChannel.getLocalAddress();
                            InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                            for (OSCConnectionListener oSCConnectionListener : this.connListeners) {
                                oSCConnectionListener.onConnected((InetSocketAddress)object2, inetSocketAddress);
                            }
                            OSCReceiver oSCReceiver = OSCReceiver.newUsing(this.defaultCodec, socketChannel);
                            oSCReceiver.setBufferSize(this.bufSize);
                            this.mapRcv.put(socketAddress, oSCReceiver);
                            oSCReceiver.addConnectionListener(new OSCConnectionListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onDisconnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                                    OSCConnectionListener[] oSCConnectionListenerArray = TCPOSCServer.this.connSync;
                                    synchronized (oSCConnectionListenerArray) {
                                        TCPOSCServer.this.mapRcv.remove(inetSocketAddress2);
                                    }
                                    OSCConnectionListener[] oSCConnectionListenerArray2 = TCPOSCServer.this.connListeners;
                                    synchronized (TCPOSCServer.this.connListeners) {
                                        oSCConnectionListenerArray = new OSCConnectionListener[TCPOSCServer.this.connListeners.size()];
                                        TCPOSCServer.this.connListeners.toArray(oSCConnectionListenerArray);
                                        // ** MonitorExit[var4_5] (shouldn't be in output)
                                        for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray) {
                                            oSCConnectionListener.onDisconnected(inetSocketAddress, inetSocketAddress2);
                                        }
                                        return;
                                    }
                                }

                                @Override
                                public void onConnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                                }
                            });
                            OSCTransmitter oSCTransmitter = OSCTransmitter.newUsing(this.defaultCodec, socketChannel);
                            oSCTransmitter.setBufferSize(this.bufSize);
                            this.mapTrns.put(socketAddress, oSCTransmitter);
                            oSCTransmitter.addConnectionListener(new OSCConnectionListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onDisconnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                                    OSCConnectionListener[] oSCConnectionListenerArray = TCPOSCServer.this.connSync;
                                    synchronized (oSCConnectionListenerArray) {
                                        TCPOSCServer.this.mapTrns.remove(inetSocketAddress2);
                                    }
                                    OSCConnectionListener[] oSCConnectionListenerArray2 = TCPOSCServer.this.connListeners;
                                    synchronized (TCPOSCServer.this.connListeners) {
                                        oSCConnectionListenerArray = new OSCConnectionListener[TCPOSCServer.this.connListeners.size()];
                                        TCPOSCServer.this.connListeners.toArray(oSCConnectionListenerArray);
                                        // ** MonitorExit[var4_5] (shouldn't be in output)
                                        for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray) {
                                            oSCConnectionListener.onDisconnected(inetSocketAddress, inetSocketAddress2);
                                        }
                                        return;
                                    }
                                }

                                @Override
                                public void onConnected(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
                                }
                            });
                            oSCReceiver.dumpOSC(this.inMode, this.inStream);
                            oSCTransmitter.dumpOSC(this.outMode, this.outStream);
                            oSCReceiver.addOSCListener(this);
                            oSCReceiver.startListening();
                        }
                    }
                    catch (ClosedChannelException closedChannelException) {
                        if (this.isListening) {
                            NetUtil.log(Level.WARNING, "", closedChannelException);
                        }
                        object2 = this.threadSync;
                        synchronized (object2) {
                            this.thread = null;
                            this.threadSync.notifyAll();
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (!this.isListening) continue block19;
                            NetUtil.log(Level.WARNING, "", iOException);
                            continue block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                object = this.threadSync;
                synchronized (object) {
                    this.thread = null;
                    this.threadSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(OSCMessage oSCMessage, SocketAddress socketAddress, long l) {
            List<OSCListener> list = this.collListeners;
            synchronized (list) {
                for (OSCListener oSCListener : this.collListeners) {
                    oSCListener.messageReceived(oSCMessage, socketAddress, l);
                }
            }
        }
    }

    private static class UDPOSCServer
    extends OSCServer {
        private final OSCReceiver rcv;
        private final OSCTransmitter trns;
        private final InetSocketAddress localAddress;

        protected UDPOSCServer(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) throws IOException {
            super(oSCPacketCodec, "udp");
            this.localAddress = inetSocketAddress;
            this.rcv = OSCReceiver.newUsing(oSCPacketCodec, "udp", inetSocketAddress);
            this.trns = OSCTransmitter.newUsing(oSCPacketCodec, "udp", inetSocketAddress);
        }

        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            return this.rcv.getLocalAddress();
        }

        @Override
        public void addOSCListener(OSCListener oSCListener) {
            this.rcv.addOSCListener(oSCListener);
        }

        @Override
        public void removeOSCListener(OSCListener oSCListener) {
            this.rcv.removeOSCListener(oSCListener);
        }

        @Override
        public void setCodec(OSCPacketCodec oSCPacketCodec) {
            this.rcv.setCodec(oSCPacketCodec);
            this.trns.setCodec(oSCPacketCodec);
            super.setCodec(oSCPacketCodec);
        }

        @Override
        public void setCodec(OSCPacketCodec oSCPacketCodec, SocketAddress socketAddress) throws IOException {
            throw new IOException("Not supported in UDP mode");
        }

        @Override
        public OSCPacketCodec getCodec(SocketAddress socketAddress) throws IOException {
            throw new IOException("Not supported in UDP mode");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws IOException {
            if (!this.trns.isConnected()) {
                this.trns.connect();
                this.rcv.setChannel(this.trns.getChannel());
            }
            this.rcv.startListening();
            OSCConnectionListener[] oSCConnectionListenerArray = this.connListeners;
            synchronized (this.connListeners) {
                OSCConnectionListener[] oSCConnectionListenerArray2 = new OSCConnectionListener[this.connListeners.size()];
                this.connListeners.toArray(oSCConnectionListenerArray2);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray2) {
                    oSCConnectionListener.onConnected(this.localAddress, null);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() throws IOException {
            this.rcv.stopListening();
            OSCConnectionListener[] oSCConnectionListenerArray = this.connListeners;
            synchronized (this.connListeners) {
                OSCConnectionListener[] oSCConnectionListenerArray2 = new OSCConnectionListener[this.connListeners.size()];
                this.connListeners.toArray(oSCConnectionListenerArray2);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray2) {
                    oSCConnectionListener.onDisconnected(this.localAddress, null);
                }
                return;
            }
        }

        @Override
        public boolean isActive() {
            return this.rcv.isListening();
        }

        @Override
        public void send(OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
            this.trns.send(oSCPacket, socketAddress);
        }

        @Override
        public void sendAll(OSCPacket oSCPacket) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.rcv.dispose();
            this.trns.dispose();
            OSCConnectionListener[] oSCConnectionListenerArray = this.connListeners;
            synchronized (this.connListeners) {
                OSCConnectionListener[] oSCConnectionListenerArray2 = new OSCConnectionListener[this.connListeners.size()];
                this.connListeners.toArray(oSCConnectionListenerArray2);
                this.connListeners.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray2) {
                    oSCConnectionListener.onDisconnected(this.localAddress, null);
                }
                return;
            }
        }

        @Override
        public void setBufferSize(int n) {
            this.rcv.setBufferSize(n);
            this.trns.setBufferSize(n);
        }

        @Override
        public int getBufferSize() {
            return this.rcv.getBufferSize();
        }

        @Override
        public void dumpIncomingOSC(int n, PrintStream printStream) {
            this.rcv.dumpOSC(n, printStream);
        }

        @Override
        public void dumpOutgoingOSC(int n, PrintStream printStream) {
            this.trns.dumpOSC(n, printStream);
        }
    }
}

