/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.NetUtil;
import de.sciss.net.OSCChannel;
import de.sciss.net.OSCConnectionListener;
import de.sciss.net.OSCException;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class OSCTransmitter
implements OSCChannel {
    protected final List<OSCConnectionListener> connListeners = new ArrayList<OSCConnectionListener>();
    protected final Object sync = new Object();
    protected boolean allocBuf = true;
    private int bufSize = 8192;
    protected ByteBuffer byteBuf = null;
    protected int dumpMode = 0;
    protected PrintStream printStream = null;
    private OSCPacketCodec c;
    private final String protocol;
    protected SocketAddress target = null;
    protected final InetSocketAddress localAddress;
    protected final boolean revivable;

    protected OSCTransmitter(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress, boolean bl) {
        this.c = oSCPacketCodec;
        this.protocol = string;
        this.localAddress = inetSocketAddress;
        this.revivable = bl;
    }

    public static OSCTransmitter newUsing(String string) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), string);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, String string) throws IOException {
        return OSCTransmitter.newUsing(oSCPacketCodec, string, 0);
    }

    public static OSCTransmitter newUsing(String string, int n) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), string, n);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, String string, int n) throws IOException {
        return OSCTransmitter.newUsing(oSCPacketCodec, string, n, false);
    }

    public static OSCTransmitter newUsing(String string, int n, boolean bl) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), string, n, bl);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, String string, int n, boolean bl) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(bl ? "127.0.0.1" : "0.0.0.0", n);
        return OSCTransmitter.newUsing(oSCPacketCodec, string, inetSocketAddress);
    }

    public static OSCTransmitter newUsing(String string, InetSocketAddress inetSocketAddress) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), string, inetSocketAddress);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, String string, InetSocketAddress inetSocketAddress) throws IOException {
        if (string.equals("udp")) {
            return new UDPOSCTransmitter(oSCPacketCodec, inetSocketAddress);
        }
        if (string.equals("tcp")) {
            return new TCPOSCTransmitter(oSCPacketCodec, inetSocketAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + string);
    }

    public static OSCTransmitter newUsing(DatagramChannel datagramChannel) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), datagramChannel);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, DatagramChannel datagramChannel) throws IOException {
        return new UDPOSCTransmitter(oSCPacketCodec, datagramChannel);
    }

    public static OSCTransmitter newUsing(SocketChannel socketChannel) throws IOException {
        return OSCTransmitter.newUsing(OSCPacketCodec.getDefaultCodec(), socketChannel);
    }

    public static OSCTransmitter newUsing(OSCPacketCodec oSCPacketCodec, SocketChannel socketChannel) throws IOException {
        return new TCPOSCTransmitter(oSCPacketCodec, socketChannel);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public void setTarget(SocketAddress socketAddress) {
        this.target = socketAddress;
    }

    @Override
    public void setCodec(OSCPacketCodec oSCPacketCodec) {
        this.c = oSCPacketCodec;
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.add(oSCConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(OSCConnectionListener oSCConnectionListener) {
        List<OSCConnectionListener> list = this.connListeners;
        synchronized (list) {
            this.connListeners.remove(oSCConnectionListener);
        }
    }

    public abstract void connect() throws IOException;

    protected InetSocketAddress getLocalAddress(InetAddress inetAddress, int n) throws UnknownHostException {
        return new InetSocketAddress(inetAddress.getHostName().equals("0.0.0.0") ? InetAddress.getLocalHost() : inetAddress, n);
    }

    public abstract boolean isConnected();

    public final void send(OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
        this.send(this.c, oSCPacket, socketAddress);
    }

    public abstract void send(OSCPacketCodec var1, OSCPacket var2, SocketAddress var3) throws IOException;

    public final void send(OSCPacket oSCPacket) throws IOException {
        this.send(oSCPacket, this.target);
    }

    public abstract void send(OSCPacketCodec var1, OSCPacket var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferSize(int n) {
        Object object = this.sync;
        synchronized (object) {
            if (this.bufSize != n) {
                this.bufSize = n;
                this.allocBuf = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferSize() {
        Object object = this.sync;
        synchronized (object) {
            return this.bufSize;
        }
    }

    @Override
    public void dumpOSC(int n, PrintStream printStream) {
        this.dumpMode = n;
        this.printStream = printStream == null ? System.err : printStream;
    }

    @Override
    public void dispose() {
        this.byteBuf = null;
    }

    protected void checkBuffer() {
        if (this.allocBuf) {
            this.byteBuf = ByteBuffer.allocateDirect(this.bufSize);
            this.allocBuf = false;
        }
    }

    protected abstract SelectableChannel getChannel();

    private static class TCPOSCTransmitter
    extends OSCTransmitter {
        private SocketChannel sch;

        protected TCPOSCTransmitter(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) {
            super(oSCPacketCodec, "tcp", inetSocketAddress, true);
        }

        protected TCPOSCTransmitter(OSCPacketCodec oSCPacketCodec, SocketChannel socketChannel) {
            super(oSCPacketCodec, "tcp", new InetSocketAddress(socketChannel.socket().getLocalAddress(), socketChannel.socket().getLocalPort()), false);
            this.sch = socketChannel;
            if (socketChannel.isConnected()) {
                this.setTarget(socketChannel.socket().getRemoteSocketAddress());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws UnknownHostException {
            Object object = this.sync;
            synchronized (object) {
                if (this.sch != null) {
                    Socket socket = this.sch.socket();
                    return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        protected void setChannel(SelectableChannel selectableChannel) {
            this.sch = (SocketChannel)selectableChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SelectableChannel getChannel() {
            Object object = this.sync;
            synchronized (object) {
                return this.sch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            OSCConnectionListener[] oSCConnectionListenerArray;
            Object object = this.sync;
            synchronized (object) {
                Object object2;
                if (this.sch != null && !this.sch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.sch = null;
                }
                if (this.sch == null) {
                    object2 = SocketChannel.open();
                    ((SocketChannel)object2).socket().bind(this.localAddress);
                    this.sch = object2;
                }
                if (!this.sch.isConnected()) {
                    this.sch.connect(this.target);
                    object2 = this.connListeners;
                    synchronized (object2) {
                        oSCConnectionListenerArray = new OSCConnectionListener[this.connListeners.size()];
                        this.connListeners.toArray(oSCConnectionListenerArray);
                    }
                } else {
                    oSCConnectionListenerArray = null;
                }
            }
            if (oSCConnectionListenerArray != null) {
                object = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray) {
                    oSCConnectionListener.onConnected(this.localAddress, (InetSocketAddress)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.sync;
            synchronized (object) {
                return this.sch != null && this.sch.isConnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispose() {
            super.dispose();
            if (this.sch == null) return;
            try {
                this.sch.close();
            }
            catch (IOException iOException) {
                NetUtil.log(Level.SEVERE, "", iOException);
            }
            this.sch = null;
            InetSocketAddress inetSocketAddress = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
            OSCConnectionListener[] oSCConnectionListenerArray = this.connListeners;
            synchronized (this.connListeners) {
                OSCConnectionListener[] oSCConnectionListenerArray2 = new OSCConnectionListener[this.connListeners.size()];
                this.connListeners.toArray(oSCConnectionListenerArray2);
                this.connListeners.clear();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray2) {
                    oSCConnectionListener.onDisconnected(this.localAddress, inetSocketAddress);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(OSCPacketCodec oSCPacketCodec, OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                if (socketAddress != null && !socketAddress.equals(this.target)) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotBoundToAddress") + socketAddress);
                }
                this.send(oSCPacketCodec, oSCPacket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(OSCPacketCodec oSCPacketCodec, OSCPacket oSCPacket) throws IOException {
            try {
                Object object = this.sync;
                synchronized (object) {
                    if (this.sch == null) {
                        throw new IOException(NetUtil.getResourceString("errChannelNotConnected"));
                    }
                    this.checkBuffer();
                    this.byteBuf.clear();
                    this.byteBuf.position(4);
                    oSCPacketCodec.encode(oSCPacket, this.byteBuf);
                    int n = this.byteBuf.position() - 4;
                    this.byteBuf.flip();
                    this.byteBuf.putInt(0, n);
                    if (this.dumpMode != 0) {
                        this.printStream.print("s: ");
                        if ((this.dumpMode & 1) != 0) {
                            OSCPacket.printTextOn(this.printStream, oSCPacket);
                        }
                        if ((this.dumpMode & 2) != 0) {
                            OSCPacket.printHexOn(this.printStream, this.byteBuf);
                            this.byteBuf.flip();
                        }
                    }
                    this.sch.write(this.byteBuf);
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OSCException(2, oSCPacket instanceof OSCMessage ? ((OSCMessage)oSCPacket).getName() : oSCPacket.getClass().getName());
            }
        }
    }

    private static class UDPOSCTransmitter
    extends OSCTransmitter {
        private DatagramChannel dch;

        protected UDPOSCTransmitter(OSCPacketCodec oSCPacketCodec, InetSocketAddress inetSocketAddress) {
            super(oSCPacketCodec, "udp", inetSocketAddress, true);
        }

        protected UDPOSCTransmitter(OSCPacketCodec oSCPacketCodec, DatagramChannel datagramChannel) {
            super(oSCPacketCodec, "udp", new InetSocketAddress(datagramChannel.socket().getLocalAddress(), datagramChannel.socket().getLocalPort()), false);
            this.dch = datagramChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SelectableChannel getChannel() {
            Object object = this.sync;
            synchronized (object) {
                return this.dch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws UnknownHostException {
            Object object = this.sync;
            synchronized (object) {
                if (this.dch != null) {
                    DatagramSocket datagramSocket = this.dch.socket();
                    return new InetSocketAddress(datagramSocket.getLocalAddress(), datagramSocket.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            OSCConnectionListener[] oSCConnectionListenerArray;
            Object object = this.sync;
            synchronized (object) {
                if (this.dch != null && !this.dch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.dch = null;
                }
                if (this.dch == null) {
                    DatagramChannel datagramChannel = DatagramChannel.open();
                    datagramChannel.socket().bind(this.localAddress);
                    if (!datagramChannel.socket().getBroadcast()) {
                        try {
                            datagramChannel.socket().setBroadcast(true);
                        }
                        catch (SocketException socketException) {
                            // empty catch block
                        }
                    }
                    this.dch = datagramChannel;
                    List list = this.connListeners;
                    synchronized (list) {
                        oSCConnectionListenerArray = new OSCConnectionListener[this.connListeners.size()];
                        this.connListeners.toArray(oSCConnectionListenerArray);
                    }
                }
                oSCConnectionListenerArray = null;
            }
            if (oSCConnectionListenerArray != null) {
                object = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
                for (DatagramChannel datagramChannel : oSCConnectionListenerArray) {
                    datagramChannel.onDisconnected(this.localAddress, (InetSocketAddress)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.sync;
            synchronized (object) {
                return this.dch != null && this.dch.isOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispose() {
            super.dispose();
            if (this.dch == null) return;
            try {
                this.dch.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dch = null;
            InetSocketAddress inetSocketAddress = this.target instanceof InetSocketAddress ? (InetSocketAddress)this.target : null;
            OSCConnectionListener[] oSCConnectionListenerArray = this.connListeners;
            synchronized (this.connListeners) {
                OSCConnectionListener[] oSCConnectionListenerArray2 = new OSCConnectionListener[this.connListeners.size()];
                this.connListeners.toArray(oSCConnectionListenerArray2);
                this.connListeners.clear();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                for (OSCConnectionListener oSCConnectionListener : oSCConnectionListenerArray2) {
                    oSCConnectionListener.onDisconnected(this.localAddress, inetSocketAddress);
                }
                return;
            }
        }

        @Override
        public void send(OSCPacketCodec oSCPacketCodec, OSCPacket oSCPacket) throws IOException {
            this.send(oSCPacketCodec, oSCPacket, this.target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(OSCPacketCodec oSCPacketCodec, OSCPacket oSCPacket, SocketAddress socketAddress) throws IOException {
            try {
                Object object = this.sync;
                synchronized (object) {
                    if (this.dch == null) {
                        throw new IOException(NetUtil.getResourceString("errChannelNotConnected"));
                    }
                    this.checkBuffer();
                    this.byteBuf.clear();
                    oSCPacketCodec.encode(oSCPacket, this.byteBuf);
                    this.byteBuf.flip();
                    if (this.dumpMode != 0) {
                        this.printStream.print("s: ");
                        if ((this.dumpMode & 1) != 0) {
                            OSCPacket.printTextOn(this.printStream, oSCPacket);
                        }
                        if ((this.dumpMode & 2) != 0) {
                            OSCPacket.printHexOn(this.printStream, this.byteBuf);
                            this.byteBuf.flip();
                        }
                    }
                    this.dch.send(this.byteBuf, socketAddress);
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OSCException(2, oSCPacket instanceof OSCMessage ? ((OSCMessage)oSCPacket).getName() : oSCPacket.getClass().getName());
            }
        }
    }
}

