/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop;

import de.sciss.desktop.Window;
import de.sciss.swingplus.DoClickAction;
import de.sciss.swingplus.DoClickAction$;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichChar$;
import scala.swing.AbstractButton;
import scala.swing.Action;
import scala.swing.Action$;
import scala.swing.Component;
import scala.swing.Swing$;
import scala.swing.TabbedPane;
import scala.swing.event.Key;
import scala.swing.event.Key$;

public final class Util$ {
    public static final Util$ MODULE$;

    static {
        new Util$();
    }

    public void centerOnScreen(Window w) {
        this.placeWindow(w, 0.5f, 0.5f, 0);
    }

    public void delay(int millis, Function0<BoxedUnit> block) {
        Timer timer = new Timer(millis, Swing$.MODULE$.ActionListener((Function1)new Serializable(block){
            public static final long serialVersionUID = 0L;
            private final Function0 block$1;

            public final void apply(ActionEvent x$1) {
                this.block$1.apply$mcV$sp();
            }
            {
                this.block$1 = block$1;
            }
        }));
        timer.setRepeats(false);
        timer.start();
    }

    public void fixSize(Component c) {
        Dimension d = c.preferredSize();
        c.preferredSize_$eq(d);
        c.minimumSize_$eq(d);
        c.maximumSize_$eq(d);
    }

    public void fixWidth(Component c, int width) {
        Dimension pref = c.preferredSize();
        int w = width < 0 ? pref.width : width;
        Dimension min = c.minimumSize();
        Dimension max = c.maximumSize();
        pref.width = w;
        min.width = w;
        max.width = w;
        c.preferredSize_$eq(pref);
        c.minimumSize_$eq(min);
        c.maximumSize_$eq(max);
    }

    public int fixWidth$default$2() {
        return -1;
    }

    public void sameWidths(Seq<Component> c) {
        IntRef w = IntRef.create((int)0);
        c.foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final IntRef w$1;

            public final void apply(Component comp) {
                Dimension pref = comp.preferredSize();
                this.w$1.elem = package$.MODULE$.max(this.w$1.elem, pref.width);
            }
            {
                this.w$1 = w$1;
            }
        });
        c.foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final IntRef w$1;

            public final void apply(Component comp) {
                Dimension pref = comp.preferredSize();
                Dimension min = comp.minimumSize();
                Dimension max = comp.maximumSize();
                pref.width = this.w$1.elem;
                min.width = this.w$1.elem;
                max.width = this.w$1.elem;
                comp.preferredSize_$eq(pref);
                comp.minimumSize_$eq(min);
                comp.maximumSize_$eq(max);
            }
            {
                this.w$1 = w$1;
            }
        });
    }

    public Rectangle maximumWindowBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getMaximumWindowBounds();
    }

    public void placeWindow(Window w, float horizontal, float vertical, int padding) {
        Rectangle bs = this.maximumWindowBounds();
        Dimension b = w.size();
        int x = (int)(horizontal * (float)(bs.width - padding * 2 - b.width)) + bs.x + padding;
        int y = (int)(vertical * (float)(bs.height - padding * 2 - b.height)) + bs.y + padding;
        w.location_$eq(new Point(x, y));
    }

    public String wordWrap(String s, int margin) {
        int sz = s.length();
        if (sz <= margin) {
            return s;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (i < sz) {
            int j = s.lastIndexOf(" ", i + margin);
            boolean found = j > i;
            int k = found ? j : i + margin;
            sb.append(s.substring(i, package$.MODULE$.min(sz, k)));
            i = found ? k + 1 : k;
            Object object = i < sz ? sb.append('\n') : BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public int wordWrap$default$2() {
        return 80;
    }

    public String formatClassName(Class<?> x) {
        String cn0 = x.getName();
        int i = cn0.lastIndexOf(46);
        String cn = cn0.substring(i + 1);
        int len = cn.length();
        StringBuilder b = new StringBuilder(len + len / 2);
        boolean wasUpper = true;
        for (int j = 0; j < len; ++j) {
            char c = cn.charAt(j);
            boolean isUpper = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(c));
            Object object = !wasUpper && isUpper ? b.append(' ') : BoxedUnit.UNIT;
            b.append(c);
            wasUpper = isUpper;
        }
        return b.result();
    }

    public String formatException(Throwable e, int margin, int stackTraceLines) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String loc;
        String message;
        String name = e == null ? "Exception" : this.formatClassName(e.getClass());
        StringBuilder strBuf = new StringBuilder(name);
        String string = e == null ? null : (message = (loc = e.getLocalizedMessage()) == null ? e.getMessage() : loc);
        if (message == null) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            strBuf.append(":\n");
            boxedUnit2 = strBuf.append(this.wordWrap(message, margin));
        }
        if (stackTraceLines > 0) {
            String stackS = Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()).iterator().take(stackTraceLines).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StackTraceElement x$2) {
                    return new StringBuilder().append((Object)"   at ").append((Object)x$2).toString();
                }
            }).mkString("\n");
            strBuf.append("\n");
            boxedUnit = strBuf.append(stackS);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return strBuf.result();
    }

    public int formatException$default$2() {
        return 80;
    }

    public int formatException$default$3() {
        return 10;
    }

    public void setInitialFocus(Component c) {
        AncestorListener adapter = new AncestorListener(c){
            private final Component c$1;

            public void ancestorAdded(AncestorEvent e) {
                this.c$1.peer().removeAncestorListener(this);
                this.c$1.requestFocusInWindow();
            }

            public void ancestorMoved(AncestorEvent e) {
            }

            public void ancestorRemoved(AncestorEvent e) {
            }
            {
                this.c$1 = c$1;
            }
        };
        c.peer().addAncestorListener(adapter);
    }

    public void addGlobalKey(AbstractButton b, KeyStroke keyStroke) {
        DoClickAction click = DoClickAction$.MODULE$.apply(b);
        b.peer().getActionMap().put("click", click.peer());
        b.peer().getInputMap(2).put(keyStroke, "click");
    }

    public void addGlobalKeyWhenVisible(AbstractButton b, KeyStroke keyStroke) {
        Action click = Action$.MODULE$.apply(null, (Function0)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final AbstractButton b$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.b$1.showing()) {
                    this.b$1.doClick();
                }
            }
            {
                this.b$1 = b$1;
            }
        });
        b.peer().getActionMap().put("click", click.peer());
        b.peer().getInputMap(2).put(keyStroke, "click");
    }

    public void addGlobalAction(Component c, String name, KeyStroke keyStroke, Function0<BoxedUnit> body) {
        Action a = Action$.MODULE$.apply(null, body);
        c.peer().getActionMap().put(name, a.peer());
        c.peer().getInputMap(2).put(keyStroke, name);
    }

    public void addTabNavigation(TabbedPane tabs) {
        this.addGlobalAction((Component)tabs, "prev", KeyStroke.getKeyStroke(Key$.MODULE$.Left().id(), Key.Modifier$.MODULE$.Alt()), (Function0<BoxedUnit>)new Serializable(tabs){
            public static final long serialVersionUID = 0L;
            private final TabbedPane tabs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TabbedPane.selection$ sel;
                int idx = (sel = this.tabs$1.selection()).index() - 1;
                sel.index_$eq(idx >= 0 ? idx : this.tabs$1.pages().size() - 1);
            }
            {
                this.tabs$1 = tabs$1;
            }
        });
        this.addGlobalAction((Component)tabs, "next", KeyStroke.getKeyStroke(Key$.MODULE$.Right().id(), Key.Modifier$.MODULE$.Alt()), (Function0<BoxedUnit>)new Serializable(tabs){
            public static final long serialVersionUID = 0L;
            private final TabbedPane tabs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TabbedPane.selection$ sel;
                int idx = (sel = this.tabs$1.selection()).index() + 1;
                sel.index_$eq(idx < this.tabs$1.pages().size() ? idx : 0);
            }
            {
                this.tabs$1 = tabs$1;
            }
        });
    }

    public String keyStrokeText(KeyStroke stroke) {
        BoxedUnit boxedUnit;
        int mod = stroke.getModifiers();
        StringBuilder sb = new StringBuilder();
        if (mod > 0) {
            sb.append(KeyEvent.getKeyModifiersText(mod));
            boxedUnit = sb.append('+');
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        sb.append(KeyEvent.getKeyText(stroke.getKeyCode()));
        return sb.result();
    }

    private Util$() {
        MODULE$ = this;
    }
}

