# Binary Operator

<BLOCKQUOTE>Two input files (real or complex) are connected via a simple binary operator on a sample by
sample basis, like adding, multiplying, taking the minimum etc. Can also be used to create
a trimmed version of a sound.</BLOCKQUOTE>

## Parameters

_Input file 1:_ First sound file, check _\[Imaginary\]_ to provide complex files such as generated by the _Fourier Translation_ module.

_Offset/Length:_ Allows you to trim the processed input file. Positive offset cuts away the beginning of the sound, negative offset inserts silence before the start of the sound. Length means total length (including offset).

_Drive:_ Used for balancing the two input files. Applied before processing.

_Rectify/Invert:_ Rectify takes the absolute value of each sample, Invert inverts all samples (positive samples become negative and vice versa). Inversion allows the 'Addition' operation to become effectively a 'Subtraction' etc.

_Input file 2:_ Same settings for the second input file.

_Output file:_ Output of the binary operation between input 1 and input 2, possibly complex.

_Operator:_ The kind of sample-by-sample operation performed between the two inputs (sometimes represented by the letters 'a' and 'b'). 'Re' and 'Im' stand for real and imaginary part in case of complex files. Note that not all operators are implemented at the moment, some don't work with complex files.<br>'Power' means input 1 to the power of input 2.<br>AND/OR/XOR are binary logical operators performed by scaling the inputs to 24 bit(?) integer samples. May be useful in the fourier domain.<br>'Gate' means to take sample from input 1 if it is greater than sample from input 2, otherwise zero.<br>'ArcTangens' is arctan(input1/input2)/pi. Useful in the fourier domain(?) or for images.

_Output mix:_ Optionally mix the operator output with the dry input 1 signal (possibly inverted for subtraction).

## Notes

To operate only on a single file, use the _Unary Operator_ module.