/* *******************************************************
 * 
 * name:          Selection.java
 * 
 * description:   fields and functions defining
 *                a selection in JaWavedit
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

/**
* Fields and methods defining a selection of a wave.
* <br>The values start and end are in samples.
* They are inclusive, ie sample <end> is the last sample included
* in this selection.
* <br>
* champs et methodes pour la selection <br>
* les valeur de Debut et Fin sont en echantillons
* et sont inclusives.
*/

public class Selection {

  public static final int BOTH=0;
  public static final int LEFT=1;
  public static final int RIGHT=2;
  public int start=0;
  public int end=0;
  public int side=BOTH;

  /**
  * Returns whether this selection defines one point.
  * <br>This is the case, when you clicked once in a graph,
  * the point is marked as a green line.<br>
  * The definition is: (start=end) => one point is selected.
  * <br>
  * S'il y a une selection et si Debut == Fin <br>
  *  alors un point est selectionne.
  */
  public boolean onePoint() {
    return (start==end);
  }
  /**
  * Returns the point of the selection.
  * If there is not defined a point but rather a range,
  * <start> is returned.
  * <br>
  * retourne le point de la selection.
  */
  public int getPoint() {
    return start;
  }
  /**
  * Sets this selection to one point.
  * <br>
  * etabli les coordonnees du point selectionne.
  */
  public void setPoint(int pos) {
    start=pos;
    end=pos;
  }
 /**
  * Returns length of this selection.
  * <br>
  * renvoie la taille de la selection.
  * @see #setPoint()
  */
  public int getLength() {
    return end-start+1;
  }
  
  /**
  * Makes a copy of this selection to Dest.
  * <br>
  * copie conforme de la selection.
  */
  public void copyItself(Selection Dest) {
    if (Dest!=null) {
      Dest.start=start;
      Dest.end=end;
      Dest.side=side;
    }
  }

}
