/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.load;

import ch.laoe.audio.AudioException;
import ch.laoe.audio.load.ALoad;
import ch.laoe.audio.load.ALoadPcmSigned16BitBigEndian;
import ch.laoe.audio.load.ALoadPcmSigned16BitLittleEndian;
import ch.laoe.audio.load.ALoadPcmSigned8Bit;
import ch.laoe.audio.load.ALoadPcmUnsigned16BitBigEndian;
import ch.laoe.audio.load.ALoadPcmUnsigned16BitLittleEndian;
import ch.laoe.audio.load.ALoadPcmUnsigned8Bit;
import ch.laoe.audio.load.ALoadUlaw8Bit;
import ch.laoe.ui.Debug;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.FormatConversionProvider;

public class ALoadFactory {
    private static ArrayList<ALoad> classList;

    private static void preloadClasses() {
        classList = new ArrayList();
        classList.add(new ALoadPcmUnsigned8Bit());
        classList.add(new ALoadPcmSigned8Bit());
        classList.add(new ALoadPcmUnsigned16BitLittleEndian());
        classList.add(new ALoadPcmUnsigned16BitBigEndian());
        classList.add(new ALoadPcmSigned16BitLittleEndian());
        classList.add(new ALoadPcmSigned16BitBigEndian());
        classList.add(new ALoadUlaw8Bit());
    }

    public static final ALoad create(File file) throws AudioException {
        try {
            AudioFormat audioFormat;
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            if (file.getName().toLowerCase().endsWith(".mp3")) {
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioInputStream.getFormat().getSampleRate(), 16, audioInputStream.getFormat().getChannels(), audioInputStream.getFormat().getChannels() * 2, audioInputStream.getFormat().getSampleRate(), false);
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
            } else if (file.getName().toLowerCase().endsWith(".ogg")) {
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioInputStream.getFormat().getSampleRate(), 16, audioInputStream.getFormat().getChannels(), audioInputStream.getFormat().getChannels() * 2, audioInputStream.getFormat().getSampleRate(), false);
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        audioInputStream = ((FormatConversionProvider)Class.forName("javazoom.spi.vorbis.sampled.convert.VorbisFormatConversionProvider").newInstance()).getAudioInputStream(audioFormat, audioInputStream);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            audioFormat = audioInputStream.getFormat();
            Debug.println(3, "audioformat = " + audioFormat.toString());
            int n = (int)(audioInputStream.getFrameLength() * (long)audioFormat.getFrameSize() / (long)audioFormat.getChannels() / (long)(audioFormat.getSampleSizeInBits() >> 3));
            if (n < 0) {
                n = 1;
            }
            Debug.println(3, "sample length = " + n);
            for (int i = 0; i < classList.size(); ++i) {
                ALoad aLoad = classList.get(i);
                if (!aLoad.supports(audioFormat)) continue;
                aLoad = aLoad.duplicate();
                aLoad.setAudioInputStream(audioInputStream, n);
                aLoad.setFile(file);
                return aLoad;
            }
            Debug.println(3, "unsupported audioformat = " + audioFormat.toString());
            throw new AudioException("unsupportedAudioFormat");
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Debug.printStackTrace(5, unsupportedAudioFileException);
            throw new AudioException("unsupportedAudioFormat");
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("unsupportedAudioFormat");
        }
    }

    static {
        ALoadFactory.preloadClasses();
    }
}

