/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.load;

import ch.laoe.audio.load.ALoad;
import ch.laoe.clip.ALayer;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class ALoadUlaw8Bit
extends ALoad {
    private static float[] ulawTable = new float[128];

    @Override
    public ALoad duplicate() {
        return new ALoadUlaw8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.ULAW && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public int read(ALayer aLayer, int n, int n2) throws IOException {
        int n3 = audioInputStream.getFormat().getChannels();
        int n4 = audioInputStream.read(this.buffer, 0, n2 * n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4 / n3; ++j) {
                int n5 = j * n3 + i;
                float f = this.buffer[n5] & 0xFF;
                if (f > 128.0f) {
                    f = -f + 384.0f;
                }
                f = (f -= 128.0f) > 0.0f ? ulawTable[(int)f] * 32768.0f : -ulawTable[Math.abs((int)f)] * 32768.0f;
                aLayer.getChannel(i).setSample(n + j, f);
            }
        }
        if (n4 >= 0) {
            return n4 / n3;
        }
        return n4;
    }

    @Override
    public int getSampleWidth() {
        return 16;
    }

    static {
        for (int i = 0; i < ulawTable.length; ++i) {
            ALoadUlaw8Bit.ulawTable[i] = (float)((Math.exp(Math.log(256.0) * (double)i / 128.0) - 1.0) / 255.0);
        }
    }
}

