/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ASelection;
import ch.laoe.clip.ASelectionPlotter;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import java.util.ArrayList;

public class AChannelSelection
extends ASelection {
    private static int nameCounter;
    private ASelectionPlotter plotter = new ASelectionPlotter(this);
    private int offset;
    private int length;
    private ArrayList<Point> intensityPoints;
    private boolean intensityUsed = false;
    private int activeIntensityPointIndex = -1;
    public static final int LINEAR_INTENSITY_SCALE = 1;
    public static final int SQUARE_INTENSITY_SCALE = 2;
    public static final int CUBIC_INTENSITY_SCALE = 3;
    public static final int SQUARE_ROOT_INTENSITY_SCALE = -1;
    private static int intensityScale;
    private MMArray px;
    private MMArray py;
    private boolean intensityChanged;

    public AChannelSelection(AChannel aChannel) {
        super(aChannel);
        this.initIntensityPoints();
    }

    public AChannelSelection() {
        super(null);
        this.initIntensityPoints();
        this.length = 0;
    }

    public AChannelSelection(AChannel aChannel, int n, int n2) {
        this(aChannel);
        this.setOffset(n);
        this.setLength(n2);
    }

    public AChannelSelection(AChannelSelection aChannelSelection) {
        this((AChannel)aChannelSelection.model);
        this.name = aChannelSelection.name;
        this.offset = aChannelSelection.offset;
        this.length = aChannelSelection.length;
        this.plotter = aChannelSelection.plotter;
        this.intensityPoints = new ArrayList();
        for (int i = 0; i < aChannelSelection.getIntensityPoints().size(); ++i) {
            this.intensityPoints.add(new Point(aChannelSelection.getIntensityPoints().get(i)));
        }
        this.intensityUsed = aChannelSelection.intensityUsed;
    }

    public void copy(AChannelSelection aChannelSelection) {
        if (aChannelSelection == this) {
            return;
        }
        this.offset = aChannelSelection.offset;
        this.length = aChannelSelection.length;
        this.intensityPoints.clear();
        for (int i = 0; i < aChannelSelection.getIntensityPoints().size(); ++i) {
            this.intensityPoints.add(new Point(aChannelSelection.getIntensityPoints().get(i)));
        }
        this.intensityUsed = aChannelSelection.intensityUsed;
    }

    public AChannel getChannel() {
        return (AChannel)this.model;
    }

    public void setChannel(AChannel aChannel) {
        this.model = aChannel;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("channelSelection", nameCounter++);
    }

    public ASelectionPlotter getPlotter() {
        return this.plotter;
    }

    public void setOffset(int n) {
        this.offset = n < 0 ? 0 : n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int n) {
        this.length = n < 0 ? 0 : n;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSelected(int n) {
        return n >= this.offset && n < this.offset + this.length;
    }

    @Override
    public boolean isSelected() {
        return this.length > 0;
    }

    public ArrayList<Point> getIntensityPoints() {
        this.intensityChanged = true;
        return this.intensityPoints;
    }

    public int searchLeftIntensityPointIndex(double d) {
        for (int i = 0; i < this.intensityPoints.size(); ++i) {
            if (!(d < this.intensityPoints.get((int)i).x)) continue;
            return i;
        }
        return 0;
    }

    public int searchNearestIntensityPointIndex(double d) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.intensityPoints.size(); ++i) {
            double d3 = Math.abs(d - this.intensityPoints.get((int)i).x);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = i;
        }
        return n;
    }

    public void addIntensityPoint(double d, float f) {
        int n;
        for (n = 0; n < this.intensityPoints.size(); ++n) {
            if (d != this.intensityPoints.get((int)n).x) continue;
            this.modifyIntensityPoint(n, d, f);
            return;
        }
        if (d > 0.0 && d < 1.0 && (n = this.searchLeftIntensityPointIndex(d)) > 0 && n < this.intensityPoints.size()) {
            this.intensityPoints.add(n, new Point(d, f));
            this.intensityChanged = true;
            this.intensityUsed = true;
        }
    }

    public void modifyIntensityPoint(int n, double d, float f) {
        Point point = this.intensityPoints.get(n);
        point.y = f;
        if (n > 0 && n < this.intensityPoints.size() - 1) {
            double d2 = this.intensityPoints.get((int)(n - 1)).x;
            double d3 = this.intensityPoints.get((int)(n + 1)).x;
            point.x = d < d2 ? d2 + (double)0.001f : (d > d3 ? d3 - (double)0.001f : d);
        }
        this.intensityChanged = true;
        this.intensityUsed = true;
    }

    public void removeIntensityPoint(double d) {
        int n = this.searchNearestIntensityPointIndex(d);
        if (n > 0 && n < this.intensityPoints.size() - 1) {
            this.intensityPoints.remove(n);
            this.intensityChanged = true;
            this.intensityUsed = true;
        }
    }

    public void clearIntensity() {
        this.intensityPoints.clear();
        this.intensityPoints.add(new Point(0.0, 1.0));
        this.intensityPoints.add(new Point(1.0, 1.0));
        this.intensityChanged = true;
        this.intensityUsed = false;
    }

    public void setActiveIntensityPoint(double d) {
        this.activeIntensityPointIndex = d > 0.0 && d < 1.0 ? this.searchNearestIntensityPointIndex(d) : -1;
    }

    public int getActiveIntensityPointIndex() {
        return this.activeIntensityPointIndex;
    }

    public static void setIntensityScale(int n) {
        intensityScale = n;
    }

    public float getIntensity(int n) {
        float f;
        if (!this.intensityUsed) {
            return 1.0f;
        }
        if (this.intensityChanged) {
            if (this.px == null) {
                this.px = new MMArray(this.intensityPoints.size(), 0.0f);
            }
            this.px.setLength(this.intensityPoints.size());
            if (this.py == null) {
                this.py = new MMArray(this.intensityPoints.size(), 0.0f);
            }
            this.py.setLength(this.intensityPoints.size());
            for (int i = 0; i < this.intensityPoints.size(); ++i) {
                this.px.set(i, (float)this.intensityPoints.get((int)i).x);
                this.py.set(i, (float)this.intensityPoints.get((int)i).y);
            }
            this.intensityChanged = false;
        }
        switch (intensityScale) {
            case 1: {
                f = AOToolkit.interpolate1(this.px, this.py, ((float)n - (float)this.getOffset()) / (float)this.getLength());
                break;
            }
            case 2: {
                f = AOToolkit.interpolate2(this.px, this.py, ((float)n - (float)this.getOffset()) / (float)this.getLength());
                break;
            }
            case 3: {
                f = AOToolkit.interpolate3(this.px, this.py, ((float)n - (float)this.getOffset()) / (float)this.getLength());
                break;
            }
            case -1: {
                f = AOToolkit.interpolate1(this.px, this.py, ((float)n - (float)this.getOffset()) / (float)this.getLength());
                f = (float)Math.sqrt(f);
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        return f;
    }

    public float mixIntensity(int n, float f, float f2) {
        float f3 = this.getIntensity(n);
        return f2 * f3 + f * (1.0f - f3);
    }

    private void initIntensityPoints() {
        if (this.intensityPoints == null) {
            this.intensityPoints = new ArrayList();
            this.clearIntensity();
        }
    }

    public void operateChannel(AOperation aOperation) {
        aOperation.startOperation();
        if (this.isSelected()) {
            aOperation.operate(this);
        }
        aOperation.endOperation();
        System.gc();
    }

    static {
        intensityScale = 1;
    }

    public static class Point {
        public double x;
        public double y;

        public Point(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public Point(double d, double d2) {
            this.setPoint(d, d2);
        }

        public void setPoint(double d, double d2) {
            this.x = d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : d);
            this.y = d2 > 1.0 ? 1.0 : (d2 < 0.0 ? 0.0 : d2);
        }
    }
}

