/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipStorage;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.LProgressViewer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ImageIcon;

public class AClipHistory {
    private static final boolean historyEnable = GPersistence.createPersistance().getBoolean("history.enable");
    private static String historyPath = GToolkit.getLaoeUserHomePath() + "history/";
    private static String historyExtension = ".laoe.tmp";
    private AClip clip;
    private ArrayList<HistoryElement> history;
    private int lastSaveIndex;
    private int actualIndex;

    public AClipHistory(AClip aClip) {
        this.clip = aClip;
        this.history = new ArrayList();
        this.lastSaveIndex = 0;
    }

    public AClipHistory(AClipHistory aClipHistory, AClip aClip) {
        this(aClip);
        for (int i = 0; i < aClipHistory.history.size(); ++i) {
            this.history.add(aClipHistory.history.get(i));
        }
    }

    public static boolean isEnabled() {
        return historyEnable;
    }

    public static long getMemorySize() {
        long l = 0L;
        File[] fileArray = new File(historyPath).listFiles(new HistoryFileFilter());
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                l += fileArray[i].length();
            }
        }
        return l;
    }

    public boolean hasUnsavedModifications() {
        return this.lastSaveIndex != this.actualIndex;
    }

    public void onSave() {
        this.lastSaveIndex = this.actualIndex;
    }

    public void store(String string) {
        this.history.add(new HistoryElement(string));
        this.actualIndex = this.history.size() - 1;
    }

    public void store(ImageIcon imageIcon, String string) {
        this.history.add(new HistoryElement(imageIcon, string));
        this.actualIndex = this.history.size() - 1;
    }

    private int limitIndex(int n) {
        if (n >= this.history.size()) {
            return this.history.size() - 1;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public AClip reloadClip(int n, AClip aClip) {
        int n2;
        this.actualIndex = n2 = this.limitIndex(n);
        return this.history.get(n2).reloadClip(aClip);
    }

    public AClip undo(AClip aClip) {
        return this.reloadClip(--this.actualIndex, aClip);
    }

    public AClip redo(AClip aClip) {
        return this.reloadClip(++this.actualIndex, aClip);
    }

    public AClip reloadClip(int n) {
        int n2;
        this.actualIndex = n2 = this.limitIndex(n);
        return this.history.get(n2).reloadClip();
    }

    public String getDescription(int n) {
        if (n < this.history.size()) {
            return this.history.get(n).getDescription();
        }
        return null;
    }

    public String getTime(int n) {
        if (n < this.history.size()) {
            return this.history.get(n).getTime();
        }
        return null;
    }

    public ImageIcon getIcon(int n) {
        if (n < this.history.size()) {
            return this.history.get(n).getIcon();
        }
        return null;
    }

    public int getStackSize() {
        return this.history.size();
    }

    static {
        File[] fileArray = new File(historyPath).listFiles(new HistoryFileFilter());
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    private class HistoryElement {
        private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN);
        private File file;
        private String time;
        private String description;
        private ImageIcon icon;

        public HistoryElement(String string) {
            this(null, string);
        }

        public HistoryElement(ImageIcon imageIcon, String string) {
            this.icon = imageIcon;
            this.time = this.dateFormat.format(new Date());
            this.description = string;
            if (historyEnable) {
                AClipHistory.this.clip.markChange();
                this.file = new File(historyPath + AClipHistory.this.clip.getChangeId() + historyExtension);
                this.file.deleteOnExit();
                try {
                    LProgressViewer.getInstance().entrySubProgress(0.5, "storeToHistory", false);
                    Debug.println(3, "history save clip " + AClipHistory.this.clip.getName() + " to file " + this.file.getName());
                    AClipStorage.saveWithoutSamples(AClipHistory.this.clip, this.file);
                    for (int i = 0; i < AClipHistory.this.clip.getNumberOfLayers(); ++i) {
                        if (LProgressViewer.getInstance().setProgress((i + 1) * 100 / AClipHistory.this.clip.getNumberOfLayers())) {
                            return;
                        }
                        ALayer aLayer = AClipHistory.this.clip.getLayer(i);
                        LProgressViewer.getInstance().entrySubProgress(0.3, "", false);
                        for (int j = 0; j < aLayer.getNumberOfChannels(); ++j) {
                            if (LProgressViewer.getInstance().setProgress((j + 1) * 100 / aLayer.getNumberOfChannels())) {
                                return;
                            }
                            AChannel aChannel = aLayer.getChannel(j);
                            File file = new File(historyPath + aChannel.getChangeId() + historyExtension);
                            if (file.exists()) continue;
                            Debug.println(3, "history save channel " + aChannel.getName() + " to file " + file.getName());
                            file.deleteOnExit();
                            AClipStorage.saveSamples(aChannel, file);
                        }
                        LProgressViewer.getInstance().exitSubProgress();
                    }
                    LProgressViewer.getInstance().exitSubProgress();
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(5, iOException);
                }
            }
        }

        public AClip reloadClip(AClip aClip) {
            if (historyEnable && aClip != null) {
                try {
                    int n;
                    LProgressViewer.getInstance().entrySubProgress(0.5, "reloadFromHistory");
                    HashMap<String, AChannel> hashMap = new HashMap<String, AChannel>();
                    for (n = 0; n < aClip.getNumberOfLayers(); ++n) {
                        for (int i = 0; i < aClip.getLayer(n).getNumberOfChannels(); ++i) {
                            hashMap.put(aClip.getLayer(n).getChannel(i).getChangeId(), aClip.getLayer(n).getChannel(i));
                        }
                    }
                    aClip.removeAll();
                    AClipStorage.load(aClip, this.file);
                    Debug.println(3, "history load clip" + AClipHistory.this.clip.getName() + " from file " + this.file.getName());
                    for (n = 0; n < aClip.getNumberOfLayers(); ++n) {
                        if (LProgressViewer.getInstance().setProgress((n + 1) * 100 / aClip.getNumberOfLayers())) {
                            return aClip;
                        }
                        ALayer aLayer = aClip.getLayer(n);
                        LProgressViewer.getInstance().entrySubProgress(0.3);
                        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                            if (LProgressViewer.getInstance().setProgress((i + 1) * 100 / aLayer.getNumberOfChannels())) {
                                return aClip;
                            }
                            AChannel aChannel = aLayer.getChannel(i);
                            if (hashMap.containsKey(aChannel.getChangeId())) {
                                Debug.println(13, "history reuse channel, id=" + aChannel.getChangeId());
                                aChannel.setSamples(((AChannel)hashMap.get(aChannel.getChangeId())).getSamples());
                                continue;
                            }
                            Debug.println(13, "history reload channel, id=" + aChannel.getChangeId());
                            File file = new File(historyPath + aChannel.getChangeId() + historyExtension);
                            if (!file.exists()) continue;
                            aChannel.setSamples(AClipStorage.loadSamples(file));
                        }
                        LProgressViewer.getInstance().exitSubProgress();
                    }
                    hashMap.clear();
                    LProgressViewer.getInstance().exitSubProgress();
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(5, iOException);
                }
            }
            return aClip;
        }

        public AClip reloadClip() {
            return this.reloadClip(new AClip(0, 0));
        }

        public String getTime() {
            return this.time;
        }

        public String getDescription() {
            return this.description;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }
    }

    private static class HistoryFileFilter
    implements FileFilter {
        private HistoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(historyExtension);
        }
    }
}

