/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.ASelection;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;
import java.util.ArrayList;

public class AClipSelection
extends ASelection {
    private static int nameCounter;
    private ArrayList<ALayerSelection> layerSelection = new ArrayList();

    public AClipSelection(AClip aClip) {
        super(aClip);
    }

    public AClipSelection(AClipSelection aClipSelection) {
        this((AClip)aClipSelection.model);
        this.name = aClipSelection.name;
    }

    public AClip getClip() {
        return (AClip)this.model;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("clipSelection", nameCounter++);
    }

    public void addLayerSelection(ALayerSelection aLayerSelection) {
        this.layerSelection.add(aLayerSelection);
    }

    public ALayerSelection getLayerSelection(int n) {
        return this.layerSelection.get(n);
    }

    public int getNumberOfLayerSelections() {
        return this.layerSelection.size();
    }

    @Override
    public boolean isSelected() {
        for (int i = 0; i < this.getNumberOfLayerSelections(); ++i) {
            if (!this.getLayerSelection(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void operateEachChannel(AOperation aOperation) {
        LProgressViewer.getInstance().entrySubProgress(0.7, "clip");
        aOperation.startOperation();
        for (int i = 0; i < this.getNumberOfLayerSelections(); ++i) {
            LProgressViewer.getInstance().entrySubProgress(1.0 / (double)this.getNumberOfLayerSelections(), "layer " + i);
            for (int j = 0; j < this.getLayerSelection(i).getNumberOfChannelSelections(); ++j) {
                LProgressViewer.getInstance().entrySubProgress(1.0 / (double)this.getLayerSelection(i).getNumberOfChannelSelections(), "channel " + j);
                if (this.getLayerSelection(i).getChannelSelection(j).isSelected()) {
                    aOperation.operate(this.getLayerSelection(i).getChannelSelection(j));
                }
                LProgressViewer.getInstance().exitSubProgress();
            }
            LProgressViewer.getInstance().exitSubProgress();
        }
        aOperation.endOperation();
        System.gc();
        LProgressViewer.getInstance().exitSubProgress();
    }

    public void operateLayer0WithLayer1(AOperation aOperation) {
        int n = this.getLayerSelection(0).getNumberOfChannelSelections();
        int n2 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n3 = Math.min(n, n2);
        LProgressViewer.getInstance().entrySubProgress(0.7, "clip");
        aOperation.startOperation();
        for (int i = 0; i < n3; ++i) {
            if (LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)n3)) {
                return;
            }
            if (!this.getLayerSelection(0).getChannelSelection(i).isSelected()) continue;
            aOperation.operate(this.getLayerSelection(0).getChannelSelection(i), this.getLayerSelection(1).getChannelSelection(i));
        }
        aOperation.endOperation();
        System.gc();
        LProgressViewer.getInstance().exitSubProgress();
    }

    public void operateLayer0WithLayer1And2(AOperation aOperation) {
        int n = this.getLayerSelection(0).getNumberOfChannelSelections();
        int n2 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n3 = this.getLayerSelection(1).getNumberOfChannelSelections();
        int n4 = Math.min(Math.min(n, n2), n3);
        LProgressViewer.getInstance().entrySubProgress(0.7, "clip");
        aOperation.startOperation();
        for (int i = 0; i < n4; ++i) {
            if (LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)n4)) {
                return;
            }
            if (!this.getLayerSelection(0).getChannelSelection(i).isSelected()) continue;
            aOperation.operate(this.getLayerSelection(0).getChannelSelection(i), this.getLayerSelection(1).getChannelSelection(i), this.getLayerSelection(2).getChannelSelection(i));
        }
        aOperation.endOperation();
        System.gc();
        LProgressViewer.getInstance().exitSubProgress();
    }
}

