/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.AModel;
import ch.laoe.clip.APlotter;
import ch.laoe.ui.GPersistence;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class ALayerPlotter
extends APlotter {
    private boolean isVisible;
    private Color color = new Color(GPersistence.createPersistance().getInt("clip.defaultSampleColor"));
    private float colorGamma = 0.18f;

    public ALayerPlotter(AModel aModel) {
        super(aModel);
        this.setVisible(true);
    }

    @Override
    public void setDefaultName() {
        this.name = "";
    }

    public ALayer getLayerModel() {
        return (ALayer)this.model;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColorGamma(float f) {
        this.colorGamma = f;
    }

    public float getColorGamma() {
        return this.colorGamma;
    }

    public void setXRange(double d, double d2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().setXRange(d, d2);
        }
    }

    public void setYRange(float f, float f2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().setYRange(f, f2);
        }
    }

    public void translateXOffset(double d) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().translateXOffset(d);
        }
    }

    public void translateYOffset(float f) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().translateYOffset(f);
        }
    }

    public void zoomX(double d) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().zoomX(d);
        }
    }

    public void zoomX(double d, double d2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().zoomX(d, d2);
        }
    }

    public void zoomY(double d) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().zoomY(d);
        }
    }

    public void zoomY(double d, double d2) {
        for (int i = 0; i < this.getLayerModel().getNumberOfElements(); ++i) {
            this.getLayerModel().getChannel(i).getPlotter().zoomY(d, d2);
        }
    }

    public void autoScaleX() {
        double d = this.getAutoscaleXOffset();
        double d2 = this.getAutoscaleXLength();
        this.setXRange(d - d2 * (double)0.01f, d2 * (double)1.02f);
    }

    public void autoScaleY() {
        this.autoScaleY(0, this.getLayerModel().getMaxSampleLength());
    }

    public void autoScaleY(int n, int n2) {
        float f = this.getAutoscaleYOffset(n, n2);
        float f2 = this.getAutoscaleYLength(n, n2);
        this.setYRange(f - f2 * 0.03f, f2 * 1.06f);
    }

    public double getAutoscaleXOffset() {
        double d = Double.MAX_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            double d2 = aLayer.getChannel(i).getPlotter().getAutoscaleXOffset();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getAutoscaleXLength() {
        double d = Double.MIN_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            double d2 = aLayer.getChannel(i).getPlotter().getAutoscaleXLength();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public float getAutoscaleYOffset(int n, int n2) {
        float f = Float.MAX_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getPlotter().getAutoscaleYOffset(n, n2);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getAutoscaleYLength(int n, int n2) {
        float f = Float.MIN_VALUE;
        ALayer aLayer = this.getLayerModel();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            float f2 = aLayer.getChannel(i).getPlotter().getAutoscaleYLength(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    private int getSkalaSize(Rectangle rectangle, int n) {
        int n2 = 1;
        int n3 = 8;
        int n4 = Math.min(rectangle.width, rectangle.height) / 20;
        return Math.max(Math.min(n4, n3), n2);
    }

    private Rectangle createChannelRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getSkalaSize(rectangle, n2);
        int n6 = n4 / n2 - n5;
        int n7 = n3 - n5;
        return new Rectangle(n5, n * (n6 + n5), n7, n6);
    }

    private Rectangle createYSkalaRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.height;
        int n4 = this.getSkalaSize(rectangle, n2);
        int n5 = n3 / n2 - n4;
        return new Rectangle(0, n * (n5 + n4), n4, n5);
    }

    private Rectangle createXSkalaRect(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getSkalaSize(rectangle, n2);
        int n6 = n4 / n2 - n5;
        int n7 = n3 - n5;
        return new Rectangle(n5, n * (n6 + n5) + n6, n7 - n5, n5);
    }

    public void paintLayer(Graphics2D graphics2D, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2, Color color, float f, boolean bl3, Color color2) {
        if (this.isVisible || !bl2) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                aLayer.getChannel(i).getPlotter().setRectangle(rectangle2);
                if (i < aLayer.getNumberOfChannels()) {
                    if (bl3) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                        aLayer.getChannel(i).getPlotter().paintBackground(graphics2D, color);
                    }
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    aLayer.getChannel(i).getPlotter().paintSamples(graphics2D, this.color, this.colorGamma);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    aLayer.getChannel(i).getPlotter().paintFrame(graphics2D);
                }
                if (!bl || i >= aLayer.getNumberOfChannels()) continue;
                Rectangle rectangle3 = this.createXSkalaRect(rectangle, i, n2);
                Rectangle rectangle4 = this.createYSkalaRect(rectangle, i, n2);
                aLayer.getChannel(i).getPlotter().paintXSkala(graphics2D, rectangle3, color2);
                aLayer.getChannel(i).getPlotter().paintYSkala(graphics2D, rectangle4, color2);
                if (!AClipPlotter.isGridVisible()) continue;
                aLayer.getChannel(i).getPlotter().paintGrid(graphics2D, rectangle2, color2);
            }
        }
    }

    public void paintAllSelections(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                aLayer.getChannel(i).getPlotter().setRectangle(rectangle2);
                aLayer.getChannel(i).getPlotter().paintSelection(graphics2D, color, color2);
            }
        }
    }

    public void paintMasks(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = this.createChannelRect(rectangle, i, n2);
                if (i >= aLayer.getNumberOfChannels()) continue;
                aLayer.getChannel(i).getPlotter().setRectangle(rectangle2);
                aLayer.getChannel(i).getPlotter().paintMask(graphics2D);
            }
        }
    }

    public void paintMarkers(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        if (this.isVisible) {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < n2; ++i) {
                if (i >= aLayer.getNumberOfChannels()) continue;
                Rectangle rectangle2 = this.createXSkalaRect(rectangle, i, n2);
                aLayer.getChannel(i).getPlotter().paintMarker(graphics2D, rectangle2);
            }
        }
    }

    public int getInsideChannelIndex(Point point) {
        try {
            ALayer aLayer = this.getLayerModel();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                if (!aLayer.getChannel(i).getPlotter().isInsideChannel(point)) continue;
                return i;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }
}

