/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFftBlockProcessing;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AODisharmony
extends AOperation
implements AOFftBlockProcessing.Processor {
    private AOFftBlockProcessing blockProcessing = new AOFftBlockProcessing(this);
    private MMArray shRe;
    private MMArray shIm;
    private int type;
    public static final int SHIFT = 0;
    public static final int BLUR = 1;
    public static final int UNPITCH = 2;
    public static final int BASS_DEPHASE = 3;
    public static final int TREBLE_DEPHASE = 4;
    private float disharmony;

    public AODisharmony(int n, float f, float f2, float f3, int n2, int n3, float f4) {
        this.blockProcessing.setFftBlockLength(n2);
        this.blockProcessing.setFftWindowType(n3);
        this.blockProcessing.setOverlapFactor(f4);
        this.blockProcessing.setRmsAdaptionEnabled(true);
        this.blockProcessing.setZeroCrossEnabled(true);
        this.type = n;
        this.disharmony = f3;
        this.shRe = new MMArray(n2 / 2, 0.0f);
        this.shIm = new MMArray(n2 / 2, 0.0f);
    }

    @Override
    public void process(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        switch (this.type) {
            case 0: {
                int n3 = (int)(this.disharmony * (float)n2 / 10.0f);
                for (int i = 0; i < this.shRe.getLength(); ++i) {
                    if (i - n3 < mMArray.getLength() / 2 && i - n3 > 0) {
                        this.shRe.set(i, mMArray.get(i - n3));
                        this.shIm.set(i, mMArray2.get(i - n3));
                        continue;
                    }
                    this.shRe.set(i, 0.0f);
                    this.shIm.set(i, 0.0f);
                }
                break;
            }
            case 1: {
                int n4 = (int)(this.disharmony * (float)n2 / 5.0f);
                for (int i = 0; i < this.shRe.getLength(); ++i) {
                    if (i - n4 < mMArray.getLength() / 2 && i - n4 > 0) {
                        this.shRe.set(i, mMArray.get(i - n4));
                        this.shIm.set(i, mMArray2.get(i));
                        continue;
                    }
                    this.shRe.set(i, 0.0f);
                    this.shIm.set(i, 0.0f);
                }
                break;
            }
            case 2: {
                int n5 = (int)(this.disharmony * (float)n2 / 5.0f);
                for (int i = 0; i < this.shRe.getLength(); ++i) {
                    float f = (int)((double)i + Math.random() * (double)n5);
                    if (f >= 0.0f && f < (float)this.shRe.getLength()) {
                        this.shRe.set(i, AOToolkit.interpolate3(mMArray, f));
                        this.shIm.set(i, AOToolkit.interpolate3(mMArray2, f));
                        continue;
                    }
                    this.shRe.set(i, 0.0f);
                    this.shIm.set(i, 0.0f);
                }
                break;
            }
            case 3: {
                float f;
                int n6;
                int n7 = (int)(this.disharmony * (float)n2 * 10.0f);
                for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                    f = AOToolkit.cartesianToMagnitude(mMArray.get(n6), mMArray2.get(n6));
                    float f2 = AOToolkit.cartesianToPhase(mMArray.get(n6), mMArray2.get(n6));
                    mMArray.set(n6, f);
                    mMArray2.set(n6, f2);
                }
                for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                    f = (int)((double)n6 + Math.random() * (double)(n7 / (n6 + 1)));
                    if (!(f >= 0.0f) || !(f < (float)this.shRe.getLength())) continue;
                    mMArray2.set(n6, AOToolkit.interpolate3(mMArray2, f));
                }
                for (n6 = 0; n6 < this.shRe.getLength(); ++n6) {
                    this.shRe.set(n6, AOToolkit.polarToX(mMArray.get(n6), mMArray2.get(n6)));
                    this.shIm.set(n6, AOToolkit.polarToY(mMArray.get(n6), mMArray2.get(n6)));
                }
                break;
            }
            case 4: {
                float f;
                int n8;
                int n9 = (int)(this.disharmony * (float)n2 * 10.0f);
                for (n8 = 0; n8 < this.shRe.getLength(); ++n8) {
                    f = AOToolkit.cartesianToMagnitude(mMArray.get(n8), mMArray2.get(n8));
                    float f3 = AOToolkit.cartesianToPhase(mMArray.get(n8), mMArray2.get(n8));
                    mMArray.set(n8, f);
                    mMArray2.set(n8, f3);
                }
                for (n8 = 0; n8 < this.shRe.getLength(); ++n8) {
                    f = (int)((double)n8 + Math.random() * (double)(n9 / (this.shRe.getLength() - n8)));
                    if (!(f >= 0.0f) || !(f < (float)this.shRe.getLength())) continue;
                    mMArray2.set(n8, AOToolkit.interpolate3(mMArray2, f));
                }
                for (n8 = 0; n8 < this.shRe.getLength(); ++n8) {
                    this.shRe.set(n8, AOToolkit.polarToX(mMArray.get(n8), mMArray2.get(n8)));
                    this.shIm.set(n8, AOToolkit.polarToY(mMArray.get(n8), mMArray2.get(n8)));
                }
                break;
            }
        }
        mMArray.copy(this.shRe, 0, 0, n2);
        mMArray2.copy(this.shIm, 0, 0, n2);
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        this.blockProcessing.operate(aChannelSelection);
    }
}

