/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;

public class AOMeasure
extends AOperation {
    private float min;
    private float max;
    private float mean;
    private float rms;
    private float stdDev;
    private float sum;
    private float sumOfSquares;
    private int samples;
    private int clippedSamples;
    private int clippedThreshold;

    public AOMeasure(int n) {
        this.clippedThreshold = 1 << n - 1;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getAbsoluteMax() {
        if (Math.abs(this.max) > Math.abs(this.min)) {
            return Math.abs(this.max);
        }
        return Math.abs(this.min);
    }

    public float getMean() {
        return this.mean;
    }

    public float getRms() {
        return this.rms;
    }

    public float getStandardDeviation() {
        return this.stdDev;
    }

    public int getNumberOfClippedSamples() {
        return this.clippedSamples;
    }

    @Override
    public void startOperation() {
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        this.sum = 0.0f;
        this.sumOfSquares = 0.0f;
        this.samples = 0;
        this.clippedSamples = 0;
    }

    @Override
    public void endOperation() {
        this.mean = this.sum / (float)this.samples;
        this.rms = (float)Math.sqrt(this.sumOfSquares / (float)this.samples);
        this.stdDev = (float)Math.sqrt((this.sumOfSquares - this.sum * this.sum / (float)this.samples) / (float)(this.samples - 1));
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        try {
            for (int i = n; i < n + n2; ++i) {
                ++this.samples;
                this.sum += mMArray.get(i);
                this.sumOfSquares += mMArray.get(i) * mMArray.get(i);
                if (mMArray.get(i) > this.max) {
                    this.max = mMArray.get(i);
                }
                if (mMArray.get(i) < this.min) {
                    this.min = mMArray.get(i);
                }
                if (!(mMArray.get(i) > (float)this.clippedThreshold)) continue;
                ++this.clippedSamples;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

