/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOPitchGenerator
extends AOperation {
    private MMArray baseSignal;
    private float constPitch;

    public AOPitchGenerator(MMArray mMArray) {
        this.baseSignal = mMArray;
        this.smoothBaseSignal();
    }

    public AOPitchGenerator(MMArray mMArray, float f) {
        this(mMArray);
        this.constPitch = f;
    }

    private void smoothBaseSignal() {
        if (this.baseSignal.getLength() > 50) {
            AOToolkit.applyZeroCross(this.baseSignal, 0);
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = 0.0f;
        aChannelSelection.getChannel().markChange();
        try {
            for (int i = 0; i < n2; ++i) {
                float f2 = AOToolkit.interpolate3(this.baseSignal, f);
                mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), f2));
                f += this.constPitch;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        MMArray mMArray2 = aChannelSelection2.getChannel().getSamples();
        float f = 0.0f;
        aChannelSelection.getChannel().markChange();
        try {
            for (int i = 0; i < n2; ++i) {
                float f2 = AOToolkit.interpolate3(this.baseSignal, f);
                mMArray.set(i + n, aChannelSelection.mixIntensity(i + n, mMArray.get(i + n), f2));
                f += mMArray2.get(i + n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

