/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;

public class AOVibrato
extends AOperation {
    private float modulationDelay;
    private float modulationPeriod;
    private int modulationShape;
    public static final int SINUS = 1;
    public static final int TRIANGLE = 2;
    public static final int SAW = 3;

    public AOVibrato(int n, int n2, int n3) {
        this.modulationDelay = n;
        this.modulationPeriod = n2;
        this.modulationShape = n3;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        int n;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n2 = aChannelSelection.getOffset();
        int n3 = aChannelSelection.getLength();
        MMArray mMArray2 = new MMArray(n3, 0.0f);
        aChannelSelection.getChannel().markChange();
        LProgressViewer.getInstance().entrySubProgress(0.7);
        for (n = 0; n < n3; ++n) {
            if (LProgressViewer.getInstance().setProgress((double)(n + 1) * 1.0 / (double)n3)) {
                return;
            }
            float f = 0.0f;
            switch (this.modulationShape) {
                case 1: {
                    f += (float)Math.sin((double)((float)(n % (int)this.modulationPeriod) / this.modulationPeriod * 2.0f) * Math.PI) * this.modulationDelay;
                    break;
                }
                case 2: {
                    f += (Math.abs((float)(n % (int)this.modulationPeriod) / this.modulationPeriod * 4.0f - 2.0f) - 1.0f) * this.modulationDelay;
                    break;
                }
                case 3: {
                    f += ((float)(n % (int)this.modulationPeriod) / this.modulationPeriod * 2.0f - 1.0f) * this.modulationDelay;
                }
            }
            double d = (float)(n2 + n) + f;
            if (d < 0.0) {
                d = 0.0;
            } else if (d >= (double)mMArray.getLength()) {
                d = mMArray.getLength() - 1;
            }
            mMArray2.set(n, AOToolkit.interpolate0(mMArray, (float)d));
        }
        LProgressViewer.getInstance().exitSubProgress();
        for (n = 0; n < mMArray2.getLength(); ++n) {
            mMArray.set(n + n2, aChannelSelection.mixIntensity(n + n2, mMArray.get(n + n2), mMArray2.get(n)));
        }
    }
}

