/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOAmplify;
import ch.laoe.operation.AOHighPass;
import ch.laoe.operation.AOMeasure;
import ch.laoe.operation.AONormalize;
import ch.laoe.operation.AOSaturate;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPAmplify
extends GPluginFrame {
    private JCheckBox invert;
    private JCheckBox normalize;
    private JCheckBox saturate;
    private JCheckBox removeDc;
    private JCheckBox coupled;
    private UiControlText amplification;
    private UiControlText bitWidth;
    private JComboBox normalizeMode;
    private JButton applyConst;
    private JButton applyVar;
    private GClipLayerChooser layerChooser;
    private EventDispatcher eventDispatcher;

    public GPAmplify(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "amplify";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("amplification")), 0, 0, 5, 1);
        this.amplification = new GControlTextA(10, true, true);
        this.amplification.setDataRange(-10000.0, 10000.0);
        this.amplification.setData(1.0);
        uiCartesianLayout.add(this.amplification, 5, 0, 5, 1);
        this.invert = new JCheckBox(GLanguage.translate("invert"));
        uiCartesianLayout.add(this.invert, 0, 1, 5, 1);
        this.removeDc = new JCheckBox(GLanguage.translate("removeDc"));
        uiCartesianLayout.add(this.removeDc, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("bitWidth")), 0, 2, 5, 1);
        this.bitWidth = new UiControlText(4, true, false);
        this.bitWidth.setDataRange(1.0, 32.0);
        this.bitWidth.setData(16.0);
        uiCartesianLayout.add(this.bitWidth, 5, 2, 3, 1);
        this.normalize = new JCheckBox(GLanguage.translate("normalize"));
        uiCartesianLayout.add(this.normalize, 0, 3, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("peak"), GLanguage.translate("RMS")};
        this.normalizeMode = new JComboBox<String>(stringArray);
        this.normalizeMode.setSelectedIndex(0);
        uiCartesianLayout.add(this.normalizeMode, 5, 3, 3, 1);
        this.saturate = new JCheckBox(GLanguage.translate("saturate"));
        uiCartesianLayout.add(this.saturate, 0, 4, 5, 1);
        this.coupled = new JCheckBox(GLanguage.translate("coupled"));
        uiCartesianLayout.add(this.coupled, 5, 4, 5, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 6);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(Laoe.getInstance(), "envelopeCurve");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyVar, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("envelope"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.updateConstantComponents();
        this.eventDispatcher = new EventDispatcher();
        this.normalize.addActionListener(this.eventDispatcher);
        this.saturate.addActionListener(this.eventDispatcher);
        this.applyConst.addActionListener(new LWorker(this.eventDispatcher));
        this.applyVar.addActionListener(new LWorker(this.eventDispatcher));
    }

    private void updateConstantComponents() {
        if (this.normalize.isSelected() || this.saturate.isSelected()) {
            this.bitWidth.setEnabled(true);
        } else {
            this.bitWidth.setEnabled(false);
        }
        if (this.normalize.isSelected()) {
            this.normalizeMode.setEnabled(true);
            this.coupled.setEnabled(true);
        } else {
            this.normalizeMode.setEnabled(false);
            this.coupled.setEnabled(false);
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.bitWidth.setData(this.getFocussedClip().getSampleWidth());
        this.amplification.refresh();
    }

    private void onApplyConst() {
        float f = (1 << (int)this.bitWidth.getData() - 1) - 1;
        float f2 = (float)this.amplification.getData();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        if (this.removeDc.isSelected()) {
            aLayerSelection.operateEachChannel(new AOHighPass(0.0f, 1.0f, 5.0f / this.getFocussedClip().getSampleRate()));
        }
        if (this.invert.isSelected()) {
            f2 = -f2;
        }
        if (this.normalize.isSelected()) {
            if (this.coupled.isSelected()) {
                switch (this.normalizeMode.getSelectedIndex()) {
                    case 0: {
                        AOMeasure aOMeasure = new AOMeasure((int)this.bitWidth.getData());
                        aLayerSelection.operateEachChannel(aOMeasure);
                        float f3 = aOMeasure.getAbsoluteMax();
                        aLayerSelection.operateEachChannel(new AOAmplify(f / f3 * f2));
                        break;
                    }
                    case 1: {
                        AOMeasure aOMeasure = new AOMeasure((int)this.bitWidth.getData());
                        aLayerSelection.operateEachChannel(aOMeasure);
                        float f4 = aOMeasure.getRms();
                        aLayerSelection.operateEachChannel(new AOAmplify(f / f4 * f2));
                    }
                }
            } else {
                switch (this.normalizeMode.getSelectedIndex()) {
                    case 0: {
                        aLayerSelection.operateEachChannel(new AONormalize(1, f * f2));
                        break;
                    }
                    case 1: {
                        aLayerSelection.operateEachChannel(new AONormalize(2, f * f2));
                    }
                }
            }
        } else {
            aLayerSelection.operateEachChannel(new AOAmplify(f2));
        }
        if (this.saturate.isSelected()) {
            aLayerSelection.operateEachChannel(new AOSaturate(f));
        }
        this.autoCloseNow();
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOAmplify());
        this.autoCloseNow();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == GPAmplify.this.normalize) {
                    Debug.println(1, "plugin " + GPAmplify.this.getName() + " [normalize] clicked");
                    GPAmplify.this.updateConstantComponents();
                    return;
                }
                if (actionEvent.getSource() == GPAmplify.this.saturate) {
                    Debug.println(1, "plugin " + GPAmplify.this.getName() + " [saturate] clicked");
                    GPAmplify.this.updateConstantComponents();
                    return;
                }
                LProgressViewer.getInstance().entrySubProgress(GPAmplify.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                if (actionEvent.getSource() == GPAmplify.this.applyConst) {
                    Debug.println(1, "plugin " + GPAmplify.this.getName() + " [apply const] clicked");
                    GPAmplify.this.onApplyConst();
                } else if (actionEvent.getSource() == GPAmplify.this.applyVar) {
                    Debug.println(1, "plugin " + GPAmplify.this.getName() + " [apply var] clicked");
                    GPAmplify.this.onApplyVar();
                }
                GPAmplify.this.updateHistory(GLanguage.translate(GPAmplify.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPAmplify.this.reloadFocussedClipEditor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

