/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOCanon;
import ch.laoe.operation.AOLoopable;
import ch.laoe.operation.AOLoopableKeepSize;
import ch.laoe.operation.AOLoopableMultiplicate;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPLoopable
extends GPluginFrame {
    private JComboBox order;
    private UiControlText voices;
    private UiControlText borderWidth;
    private UiControlText numberOfTimes;
    private JButton apply1;
    private JButton apply2;
    private JButton apply3;
    private JButton apply4;
    private EventDispatcher eventDispatcher;

    public GPLoopable(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "loopable";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("order")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("squareRoot"), GLanguage.translate("linear"), GLanguage.translate("square"), GLanguage.translate("cubic")};
        this.order = new JComboBox<String>(stringArray);
        this.order.setSelectedIndex(2);
        uiCartesianLayout.add(this.order, 4, 0, 6, 1);
        this.apply1 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply1, 3, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("crossFade"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("voices")), 0, 0, 5, 1);
        this.voices = new UiControlText(10, true, true);
        this.voices.setDataRange(2.0, 5.0);
        this.voices.setData(2.0);
        uiCartesianLayout2.add(this.voices, 5, 0, 5, 1);
        this.apply2 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.apply2, 3, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("canon"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 3);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("numberOfTimes")), 0, 0, 5, 1);
        this.numberOfTimes = new UiControlText(10, true, true);
        this.numberOfTimes.setDataRange(2.0, 100.0);
        this.numberOfTimes.setData(2.0);
        uiCartesianLayout3.add(this.numberOfTimes, 5, 0, 5, 1);
        this.apply3 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.apply3, 3, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("multiplicate"), jPanel3);
        JPanel jPanel4 = new JPanel();
        UiCartesianLayout uiCartesianLayout4 = new UiCartesianLayout(jPanel4, 10, 3);
        uiCartesianLayout4.setPreferredCellSize(new Dimension(25, 35));
        jPanel4.setLayout(uiCartesianLayout4);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("borderWidth")), 0, 0, 4, 1);
        this.borderWidth = new GControlTextX(Laoe.getInstance(), 10, true, true);
        this.borderWidth.setDataRange(1.0, 100000.0);
        this.borderWidth.setData(1000.0);
        uiCartesianLayout4.add(this.borderWidth, 4, 0, 6, 1);
        this.apply4 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout4.add(this.apply4, 3, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("keepSize"), jPanel4);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply1.addActionListener(new LWorker(this.eventDispatcher));
        this.apply2.addActionListener(new LWorker(this.eventDispatcher));
        this.apply3.addActionListener(new LWorker(this.eventDispatcher));
        this.apply4.addActionListener(new LWorker(this.eventDispatcher));
    }

    @Override
    public void reload() {
        super.reload();
        this.voices.refresh();
        this.borderWidth.refresh();
        this.numberOfTimes.refresh();
    }

    private void onApply1() {
        int n = 2;
        switch (this.order.getSelectedIndex()) {
            case 0: {
                n = -2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
            }
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOLoopable(n));
        this.getFocussedClip().getSelectedLayer().setEmptySelection();
    }

    private void onApply2() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOCanon((int)this.voices.getData()));
        this.getFocussedClip().getSelectedLayer().setEmptySelection();
    }

    private void onApply3() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOLoopableMultiplicate((int)this.numberOfTimes.getData()));
    }

    private void onApply4() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOLoopableKeepSize((int)this.borderWidth.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LProgressViewer.getInstance().entrySubProgress(GPLoopable.this.getName());
            LProgressViewer.getInstance().entrySubProgress(0.7);
            if (actionEvent.getSource() == GPLoopable.this.apply1) {
                Debug.println(1, "plugin " + GPLoopable.this.getName() + " [apply1] clicked");
                GPLoopable.this.onApply1();
                GPLoopable.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPLoopable.this.apply2) {
                Debug.println(1, "plugin " + GPLoopable.this.getName() + " [apply2] clicked");
                GPLoopable.this.onApply2();
                GPLoopable.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPLoopable.this.apply3) {
                Debug.println(1, "plugin " + GPLoopable.this.getName() + " [apply3] clicked");
                GPLoopable.this.onApply3();
                GPLoopable.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPLoopable.this.apply4) {
                Debug.println(1, "plugin " + GPLoopable.this.getName() + " [apply4] clicked");
                GPLoopable.this.onApply4();
                GPLoopable.this.autoCloseNow();
            }
            GPLoopable.this.updateHistory(GLanguage.translate(GPLoopable.this.getName()));
            LProgressViewer.getInstance().exitSubProgress();
            LProgressViewer.getInstance().exitSubProgress();
            GPLoopable.this.reloadFocussedClipEditor();
        }
    }
}

