/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayer2DSelection;
import ch.laoe.operation.AOSpectrogramFilter;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPSpectrogramFilter
extends GPluginFrame {
    private JButton apply;
    private UiControlText amplification;
    private UiControlText threshold;
    private UiControlText overlap;
    private GComboBoxPowerOf2 fftLength;
    private JComboBox filterMode;
    private JComboBox windowType;
    private EventDispatcher eventDispatcher;

    public GPSpectrogramFilter(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "spectrogramFilter";
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void reload() {
        super.reload();
        this.amplification.refresh();
        this.threshold.refresh();
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 7);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("filterMode")), 0, 0, 5, 1);
        this.filterMode = new JComboBox<String>(AOSpectrogramFilter.getFilterModeItems());
        this.filterMode.setSelectedIndex(0);
        uiCartesianLayout.add(this.filterMode, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("amplification")), 0, 1, 5, 1);
        this.amplification = new GControlTextA(9, true, true);
        this.amplification.setDataRange(0.0, 10.0);
        this.amplification.setData(0.0);
        uiCartesianLayout.add(this.amplification, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("threshold")), 0, 2, 5, 1);
        this.threshold = new GControlTextY(Laoe.getInstance(), 9, true, true);
        this.threshold.setDataRange(0.0, 1.0E9);
        this.threshold.setData(50.0);
        uiCartesianLayout.add(this.threshold, 5, 2, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("fftLength")), 0, 3, 5, 1);
        this.fftLength = new GComboBoxPowerOf2(4, 15);
        this.fftLength.setSelectedExponent(11);
        uiCartesianLayout.add(this.fftLength, 5, 3, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("window")), 0, 4, 5, 1);
        this.windowType = new JComboBox<String>(AOToolkit.getFFTWindowNames());
        this.windowType.setSelectedIndex(6);
        uiCartesianLayout.add(this.windowType, 5, 4, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("overlap")), 0, 5, 5, 1);
        this.overlap = new GControlTextA(7, true, true);
        this.overlap.setDataRange(0.1, 1.0);
        this.overlap.setData(0.5);
        this.overlap.setUnit("%");
        uiCartesianLayout.add(this.overlap, 5, 5, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 6, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
        this.filterMode.addActionListener(this.eventDispatcher);
        this.updateComponents();
    }

    private void updateComponents() {
        this.threshold.setEnabled(this.filterMode.getSelectedIndex() != 0);
    }

    private void onApply() {
        ALayer2DSelection aLayer2DSelection = this.getSelectedLayer().get2DSelection();
        aLayer2DSelection.operateEachChannel(new AOSpectrogramFilter(this.filterMode.getSelectedIndex(), (float)this.amplification.getData(), (float)this.threshold.getData(), this.fftLength.getSelectedValue(), this.windowType.getSelectedIndex(), (float)this.overlap.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSpectrogramFilter.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPSpectrogramFilter.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [apply] clicked");
                GPSpectrogramFilter.this.onApply();
                GPSpectrogramFilter.this.updateHistory(GLanguage.translate(GPSpectrogramFilter.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPSpectrogramFilter.this.reloadFocussedClipEditor();
                GPSpectrogramFilter.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.filterMode) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [filter mode] clicked");
                GPSpectrogramFilter.this.updateComponents();
                GPSpectrogramFilter.this.repaintFocussedClipEditor();
            }
        }
    }
}

