/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.audio.Audio;
import ch.laoe.clip.MMArray;
import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextMem;
import ch.laoe.ui.GLanguage;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import ch.oli4.ui.graph.UiPlot1DLine;
import ch.oli4.ui.graph.UiPlotDefaultModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GPSystemInfo
extends GPluginFrame
implements Runnable {
    private UiControlText freeMemory;
    private UiControlText totalMemory;
    private UiPlot1DLine memoryPlot;
    private UiPlotDefaultModel freeMemoryModel;
    private UiPlotDefaultModel totalMemoryModel;
    private JTextField pagesInfo;
    private JTextArea audioInfo;
    private JTextArea pluginInfo;
    private JButton apply;
    private JButton free;
    private EventDispatcher eventDispatcher;
    private Thread thread;
    private Runtime runtime;

    public GPSystemInfo(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.init();
    }

    @Override
    public String getName() {
        return "systemInfo";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel2, 20, 7);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout);
        this.memoryPlot = new UiPlot1DLine();
        this.memoryPlot.setDataVisible(false);
        this.memoryPlot.setPointVisible(false);
        this.memoryPlot.setPScale(0, 200);
        this.memoryPlot.setPLabelVisible(true);
        jPanel2.add((Component)this.memoryPlot, new Rectangle(0, 0, 20, 4));
        this.totalMemoryModel = new UiPlotDefaultModel(this.memoryPlot, 200);
        this.totalMemoryModel.setDefaultDataColor(Color.blue);
        this.totalMemoryModel.setLabel(GLanguage.translate("time"), 3);
        this.totalMemoryModel.setLabel(GLanguage.translate("total"), 0);
        this.memoryPlot.addModel(this.totalMemoryModel);
        this.freeMemoryModel = new UiPlotDefaultModel(this.memoryPlot, 200);
        this.freeMemoryModel.setDefaultDataColor(Color.red);
        this.freeMemoryModel.setLabel(GLanguage.translate("time"), 3);
        this.freeMemoryModel.setLabel(GLanguage.translate("free"), 0);
        this.memoryPlot.addModel(this.freeMemoryModel);
        jPanel2.add((Component)new JLabel(GLanguage.translate("freeMemory")), new Rectangle(0, 4, 4, 1));
        this.freeMemory = new GControlTextMem(7, false, true);
        this.freeMemory.setDataRange(0.0, 1.0E9);
        this.freeMemory.setEditable(false);
        jPanel2.add((Component)this.freeMemory, new Rectangle(4, 4, 5, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("totalMemory")), new Rectangle(0, 5, 4, 1));
        this.totalMemory = new GControlTextMem(7, false, true);
        this.totalMemory.setDataRange(0.0, 1.0E9);
        this.totalMemory.setEditable(false);
        jPanel2.add((Component)this.totalMemory, new Rectangle(4, 5, 5, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("pagesBlank/Loaded/Swapped/Total")), new Rectangle(10, 4, 10, 1));
        this.pagesInfo = new JTextField();
        this.pagesInfo.setEditable(false);
        jPanel2.add((Component)this.pagesInfo, new Rectangle(10, 5, 10, 1));
        this.apply = new JButton(GLanguage.translate("update"));
        jPanel2.add((Component)this.apply, new Rectangle(4, 6, 5, 1));
        this.free = new JButton(GLanguage.translate("free"));
        jPanel2.add((Component)this.free, new Rectangle(11, 6, 5, 1));
        jTabbedPane.add((Component)jPanel2, GLanguage.translate("memory"));
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel3, 20, 7);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout2);
        this.audioInfo = new JTextArea();
        this.audioInfo.setFont(new Font("Courrier", 0, 10));
        this.audioInfo.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.audioInfo);
        jPanel3.add((Component)jScrollPane, new Rectangle(0, 0, 20, 7));
        jTabbedPane.add((Component)jPanel3, GLanguage.translate("audio"));
        JPanel jPanel4 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel4, 20, 7);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel4.setLayout(uiCartesianLayout3);
        this.pluginInfo = new JTextArea();
        this.pluginInfo.setFont(new Font("Courrier", 0, 10));
        this.pluginInfo.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.pluginInfo);
        jPanel4.add((Component)jScrollPane2, new Rectangle(0, 0, 20, 7));
        jTabbedPane.add((Component)jPanel4, GLanguage.translate("plugins"));
        jPanel.add((Component)jTabbedPane, "Center");
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.frame.setResizable(true);
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.free.addActionListener(this.eventDispatcher);
    }

    @Override
    public void start() {
        super.start();
        this.audioInfo.setText(Audio.getAudioSystemInfo());
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.pluginHandler.getAllPlugins();
        for (int i = 0; i < objectArray.length; ++i) {
            GPlugin gPlugin = (GPlugin)objectArray[i];
            stringBuffer.append("" + (i + 1) + "\t");
            stringBuffer.append(GLanguage.translate(gPlugin.getName()) + "\n");
        }
        this.pluginInfo.setText(stringBuffer.toString());
    }

    private synchronized void updateNumericComponents() {
        this.freeMemory.setData(this.runtime.freeMemory());
        this.totalMemory.setData(this.runtime.totalMemory());
        this.pagesInfo.setText(MMArray.getPageInfo());
    }

    private void updateGraph() {
        this.freeMemoryModel.appendData(this.runtime.freeMemory() >> 20);
        this.totalMemoryModel.appendData(this.runtime.totalMemory() >> 20);
        this.memoryPlot.setXScale(0.0, this.totalMemoryModel.getDataMax(0, (int)this.totalMemoryModel.getPMin(), (int)this.totalMemoryModel.getPMax()));
    }

    private void init() {
        this.runtime = Runtime.getRuntime();
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                    this.updateNumericComponents();
                    this.updateGraph();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSystemInfo.this.apply) {
                Debug.println(1, "plugin " + GPSystemInfo.this.getName() + " [update numeric] clicked");
                GPSystemInfo.this.updateNumericComponents();
            } else if (actionEvent.getSource() == GPSystemInfo.this.free) {
                Debug.println(1, "plugin " + GPSystemInfo.this.getName() + " [free] clicked");
                System.gc();
            }
        }
    }
}

