/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.audio.AudioException;
import ch.laoe.clip.AClip;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GMainFrame;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GStartWindow;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.GUserInstaller;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LThemeLaoeDark;
import ch.laoe.ui.LThemeLaoeStandard;
import ch.oli4.io.CommandLineParser;
import ch.oli4.ui.UiLFTheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFrame;

public class Laoe {
    private static Laoe instance = null;
    public static final String version = "0.7.06";
    public static final String date = "22-01-2011";
    public static final String copyright = "(c) 2000-2011 oli4 switzerland";
    public static final String eAddress = "www.oli4.ch/laoe";
    public static final String eMail = "laoe@oli4.ch";
    public static final String java = "java " + System.getProperty("java.version");
    public static final String os = System.getProperty("os.name");
    public static final String license = "GNU General Public License";
    private GPersistence persistence;
    private GStartWindow startWindow;
    private GPluginHandler pluginHandler;
    private GMainFrame mainFrame;
    private ArrayList<JFrame> clipFrames;
    private GClipFrame focussedClipFrame;
    private static AClip dummyClip = null;
    private ArrayList<JFrame> visibleFrames;

    public static Laoe getInstance() {
        if (instance == null) {
            instance = new Laoe();
        }
        return instance;
    }

    private Laoe() {
        this(new String[0]);
    }

    private Laoe(String[] stringArray) {
        instance = this;
        CommandLineParser commandLineParser = new CommandLineParser(stringArray);
        if (commandLineParser.containsFlag("i")) {
            GUserInstaller.getInstance().forceInstallation();
        } else {
            GUserInstaller.getInstance().maybeInstall();
        }
        Locale.setDefault(Locale.US);
        String[] stringArray2 = commandLineParser.getArguments("f");
        String[] stringArray3 = commandLineParser.getArguments("l");
        String[] stringArray4 = commandLineParser.getArguments("d");
        if (commandLineParser.containsFlag("h")) {
            System.out.println("LAoE 0.7.06, 22-01-2011, (c) 2000-2011 oli4 switzerland");
            System.out.println("syntax: laoe -hvi [-d verboseLevel[,console]] [-l language] [-f [filename[,filename...]]]");
            System.out.println("  -h            print help information, then exit");
            System.out.println("  -v            print version, then exit");
            System.out.println("  -i            force beginning with installation-dialog, even if already installed");
            System.out.println("  verboseLevel  select the verbose level 0..9, the higher the verbose");
            System.out.println("  console       if the word \"console\" follows the verboseLevel, the debug-text is ");
            System.out.println("                printed to the console instead to the trace-file");
            System.out.println("  -d            verbose for debugging");
            System.out.println("  -l            language setting");
            System.out.println("  language      selected language [en | de | fr], default is english");
            System.out.println("  -f            open audiofiles on start");
            System.out.println("  filename      audiofilenames to open");
            System.out.println("LAoE is a graphic-layer based audiofile editor, implemented in java. ");
            System.out.println("homepage: www.oli4.ch/laoe");
            System.out.println("for questions and bugreport: laoe@oli4.ch");
            System.out.println("I hope you enjoy it !");
            System.out.println("oli4");
            System.exit(0);
        }
        if (commandLineParser.containsFlag("v")) {
            System.out.println(version);
            System.exit(0);
        }
        String string = GToolkit.getLaoeUserHomePath() + "laoe.properties";
        this.persistence = GPersistence.createPersistance(string);
        GLanguage.createLanguage("language");
        if (commandLineParser.containsFlag("l")) {
            GLanguage.setLanguage(stringArray3[0], "");
        }
        System.out.println("LAoE 0.7.06, 22-01-2011, (c) 2000-2011 oli4 switzerland");
        System.out.println("GNU General Public License, " + GLanguage.translate("<language>Version") + ", " + os + ", " + java);
        Debug.setTimeStampEnabled(true);
        if (commandLineParser.containsFlag("d")) {
            Debug.setVerboseLevel(Integer.parseInt(stringArray4[0]));
            if (stringArray4.length == 2) {
                if (!stringArray4[1].trim().equals("console")) {
                    Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
                }
            } else {
                Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
            }
        } else {
            Debug.setVerboseLevel(this.persistence.getInt("debug.verboseLevel"));
            Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
        }
        Debug.println(3, "restore persistent objects");
        Debug.println(3, "load look and feel");
        String string2 = this.persistence.getString("ui.theme");
        if (string2.equals("dark")) {
            UiLFTheme.load(new LThemeLaoeDark());
        } else if (string2.equals("standard")) {
            UiLFTheme.load(new LThemeLaoeStandard());
        } else {
            UiLFTheme.load(new LThemeLaoeDark());
        }
        this.startWindow = new GStartWindow();
        this.mainFrame = new GMainFrame();
        this.clipFrames = new ArrayList();
        this.visibleFrames = new ArrayList();
        this.pluginHandler = new GPluginHandler();
        this.mainFrame.updateButtons();
        this.mainFrame.setVisible(true);
        this.startWindow.setWorkInfo(GLanguage.translate("loadAudioFiles") + "...");
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.addClipFrame(new File(stringArray2[i]));
            }
        }
        this.startWindow.setWorkInfo(GLanguage.translate("ready") + " !");
        this.startWindow.onEndOfStart(3000);
    }

    public static String[] getAllThemes() {
        return new String[]{"dark", "standard"};
    }

    public GStartWindow getStartWindow() {
        return this.startWindow;
    }

    public GPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public GMainFrame getMainFrame() {
        return this.mainFrame;
    }

    private void createClipFrame(AClip aClip) {
        Debug.println(3, "create clip frame " + aClip.getName());
        GClipFrame gClipFrame = new GClipFrame(aClip);
        if (this.getFocussedClipFrame() != null) {
            gClipFrame.setLocation(this.getFocussedClipFrame().getLocation().x + 30, this.getFocussedClipFrame().getLocation().y + 30);
        }
        this.clipFrames.add(gClipFrame);
        this.setFocussedClipFrame(gClipFrame);
        gClipFrame.setVisible(true);
    }

    public void addClipFrame(AClip aClip) {
        this.createClipFrame(aClip);
    }

    public void addClipFrame(File file) {
        try {
            LProgressViewer.getInstance().entrySubProgress(0.9);
            AClip aClip = new AClip(file);
            this.createClipFrame(aClip);
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (AudioException audioException) {
            GDialog.showErrorDialog(null, "audioError", audioException.getMessage());
        }
    }

    public void removeClipFrame(GClipFrame gClipFrame) {
        Debug.println(3, "remove clip frame " + gClipFrame.getClipEditor().getClip().getName());
        this.clipFrames.remove(gClipFrame);
        if (dummyClip == null) {
            dummyClip = new AClip(1, 1, 0);
        }
        this.setFocussedClipFrame(new GClipFrame(dummyClip));
        System.gc();
    }

    public Object[] getAllClipFrames() {
        return this.clipFrames.toArray();
    }

    public void setFocussedClipFrame(GClipFrame gClipFrame) {
        this.focussedClipFrame = gClipFrame;
        if (gClipFrame != null) {
            this.pluginHandler.reloadAllPlugins(null);
            this.pluginHandler.getFocussedClipEditor().repaint();
        }
    }

    public GClipFrame getFocussedClipFrame() {
        return this.focussedClipFrame;
    }

    public GClipEditor getFocussedClipEditor() {
        if (this.focussedClipFrame != null) {
            return this.focussedClipFrame.getClipEditor();
        }
        return null;
    }

    public void iconifyAllFrames() {
        this.visibleFrames.clear();
        for (int i = 0; i < this.clipFrames.size(); ++i) {
            JFrame jFrame = this.clipFrames.get(i);
            if (jFrame.getState() != 0) continue;
            this.visibleFrames.add(jFrame);
            jFrame.setState(1);
        }
        this.getPluginHandler().iconifyAllFrames();
    }

    public void deiconifyAllFrames() {
        for (int i = 0; i < this.visibleFrames.size(); ++i) {
            JFrame jFrame = this.visibleFrames.get(i);
            jFrame.setState(0);
        }
        this.getPluginHandler().deiconifyAllFrames();
    }

    public static void main(String[] stringArray) {
        new Laoe(stringArray);
    }
}

