/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ErrorOutputStream
extends FilterOutputStream {
    private int burstErrorCounter;
    private boolean randomErrorsEnable;
    private double bitErrorProbability;
    private double parasitErrorProbability;
    private double absorbErrorProbability;
    private double frameErrorProbability;
    private double byteErrorProbability;
    private byte frameLimiterByte;
    private byte originalByte;
    private byte modifiedByte;
    private boolean frameErrorOccured;
    private int numberOfWrittenBytes;
    private int numberOfBitErrors;
    private int numberOfParasitErrors;
    private int numberOfAbsorbErrors;
    private int numberOfFrameErrors;
    private int numberOfByteErrors;

    public ErrorOutputStream(OutputStream out) {
        super(out);
    }

    public void setBurstError(int burstLength) {
    }

    public void setRandomErrorsEnabled(boolean enable) {
        this.randomErrorsEnable = enable;
    }

    public void setBitErrorProbability(double probability) {
        this.bitErrorProbability = probability;
    }

    public void setParasitErrorProbability(double probability) {
        this.parasitErrorProbability = probability;
    }

    public void setAbsorbErrorProbability(double probability) {
        this.absorbErrorProbability = probability;
    }

    public void setFrameErrorProbability(byte frameLimiter, double probability) {
        this.frameLimiterByte = frameLimiter;
        this.frameErrorProbability = probability;
    }

    public void setByteErrorProbability(byte original, byte modified, double probability) {
        this.originalByte = original;
        this.modifiedByte = modified;
        this.byteErrorProbability = probability;
    }

    public int getNumberOfWrittenBytes() {
        return this.numberOfWrittenBytes;
    }

    public int getNumberOfBitErrors() {
        return this.numberOfBitErrors;
    }

    public int getNumberOfParasitErrors() {
        return this.numberOfParasitErrors;
    }

    public int getNumberOfAbsorbErrors() {
        return this.numberOfAbsorbErrors;
    }

    public int getNumberOfFrameErrors() {
        return this.numberOfFrameErrors;
    }

    public int getNumberOfByteErrors() {
        return this.numberOfByteErrors;
    }

    private int modifyOneBit(int b) {
        int i = (int)(Math.random() * 7.0);
        return b ^ 1 << i;
    }

    private boolean occured(double probability) {
        if (probability == 0.0) {
            return false;
        }
        return Math.random() < probability;
    }

    public void write(int b) throws IOException {
        ++this.numberOfWrittenBytes;
        if (this.burstErrorCounter-- > 0) {
            this.out.write(this.modifyOneBit(b));
            return;
        }
        if (this.randomErrorsEnable) {
            if (b == this.originalByte && this.occured(this.byteErrorProbability)) {
                this.out.write(this.modifiedByte);
                ++this.numberOfByteErrors;
                return;
            }
            if (b == this.frameLimiterByte) {
                this.frameErrorOccured = false;
            } else if (this.occured(this.frameErrorProbability)) {
                this.frameErrorOccured = true;
                ++this.numberOfFrameErrors;
                this.out.write(this.modifyOneBit(b));
                return;
            }
            if (this.occured(this.bitErrorProbability)) {
                this.out.write(this.modifyOneBit(b));
                ++this.numberOfBitErrors;
                return;
            }
            if (this.occured(this.parasitErrorProbability)) {
                this.out.write(b);
                this.out.write((byte)(Math.random() * 255.0));
                ++this.numberOfParasitErrors;
                return;
            }
            if (this.occured(this.absorbErrorProbability)) {
                ++this.numberOfAbsorbErrors;
                return;
            }
            this.out.write(b);
        } else {
            this.out.write(b);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

