/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io.hexfile;

import ch.oli4.io.hexfile.HexRecData;
import ch.oli4.io.hexfile.HexRecExtLinAddr;
import ch.oli4.io.hexfile.HexRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class HexFile {
    private Vector records = new Vector(100);

    public void appendRecord(HexRecord r) {
        this.records.add(r);
    }

    public void insertRecord(HexRecord r, int index) {
        this.records.insertElementAt(r, index);
    }

    public void removeRecord(int index) {
        if (index < this.records.size()) {
            this.records.remove(index);
        }
    }

    public HexRecord getRecord(int index) {
        if (index < this.records.size()) {
            return (HexRecord)this.records.get(index);
        }
        return null;
    }

    public HexRecord getLastRecord() {
        return (HexRecord)this.records.lastElement();
    }

    public int getNumberOfRecords() {
        return this.records.size();
    }

    public int getNumberOfRecords(HexRecord r) {
        int n = 0;
        int i = 0;
        while (i < this.records.size()) {
            if (this.getRecord(i).isSameType(r)) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public void appendHexFile(HexFile anotherHexFile) {
        if (this.getNumberOfRecords() > 0 && this.getLastRecord().isEofType()) {
            System.out.println("    remove old EOF record[" + (this.getNumberOfRecords() - 1) + "]");
            this.removeRecord(this.getNumberOfRecords() - 1);
        }
        if (!anotherHexFile.getRecord(0).isExtLinAddrType()) {
            System.out.println("    add missing ext lin address of 0 record[0] at beginning of append");
            this.appendRecord(HexRecExtLinAddr.createRecord(0));
        }
        int i = 0;
        while (i < anotherHexFile.getNumberOfRecords()) {
            this.appendRecord(anotherHexFile.getRecord(i));
            ++i;
        }
    }

    public void removeRedundantExtLinAddrRecords() {
        int address = 0;
        int i = 0;
        while (i < this.getNumberOfRecords()) {
            if (this.getRecord(i).isExtLinAddrType()) {
                HexRecExtLinAddr r = (HexRecExtLinAddr)this.getRecord(i);
                if (r.getExtendedLinearAddress() == address) {
                    System.out.println("  remove ext-lin-addr record at record[" + i + "]");
                    this.removeRecord(i);
                } else {
                    ++i;
                }
                address = r.getExtendedLinearAddress();
                continue;
            }
            ++i;
        }
    }

    public boolean parse(InputStream is) {
        byte[] d;
        this.records.removeAllElements();
        try {
            int readLength;
            d = new byte[1000000];
            int offset = 0;
            int maxLength = 200;
            while ((readLength = is.read(d, offset, maxLength)) >= 0) {
                offset += readLength;
            }
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        Vector<Integer> bofs = new Vector<Integer>(100);
        char bof = HexRecord.getBeginOfRecord();
        int i = 0;
        while (i < d.length) {
            if (d[i] == (byte)bof) {
                bofs.add(new Integer(i));
            }
            ++i;
        }
        i = 0;
        while (i < bofs.size()) {
            if (i < bofs.size() - 1) {
                this.appendRecord(HexRecord.parse(d, (Integer)bofs.get(i), (Integer)bofs.get(i + 1)));
            } else {
                this.appendRecord(HexRecord.parse(d, (Integer)bofs.get(i), d.length));
            }
            ++i;
        }
        return true;
    }

    public boolean save(OutputStream os) {
        try {
            byte[] d = new byte[200];
            int i = 0;
            while (i < this.getNumberOfRecords()) {
                int l = this.getRecord(i).toBytes(d);
                String s = new String(d, 0, l);
                os.write(s.toUpperCase().getBytes(), 0, l);
                ++i;
            }
            os.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public int getNumberOfRecords(int type) {
        int n = 0;
        int i = 0;
        while (i < this.getNumberOfRecords()) {
            if (this.getRecord(i).getType() == type) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int getNumberOfDataBytes() {
        int n = 0;
        int i = 0;
        while (i < this.getNumberOfRecords()) {
            if (this.getRecord(i).isDataType()) {
                HexRecData r = (HexRecData)this.getRecord(i);
                n += r.getDataLength();
            }
            ++i;
        }
        return n;
    }

    public int getMinDataByteAddress() {
        int lowestAddr = Integer.MAX_VALUE;
        int extLinAddr = 0;
        int addr = 0;
        int i = 0;
        while (i < this.getNumberOfRecords()) {
            HexRecord r;
            if (this.getRecord(i).isExtLinAddrType()) {
                r = (HexRecExtLinAddr)this.getRecord(i);
                extLinAddr = ((HexRecExtLinAddr)r).getExtendedLinearAddress() << 16;
            } else if (this.getRecord(i).isDataType() && (addr = (r = (HexRecData)this.getRecord(i)).getAddress() + extLinAddr) < lowestAddr) {
                lowestAddr = addr;
            }
            ++i;
        }
        return lowestAddr;
    }

    public int getMaxDataByteAddress() {
        int highestAddr = 0;
        int extLinAddr = 0;
        int addr = 0;
        int i = 0;
        while (i < this.getNumberOfRecords()) {
            HexRecord r;
            if (this.getRecord(i).isExtLinAddrType()) {
                r = (HexRecExtLinAddr)this.getRecord(i);
                extLinAddr = ((HexRecExtLinAddr)r).getExtendedLinearAddress() << 16;
            } else if (this.getRecord(i).isDataType() && (addr = (r = (HexRecData)this.getRecord(i)).getDataLength() - 1 + r.getAddress() + extLinAddr) > highestAddr) {
                highestAddr = addr;
            }
            ++i;
        }
        return highestAddr;
    }

    public boolean beginsWithExtLinAddrRecord() {
        if (this.getNumberOfRecords() > 0) {
            return this.getRecord(0).isExtLinAddrType();
        }
        return false;
    }

    public boolean endsWithEofRecord() {
        if (this.getNumberOfRecords() > 0) {
            return this.getLastRecord().isEofType();
        }
        return false;
    }
}

