/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MMouse;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.GameCollectedObjects;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.trace.Trace;
import java.awt.Color;
import java.awt.Rectangle;

public class ActiveArea
extends EventProducer {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int cursor;
    private int objectCursor;
    private boolean enabled = true;
    private String stateWhenShowingObjectCursor;

    public ActiveArea(String name, int x1, int y1, int x2, int y2, int cursor, String stateWhenShowingObjectCursor) {
        super(name);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.cursor = cursor;
        this.objectCursor = GameCollectedObjects.getInstance().getCursor(stateWhenShowingObjectCursor);
        this.stateWhenShowingObjectCursor = stateWhenShowingObjectCursor;
    }

    public ActiveArea(String name, int x1, int y1, int x2, int y2, int cursor) {
        this(name, x1, y1, x2, y2, cursor, null);
    }

    public ActiveArea(String name, Rectangle r, int cursor) {
        this(name, r.x, r.y, r.x + r.width, r.y + r.height, cursor);
    }

    boolean run() {
        if (this.enabled && MMouse.getInstance().isInside(this.x1, this.y1, this.x2, this.y2)) {
            if (this.enabled) {
                if (this.stateWhenShowingObjectCursor != null && GameState.getInstance().getBoolean(this.stateWhenShowingObjectCursor, false)) {
                    MMouse.getInstance().setCursor(this.objectCursor);
                } else {
                    MMouse.getInstance().setCursor(this.cursor);
                }
            } else {
                MMouse.getInstance().setCursor(1);
            }
            if (MMouse.getInstance().justReleased()) {
                this.fireEvent();
            }
            return true;
        }
        return false;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void print() {
        if (Trace.getInstance().isVerboseLevel(3)) {
            if (this.enabled) {
                Game.getInstance().getPanel().printRectangle(this.x1, this.y1, this.x2, this.y2, Color.green, true);
            } else {
                Game.getInstance().getPanel().printRectangle(this.x1, this.y1, this.x2, this.y2, Color.white, true);
            }
        }
    }
}

