/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MTimer;
import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CObjectAudio;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.mmedia.game.PassiveArea;
import ch.oli4.mmedia.game.Path;
import ch.oli4.mmedia.game.Perspective;
import ch.oli4.mmedia.game.PrintedImage;

public class CObjectDoor
extends CObject {
    protected ActiveArea openArea;
    protected ActiveArea closeArea;
    protected ActiveArea navigateArea;
    protected PassiveArea openBlocker;
    protected PassiveArea closeBlocker;
    protected CObject openObject;
    protected CObject closeObject;
    protected CObject lockedObject;
    protected PrintedImage openImage;
    protected PrintedImage handleDownImage;
    protected String path;
    protected String openCondition;
    protected String openState;
    protected boolean handleDown;
    protected boolean open;
    protected boolean walkedThrough;
    protected boolean closeWhenWalkedThrough;

    public CObjectDoor(ActiveArea openArea, PassiveArea openBlocker, ActiveArea closeArea, PassiveArea closeBlocker, ActiveArea navigateArea, CObject openObject, CObject closeObject, CObject lockedObject, PrintedImage openImage, PrintedImage handleDownImage, String path, String openCondition, String openState, boolean closeWhenWalkedThrough) {
        this.openArea = openArea;
        this.openBlocker = openBlocker;
        this.closeArea = closeArea;
        this.closeBlocker = closeBlocker;
        this.navigateArea = navigateArea;
        this.openObject = openObject;
        this.closeObject = closeObject;
        this.lockedObject = lockedObject;
        this.openImage = openImage;
        this.handleDownImage = handleDownImage;
        this.path = path;
        this.openCondition = openCondition;
        this.openState = openState;
        this.closeWhenWalkedThrough = closeWhenWalkedThrough;
    }

    public CObjectDoor(ActiveArea openArea, PassiveArea openBlocker, ActiveArea closeArea, PassiveArea closeBlocker, ActiveArea navigateArea, String openNoise, String closeNoise, String lockedNoise, PrintedImage openImage, PrintedImage handleDownImage, String path, String openCondition, String openState, boolean closeWhenWalkedThrough) {
        this(openArea, openBlocker, closeArea, closeBlocker, navigateArea, new CObjectAudio(openNoise, false), new CObjectAudio(closeNoise, false), new CObjectAudio(lockedNoise, false), openImage, handleDownImage, path, openCondition, openState, closeWhenWalkedThrough);
    }

    public CObjectDoor(ActiveArea openArea, ActiveArea closeArea, ActiveArea navigateArea, String openNoise, String closeNoise, String lockedNoise, PrintedImage openImage, String path, String openCondition, String openState, boolean closeWhenWalkedThrough) {
        this(openArea, null, closeArea, null, navigateArea, openNoise, closeNoise, lockedNoise, openImage, null, path, openCondition, openState, closeWhenWalkedThrough);
    }

    void print() {
        if (this.open && this.openImage != null) {
            this.openImage.print();
        }
        if (this.handleDown && this.handleDownImage != null) {
            this.handleDownImage.print();
        }
    }

    void init(Perspective p) {
        this.open = false;
        this.walkedThrough = false;
        p.add(this.openArea);
        p.add(this.closeArea);
        if (this.navigateArea != null) {
            p.add(this.navigateArea);
        }
        if (this.openBlocker != null) {
            p.add(this.openBlocker);
        }
        if (this.closeBlocker != null) {
            p.add(this.closeBlocker);
        }
        if (this.openObject != null) {
            this.openObject.init(p);
        }
        if (this.closeObject != null) {
            this.closeObject.init(p);
        }
        if (this.lockedObject != null) {
            this.lockedObject.init(p);
        }
        this.updateOpenClose();
    }

    protected void updateOpenClose() {
        GameState.getInstance().setBoolean(this.openState, this.open);
        this.openArea.setEnabled(!this.open);
        this.closeArea.setEnabled(this.open);
        if (this.navigateArea != null) {
            this.navigateArea.setEnabled(this.open);
        }
        if (this.openBlocker != null) {
            this.openBlocker.setEnabled(this.open);
        }
        if (this.closeBlocker != null) {
            this.closeBlocker.setEnabled(!this.open);
        }
    }

    void performOpen(CPerspective p, boolean cleanupOthersFirst) {
        if (!this.open) {
            if (GameState.getInstance().getBoolean(this.openCondition, false) || this.openCondition == null) {
                if (cleanupOthersFirst) {
                    p.cleanupOthers(this);
                }
                if (this.handleDownImage != null) {
                    this.handleDown = true;
                    p.reprint();
                    MTimer.sleep(333);
                    this.handleDown = false;
                    p.reprint();
                }
                if (this.openObject != null) {
                    this.openObject.setup();
                    MTimer.sleep(333);
                }
                this.open = true;
            } else {
                if (this.handleDownImage != null) {
                    this.handleDown = true;
                    p.reprint();
                    MTimer.sleep(333);
                    this.handleDown = false;
                    p.reprint();
                }
                if (this.lockedObject != null) {
                    this.lockedObject.setup();
                    MTimer.sleep(333);
                }
            }
        }
    }

    void performClose() {
        if (this.open) {
            if (this.closeObject != null) {
                this.closeObject.setup();
                MTimer.sleep(333);
            }
            this.open = false;
        }
    }

    void setup() {
        this.walkedThrough = false;
        if (this.closeWhenWalkedThrough) {
            this.open = false;
            this.updateOpenClose();
        }
    }

    void perform(CPerspective p, EventProducer a) {
        if (a == this.openArea) {
            this.performOpen(p, true);
        } else if (a == this.closeArea) {
            this.performClose();
        } else if (this.navigateArea != null && a == this.navigateArea && this.path != null) {
            this.walkedThrough = true;
            Game.getInstance().setNextPath(new Path(this.path));
        }
        this.updateOpenClose();
    }

    void cleanup() {
        if (!this.walkedThrough) {
            this.performClose();
        }
        this.updateOpenClose();
    }
}

