/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Path {
    private ArrayList<String> list = new ArrayList();
    private boolean absolute;
    private static String separator = "/";
    private static String navigateUp = "..";

    public Path(String path) {
        path = path.trim();
        if (path.length() > 0) {
            if (path.startsWith(separator)) {
                this.absolute = true;
                path = path.substring(1);
            } else {
                this.absolute = false;
            }
            StringTokenizer st = new StringTokenizer(path, separator);
            while (st.hasMoreTokens()) {
                this.list.add(st.nextToken());
            }
        } else {
            this.absolute = false;
        }
    }

    public Path() {
        this("");
    }

    public void addNode(String name) {
        this.list.add(name);
    }

    public boolean contains(Path p) {
        if (p.list.size() > this.list.size()) {
            return false;
        }
        int i = 0;
        while (i < p.list.size()) {
            if (!p.list.get(i).equals(this.list.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Path p) {
        if (p.list.size() != this.list.size()) {
            return false;
        }
        int i = 0;
        while (i < p.list.size()) {
            if (!p.list.get(i).equals(this.list.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void apply(Path rp) {
        if (this.isAbsolute()) {
            if (rp.isAbsolute()) {
                this.list = rp.list;
            } else {
                for (String i : rp.list) {
                    if (i.equals(navigateUp)) {
                        if (this.list.size() <= 0) continue;
                        this.list.remove(this.list.size() - 1);
                        continue;
                    }
                    this.list.add(i);
                }
            }
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isAbsolute()) {
            sb.append(separator);
        }
        for (String i : this.list) {
            sb.append(i);
            sb.append(separator);
        }
        String s = sb.toString();
        if (s.length() > 0) {
            return s.substring(0, s.length() - 1);
        }
        return "";
    }
}

