/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiAppl;
import ch.oli4.ui.UiDialog;
import ch.oli4.ui.UiHelp;
import ch.oli4.ui.UiMainPanel;
import ch.oli4.ui.UiMenuBar;
import ch.oli4.ui.UiStatusBar;
import ch.oli4.ui.UiToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class UiFrame
extends JFrame
implements WindowListener {
    private UiAppl appl;
    public static final int CLOSE_NOTHING = 0;
    public static final int CLOSE_ONLY_THIS = 1;
    public static final int CLOSE_ALL_AND_EXIT = 2;
    private int closeAction;
    private UiMenuBar menuBar;
    private JPanel statusBarPanel;
    private UiStatusBar statusBar;
    private JPanel[] toolBarPanel;
    private UiToolBar[] toolBar;
    public static final int numberOfToolBars = 5;
    private UiMainPanel mainPanel;
    private UiHelp help;
    private UiDialog dialog;

    public UiFrame(UiAppl appl) {
        this.appl = appl;
        this.initComponents();
        this.initEvents();
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UiAppl getAppl() {
        return this.appl;
    }

    public void setCloseAction(int a) {
        this.closeAction = a;
    }

    public void doClose() {
        this.setVisible(false);
        if (this.help != null) {
            this.help.setVisible(false);
        }
        this.onClose();
    }

    public void onClose() {
    }

    public void doExit() {
        System.exit(0);
    }

    public void tryToClose() {
        if (this.dialog.showCloseDialog()) {
            this.doClose();
        }
    }

    public void tryToExit() {
        if (this.dialog.showExitDialog()) {
            this.appl.closeAllFrames();
            System.exit(0);
        }
    }

    private void initComponents() {
        this.statusBarPanel = new JPanel();
        this.statusBarPanel.setLayout(new BorderLayout());
        this.getContentPane().add(this.statusBarPanel);
        this.toolBar = new UiToolBar[5];
        this.toolBarPanel = new JPanel[5];
        int i = 0;
        while (i < 5) {
            this.toolBarPanel[i] = new JPanel();
            this.toolBarPanel[i].setLayout(new BorderLayout());
            if (i > 0) {
                this.toolBarPanel[i - 1].add(this.toolBarPanel[i]);
            }
            ++i;
        }
        this.statusBarPanel.add(this.toolBarPanel[0]);
    }

    public final void setFrameIcon(String icon) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(icon));
    }

    public final Image getFrameImage() {
        return this.getIconImage();
    }

    public void add(UiMenuBar menuBar) {
        this.menuBar = menuBar;
        this.setJMenuBar(this.menuBar);
    }

    public UiMenuBar getUiMenuBar() {
        return this.menuBar;
    }

    public void add(UiToolBar toolBar, int index, String border) {
        if (this.toolBar[index] != null) {
            this.toolBarPanel[index].remove(this.toolBar[index]);
        }
        this.toolBar[index] = toolBar;
        this.toolBarPanel[index].add((Component)this.toolBar[index], border);
        this.toolBar[index].setVisible(true);
        this.toolBarPanel[index].validate();
    }

    public void add(UiToolBar toolBar, int index) {
        this.add(toolBar, index, "North");
    }

    public UiToolBar getUiToolBar(int index) {
        return this.toolBar[index];
    }

    public void setUiToolBarVisible(boolean b, int index) {
        this.toolBar[index].setVisible(b);
        this.toolBarPanel[index].validate();
    }

    public void add(UiMainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.toolBarPanel[4].add((Component)this.mainPanel, "Center");
        this.toolBarPanel[4].validate();
    }

    public UiMainPanel getUiMainPanel() {
        return this.mainPanel;
    }

    public void add(UiStatusBar statusBar) {
        this.statusBar = statusBar;
        this.statusBarPanel.add((Component)this.statusBar, "South");
        this.statusBarPanel.validate();
    }

    public UiStatusBar getUiStatusBar() {
        return this.statusBar;
    }

    public void setUiStatusBarVisible(boolean b) {
        this.statusBar.setVisible(b);
        this.statusBarPanel.validate();
    }

    public void add(UiHelp h) {
        this.help = h;
    }

    public UiHelp getUiHelp() {
        return this.help;
    }

    public void add(UiDialog d) {
        this.dialog = d;
    }

    public UiDialog getUiDialog() {
        return this.dialog;
    }

    public void rebuild() {
    }

    private void initEvents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public final void windowClosing(WindowEvent e) {
        switch (this.closeAction) {
            case 0: {
                break;
            }
            case 1: {
                this.tryToClose();
                break;
            }
            case 2: {
                this.tryToExit();
            }
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

