/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiCartesianLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class UiProgressViewer
extends JFrame {
    private JPanel panel;
    private JLabel note;
    private JProgressBar percent;
    private JToggleButton cancel;
    private final Timer t = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            UiProgressViewer.this.setVisible(false);
            UiProgressViewer.this.t.stop();
        }
    });
    private long timeStamp;
    private static int updatePeriod = 100;
    private static final int maxSubProgressDepth = 10;
    private int[] progressStep;
    private int[] progressOffset;
    private String[] progressNotes;
    private int subProgressDepth;
    private int unknownProgressCounter;

    public UiProgressViewer() {
        this.initProgress();
        this.setDefaultCloseOperation(1);
        this.panel = new JPanel();
        UiCartesianLayout cl = new UiCartesianLayout(this.panel, 10, 3);
        cl.setPreferredCellSize(new Dimension(35, 25));
        this.panel.setLayout(cl);
        this.note = new JLabel("...", 0);
        cl.add(this.note, 0, 0, 10, 1);
        this.percent = new JProgressBar(0, 0, 100);
        this.percent.setStringPainted(true);
        cl.add(this.percent, 0, 1, 10, 1);
        this.cancel = new JToggleButton("cancel");
        cl.add(this.cancel, 3, 2, 4, 1);
        this.getContentPane().add(this.panel);
        this.pack();
        this.setLocation((int)(this.getToolkit().getScreenSize().getWidth() - (double)this.getWidth()) / 2, (int)(this.getToolkit().getScreenSize().getHeight() - (double)this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(false);
    }

    private void paintImmediately() {
        this.panel.paintImmediately(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void start(String title) {
        this.setTitle(String.valueOf(title) + "...");
        this.clearProgress();
        this.setNote(title);
        this.cancel.setSelected(false);
        this.setVisible(true);
        this.setState(0);
        this.paintImmediately();
    }

    public void finish() {
        this.printProgress(100);
        this.setNote("ok");
        this.t.start();
    }

    private boolean isEnoughTimeElapsed() {
        long t = System.currentTimeMillis();
        if (t - this.timeStamp > (long)updatePeriod) {
            this.timeStamp = t;
            return true;
        }
        return false;
    }

    private void initProgress() {
        this.progressStep = new int[10];
        this.progressOffset = new int[10];
        this.progressNotes = new String[10];
        this.subProgressDepth = 0;
    }

    private void clearProgress() {
        this.printProgress(0);
        int i = 0;
        while (i < this.subProgressDepth) {
            this.progressOffset[i] = 0;
            this.progressStep[i] = 0;
            ++i;
        }
        this.subProgressDepth = 0;
    }

    public void entrySubProgress() {
        this.entrySubProgress(null);
    }

    public void entrySubProgress(String n) {
        if (this.subProgressDepth < 9) {
            ++this.subProgressDepth;
            this.progressStep[this.subProgressDepth] = 0;
            this.progressOffset[this.subProgressDepth] = 0;
            this.progressNotes[this.subProgressDepth] = n;
            this.calculateGlobalNote();
        }
    }

    public void exitSubProgress() {
        if (this.subProgressDepth > 0) {
            --this.subProgressDepth;
        }
    }

    public boolean setProgress(int p) {
        int n = this.subProgressDepth;
        this.progressOffset[n] = this.progressOffset[n] + this.progressStep[this.subProgressDepth];
        this.progressStep[this.subProgressDepth] = p - this.progressOffset[this.subProgressDepth];
        if (this.isEnoughTimeElapsed()) {
            this.percent.setForeground(Color.RED);
            this.calculateGlobalProgress();
        }
        if (this.cancel.isSelected()) {
            this.setNote("canceled");
            this.t.start();
            return true;
        }
        return false;
    }

    public boolean setUnknownProgress() {
        if (this.isEnoughTimeElapsed()) {
            ++this.unknownProgressCounter;
            this.percent.setValue(100);
            int maxDots = 32;
            int dots = this.unknownProgressCounter & 0x1F;
            if (dots > 16) {
                dots = 32 - dots;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("....");
            int i = 0;
            while (i < dots) {
                sb.append(".");
                ++i;
            }
            this.percent.setString(sb.toString());
            this.percent.setForeground(Color.RED);
            this.paintImmediately();
        }
        if (this.cancel.isSelected()) {
            this.setNote("canceled");
            this.t.start();
            return true;
        }
        return false;
    }

    private void calculateGlobalProgress() {
        int p = 0;
        int i = this.subProgressDepth;
        while (i >= 1) {
            if (this.progressStep[i] != 0 || this.progressOffset[i] != 0) {
                p = p * this.progressStep[i] / 100 + this.progressOffset[i];
            }
            --i;
        }
        this.printProgress(p);
    }

    private void printProgress(int p) {
        this.percent.setValue(p);
        this.percent.setString(p + "%");
        this.paintImmediately();
    }

    private void calculateGlobalNote() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= this.subProgressDepth) {
            if (this.progressNotes[i] != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.progressNotes[i]);
            }
            ++i;
        }
        this.setNote(new String(sb));
    }

    public void setNote(String n) {
        this.note.setText(n);
        this.paintImmediately();
    }
}

