/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiScreenSaver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiScreenSaverBubble
extends UiScreenSaver
implements Runnable {
    private Thread thread;
    private boolean running;
    private Color bubbleColor;
    private int maxNumberOfBubbles = 10;
    private static final int minBubbleLivingAge = 200;
    private static final int maxBubbleLivingAge = 800;
    private static final int minBubbleDeadAge = 100;
    private static final int maxBubbleDeadAge = 400;
    private static final int maxBubbleDyingAge = 1;
    private static final float minBubbleV = 0.1f;
    private static final float maxBubbleV = 2.0f;
    private static final float bubbleVLuftreibungsReduktor = 0.87f;
    private static final float bubbleVBirth = -50.0f;
    private static final float minBubbleA = -0.25f;
    private static final float maxBubbleA = 0.25f;
    private static final float minBubbleSize = 20.0f;
    private static final float maxBubbleSize = 80.0f;
    private static final int defaultNumberOfBubbles = 10;
    private static final int LIVING = 1;
    private static final int DYING = 2;
    private static final int DEAD = 3;
    private int[] bubbleState;
    private int[] bubbleActualStateAge;
    private int[] bubbleMaxStateAge;
    private float[] bubblePX;
    private float[] bubblePY;
    private float[] bubbleSizeX;
    private float[] bubbleSizeY;
    private float[] bubbleOscSizeX;
    private float[] bubbleOscSizeY;
    private float[] bubbleDSize;
    private float[] bubbleAlphaOsc;
    private float[] bubblePhiOsc;
    private float[] bubbleDAlphaOsc;
    private float[] bubbleVX;
    private float[] bubbleVY;
    private float[] bubbleAX;
    private float[] bubbleAY;

    public UiScreenSaverBubble(JFrame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.bubbleColor = new Color(0xFFFFDD);
        this.bubbleState = new int[this.maxNumberOfBubbles];
        this.bubbleActualStateAge = new int[this.maxNumberOfBubbles];
        this.bubbleMaxStateAge = new int[this.maxNumberOfBubbles];
        this.bubblePX = new float[this.maxNumberOfBubbles];
        this.bubblePY = new float[this.maxNumberOfBubbles];
        this.bubbleVX = new float[this.maxNumberOfBubbles];
        this.bubbleVY = new float[this.maxNumberOfBubbles];
        this.bubbleAX = new float[this.maxNumberOfBubbles];
        this.bubbleAY = new float[this.maxNumberOfBubbles];
        this.bubbleSizeX = new float[this.maxNumberOfBubbles];
        this.bubbleSizeY = new float[this.maxNumberOfBubbles];
        this.bubbleOscSizeX = new float[this.maxNumberOfBubbles];
        this.bubbleOscSizeY = new float[this.maxNumberOfBubbles];
        this.bubbleDSize = new float[this.maxNumberOfBubbles];
        this.bubbleAlphaOsc = new float[this.maxNumberOfBubbles];
        this.bubblePhiOsc = new float[this.maxNumberOfBubbles];
        this.bubbleDAlphaOsc = new float[this.maxNumberOfBubbles];
        int i = 0;
        while (i < this.maxNumberOfBubbles) {
            this.bubbleInit(i);
            ++i;
        }
    }

    public void start() {
        super.start();
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
    }

    public void stop() {
        super.stop();
        this.running = false;
    }

    public void run() {
        while (this.running) {
            this.sample();
            this.repaint();
            try {
                Thread.sleep(125L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setBubbleColor(Color c) {
        this.bubbleColor = c;
    }

    public void setNumberOfBubbles(int n) {
        this.maxNumberOfBubbles = n;
        this.init();
    }

    private void bubbleInit(int i) {
        this.bubbleState[i] = 1;
        this.bubbleActualStateAge[i] = 0;
        this.bubbleMaxStateAge[i] = 200 + (int)(Math.random() * 600.0);
        this.bubbleSizeX[i] = 20.0f + (float)Math.random() * 60.0f;
        this.bubbleSizeY[i] = this.bubbleSizeX[i];
        this.bubbleDSize[i] = this.bubbleSizeX[i] * (float)Math.random() * 0.1f;
        this.bubbleAlphaOsc[i] = (float)(Math.random() * 2.0 * Math.PI);
        this.bubblePhiOsc[i] = (float)(Math.random() * Math.PI + 1.5707963267948966);
        this.bubbleDAlphaOsc[i] = (float)(Math.random() * 0.3 + 0.01);
        this.bubblePX[i] = (float)Math.random() * ((float)this.frame.getWidth() - this.bubbleSizeX[i]);
        this.bubblePY[i] = (float)Math.random() * ((float)this.frame.getHeight() - this.bubbleSizeY[i]);
        this.bubbleVX[i] = 0.1f + (float)Math.random() * 1.9f;
        this.bubbleVY[i] = 0.1f + (float)Math.random() * 1.9f;
        this.bubbleAX[i] = -0.25f + (float)Math.random() * 0.5f;
        this.bubbleAY[i] = -0.25f + (float)Math.random() * 0.5f;
    }

    private void entryState(int i, int state) {
        this.bubbleState[i] = state;
        switch (state) {
            case 1: {
                this.bubbleActualStateAge[i] = 0;
                this.bubbleMaxStateAge[i] = 200 + (int)(Math.random() * 600.0);
                this.bubbleInit(i);
                this.bubbleVY[i] = -50.0f;
                this.bubblePX[i] = this.frame.getWidth() / 2;
                this.bubblePY[i] = this.frame.getHeight();
                break;
            }
            case 2: {
                this.bubbleActualStateAge[i] = 0;
                this.bubbleMaxStateAge[i] = 1;
                break;
            }
            case 3: {
                this.bubbleActualStateAge[i] = 0;
                this.bubbleMaxStateAge[i] = 100 + (int)(Math.random() * 300.0);
            }
        }
    }

    private void doState(int i) {
        switch (this.bubbleState[i]) {
            case 1: {
                int n = i;
                this.bubbleActualStateAge[n] = this.bubbleActualStateAge[n] + 1;
                if (this.bubbleActualStateAge[n] < this.bubbleMaxStateAge[i]) break;
                this.entryState(i, 2);
                break;
            }
            case 2: {
                int n = i;
                this.bubbleActualStateAge[n] = this.bubbleActualStateAge[n] + 1;
                if (this.bubbleActualStateAge[n] < this.bubbleMaxStateAge[i]) break;
                this.entryState(i, 3);
                break;
            }
            case 3: {
                int n = i;
                this.bubbleActualStateAge[n] = this.bubbleActualStateAge[n] + 1;
                if (this.bubbleActualStateAge[n] < this.bubbleMaxStateAge[i]) break;
                this.entryState(i, 1);
            }
        }
    }

    private void oscillate(int i) {
        this.bubbleAlphaOsc[i] = (this.bubbleAlphaOsc[i] + this.bubbleDAlphaOsc[i]) % 360.0f;
        this.bubbleOscSizeX[i] = this.bubbleSizeX[i] + this.bubbleDSize[i] * (float)Math.sin(this.bubbleAlphaOsc[i]);
        this.bubbleOscSizeY[i] = this.bubbleSizeY[i] + this.bubbleDSize[i] * (float)Math.sin(this.bubbleAlphaOsc[i] + this.bubblePhiOsc[i]);
    }

    private void move(int i) {
        this.bubbleAX[i] = -0.25f + (float)Math.random() * 0.5f;
        this.bubbleAY[i] = -0.25f + (float)Math.random() * 0.5f;
        if (Math.abs(this.bubbleVX[i]) > 2.0f) {
            int n = i;
            this.bubbleVX[n] = this.bubbleVX[n] * 0.87f;
        } else {
            int n = i;
            this.bubbleVX[n] = this.bubbleVX[n] + this.bubbleAX[i];
        }
        if (Math.abs(this.bubbleVY[i]) > 2.0f) {
            int n = i;
            this.bubbleVY[n] = this.bubbleVY[n] * 0.87f;
        } else {
            int n = i;
            this.bubbleVY[n] = this.bubbleVY[n] + this.bubbleAY[i];
        }
        int n = i;
        this.bubblePX[n] = this.bubblePX[n] + this.bubbleVX[i];
        int n2 = i;
        this.bubblePY[n2] = this.bubblePY[n2] + this.bubbleVY[i];
        if (this.bubblePX[i] > (float)this.frame.getWidth()) {
            this.bubbleVX[i] = -Math.abs(this.bubbleVX[i]);
        } else if (this.bubblePX[i] < 0.0f) {
            this.bubbleVX[i] = Math.abs(this.bubbleVX[i]);
        }
        if (this.bubblePY[i] > (float)this.frame.getHeight()) {
            this.bubbleVY[i] = -Math.abs(this.bubbleVY[i]);
        } else if (this.bubblePY[i] < 0.0f) {
            this.bubbleVY[i] = Math.abs(this.bubbleVY[i]);
        }
    }

    private void grow(int i) {
    }

    private void sample() {
        int i = 0;
        while (i < this.maxNumberOfBubbles) {
            this.doState(i);
            if (this.bubbleState[i] != 3) {
                this.move(i);
                this.oscillate(i);
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.bubbleColor);
        int i = 0;
        while (i < this.maxNumberOfBubbles) {
            switch (this.bubbleState[i]) {
                case 1: {
                    g2d.drawOval((int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 2.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 2.0f), (int)this.bubbleOscSizeX[i], (int)this.bubbleOscSizeY[i]);
                    g2d.drawArc((int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 3.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 3.0f), (int)(this.bubbleOscSizeX[i] * 3.0f / 4.0f), (int)(this.bubbleOscSizeY[i] * 3.0f / 4.0f), 90, 60);
                    break;
                }
                case 2: {
                    g2d.drawLine((int)(this.bubblePX[i] + this.bubbleOscSizeX[i] / 8.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 8.0f), (int)(this.bubblePX[i] + this.bubbleOscSizeX[i] / 4.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 4.0f));
                    g2d.drawLine((int)(this.bubblePX[i] + this.bubbleOscSizeX[i] / 4.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 8.0f), (int)(this.bubblePX[i] + this.bubbleOscSizeX[i] * 3.0f / 8.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 8.0f));
                    g2d.drawLine((int)(this.bubblePX[i] + this.bubbleOscSizeX[i] / 4.0f), (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] / 8.0f), (int)(this.bubblePX[i] + this.bubbleOscSizeX[i] * 3.0f / 8.0f), (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] / 4.0f));
                    g2d.drawLine((int)this.bubblePX[i], (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] / 4.0f), (int)this.bubblePX[i], (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] * 3.0f / 8.0f));
                    g2d.drawLine((int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 4.0f), (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] / 4.0f), (int)(this.bubblePX[i] - this.bubbleOscSizeX[i] * 3.0f / 8.0f), (int)(this.bubblePY[i] + this.bubbleOscSizeY[i] * 3.0f / 8.0f));
                    g2d.drawLine((int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 4.0f), (int)this.bubblePY[i], (int)(this.bubblePX[i] - this.bubbleOscSizeX[i] * 3.0f / 8.0f), (int)this.bubblePY[i]);
                    g2d.drawLine((int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 8.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 8.0f), (int)(this.bubblePX[i] - this.bubbleOscSizeX[i] / 4.0f), (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 4.0f));
                    g2d.drawLine((int)this.bubblePX[i], (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] / 4.0f), (int)this.bubblePX[i], (int)(this.bubblePY[i] - this.bubbleOscSizeY[i] * 3.0f / 8.0f));
                    break;
                }
            }
            ++i;
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        f.setSize(new Dimension(640, 480));
        JPanel p = new JPanel();
        JButton b1 = new JButton("button 1");
        JButton b2 = new JButton("button 2");
        UiScreenSaverBubble ss = new UiScreenSaverBubble(f);
        ss.setNumberOfBubbles(15);
        ss.setStopOnMouseEntry(false);
        ss.setAllMouseAction(true);
        ss.start();
        p.add(b1);
        p.add(b2);
        f.getContentPane().add(p);
        f.setVisible(true);
    }
}

