/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.browser;

import ch.oli4.ui.browser.UiHtmlEvent;
import ch.oli4.ui.browser.UiHtmlListener;
import ch.oli4.ui.browser.UiHtmlPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class UiHtmlPanel
extends JPanel
implements HyperlinkListener {
    private List listeners = new ArrayList();
    private JEditorPane htmlPane;
    private List history;
    private int now = -1;

    public UiHtmlPanel() {
        this.setLayout(new BorderLayout());
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        JScrollPane htmlScrollPane = new JScrollPane(this.htmlPane);
        this.add((Component)htmlScrollPane, "Center");
        this.history = new LinkedList();
    }

    public void addPopupMenu(UiHtmlPopupMenu popupMenu) {
        this.htmlPane.addMouseListener(popupMenu);
    }

    public void addHtmlListener(UiHtmlListener l) {
        this.listeners.add(l);
    }

    private void fireHistoryChangedEvent() {
        UiHtmlEvent e = new UiHtmlEvent(this, (URL)this.history.get(this.now));
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((UiHtmlListener)it.next()).historyChanged(e);
        }
    }

    protected void firePossibleLinkChangedEvent(URL url) {
        UiHtmlEvent e = new UiHtmlEvent(this, url);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((UiHtmlListener)it.next()).possibleLinkChanged(e);
        }
    }

    public void setPage(URL u) {
        try {
            while (this.now < this.history.size() - 1) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(u);
            ++this.now;
            this.updatePane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL getPage() {
        return (URL)this.history.get(this.now);
    }

    public void goForward() {
        if (this.isForwardAvailable()) {
            ++this.now;
        }
        this.updatePane();
    }

    public void goBackward() {
        if (this.isBackwardAvailable()) {
            --this.now;
        }
        this.updatePane();
    }

    public void goHome() {
        this.now = 0;
        this.updatePane();
    }

    public boolean isBackwardAvailable() {
        return this.now > 0;
    }

    public boolean isForwardAvailable() {
        return this.now < this.history.size() - 1;
    }

    private void updatePane() {
        try {
            this.htmlPane.setPage((URL)this.history.get(this.now));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fireHistoryChangedEvent();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(e.getURL());
            this.firePossibleLinkChangedEvent(null);
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.firePossibleLinkChangedEvent(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.firePossibleLinkChangedEvent(null);
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        UiHtmlPanel h = new UiHtmlPanel();
        h.addPopupMenu(new UiHtmlPopupMenu(h));
        try {
            h.setPage(new URL("file:/home/oli4/eigene_daten/internet/oli4.ch/sagy/index.html"));
        }
        catch (MalformedURLException e) {
            System.out.println("ERROR: wrong test-source");
        }
        f.getContentPane().add(h);
        f.setSize(new Dimension(200, 150));
        f.setVisible(true);
    }
}

