/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.control;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.control.UiControlDouble;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UiControlDreh
extends UiControlDouble
implements MouseListener,
MouseMotionListener {
    private double majorTickSpacing = 10.0;
    private double minorTickSpacing = 5.0;
    private boolean snapToTicks = false;
    private boolean paintTicks = false;
    private int innerRadius;
    private int outerRadius;
    private int majorTickRadius;
    private int minorTickRadius;
    private UiPoint center;
    private UiPoint cursor;
    private float actualWinkel;
    private static final float minWinkel = 45.0f;
    private static final float maxWinkel = 315.0f;

    public UiControlDreh() {
        this.doDataChanged(this.snapData(this.getData()));
        this.setPreferredSize(new Dimension(40, 40));
        this.setMinimumSize(new Dimension(40, 40));
        this.setMaximumSize(new Dimension(80, 80));
        this.center = new UiPoint();
        this.cursor = new UiPoint();
        this.setForeground(new Color(0x9090B0));
        this.actualWinkel = this.dataToWinkel(this.getData());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setData(double d) {
        super.setData(d);
        this.actualWinkel = this.dataToWinkel(this.dataIst);
    }

    public void setMajorTickSpacing(double s) {
        this.majorTickSpacing = s;
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMinorTickSpacing(double s) {
        this.minorTickSpacing = s;
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setSnapToTicks(boolean b) {
        this.snapToTicks = b;
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setPaintTicks(boolean b) {
        this.paintTicks = b;
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    private int getExp10(double value) {
        int i = 12;
        while (i >= -12) {
            if (value > Math.pow(10.0, i)) {
                return i;
            }
            --i;
        }
        return -12;
    }

    public void setAutoTicks() {
        double p = this.getExp10(this.getDataMax() - this.getDataMin());
        this.setMajorTickSpacing(Math.pow(10.0, p));
        this.setMinorTickSpacing(this.getMajorTickSpacing() / 5.0);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enable) {
            this.actualWinkel = this.pointToWinkel(e.getX(), e.getY());
            this.doDataChanged(this.snapData(this.winkelToData(this.actualWinkel)));
            this.actualWinkel = this.dataToWinkel(this.dataIst);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.enable) {
            this.actualWinkel = this.pointToWinkel(e.getX(), e.getY());
            this.doDataChanging(this.snapData(this.winkelToData(this.actualWinkel)));
            this.actualWinkel = this.dataToWinkel(this.dataIst);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private float pointToWinkel(int x, int y) {
        float deltaX = x - this.center.x;
        float deltaY = y - this.center.y;
        float deltaS = (float)Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
        float w = deltaX < 0.0f ? (float)Math.acos(deltaY / deltaS) : (float)Math.PI * 2 - (float)Math.acos(deltaY / deltaS);
        if ((w = w * 180.0f / (float)Math.PI) < 45.0f) {
            w = 45.0f;
        } else if (this.actualWinkel > 315.0f) {
            w = 315.0f;
        }
        return w;
    }

    private void calculateRadius() {
        this.center.x = this.getWidth() >> 1;
        this.center.y = this.getHeight() >> 1;
        this.majorTickRadius = this.getHeight() < this.getWidth() ? this.center.y : this.center.x;
        this.minorTickRadius = this.majorTickRadius - 3;
        this.outerRadius = this.minorTickRadius - 4;
        this.innerRadius = this.outerRadius - 3;
    }

    protected float dataToWinkel(double d) {
        float w = 45.0f + (float)(d - this.dataMin) / (float)(this.dataMax - this.dataMin) * 270.0f;
        if (w < 45.0f) {
            w = 45.0f;
        } else if (w > 315.0f) {
            w = 315.0f;
        }
        return w;
    }

    private double winkelToData(double w) {
        double d = this.dataMin + (w - 45.0) / 270.0 * (this.dataMax - this.dataMin);
        if (d > this.dataMax) {
            d = this.dataMax;
        } else if (d < this.dataMin) {
            d = this.dataMin;
        }
        return d;
    }

    private double snapData(double d) {
        if (this.snapToTicks) {
            return this.minorTickSpacing * (double)((int)(d / this.minorTickSpacing));
        }
        return d;
    }

    private int toX(float winkel, int radius) {
        return (int)((float)radius * (float)Math.cos((double)((270.0f - winkel) / 180.0f) * Math.PI));
    }

    private int toY(double winkel, int radius) {
        return (int)((float)(-radius) * (float)Math.sin((270.0 - winkel) / 180.0 * Math.PI));
    }

    protected void paintComponent(Graphics g) {
        Color color = this.getForeground();
        super.paintComponent(g);
        Color lineColor = this.enable ? Color.black : Color.gray;
        this.calculateRadius();
        if (this.paintTicks) {
            float w;
            g.setColor(lineColor);
            double i = this.dataMin;
            while (i <= this.dataMax) {
                w = this.dataToWinkel(i);
                g.drawLine(this.center.x, this.center.y, this.center.x + this.toX(w, this.minorTickRadius), this.center.y + this.toY(w, this.minorTickRadius));
                i += this.minorTickSpacing;
            }
            i = this.dataMin;
            while (i <= this.dataMax) {
                w = this.dataToWinkel(i);
                g.drawLine(this.center.x, this.center.y, this.center.x + this.toX(w, this.majorTickRadius), this.center.y + this.toY(w, this.majorTickRadius));
                i += this.majorTickSpacing;
            }
        }
        g.setColor(color.darker());
        g.fillOval(this.center.x - this.outerRadius, this.center.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2);
        g.setColor(color.brighter());
        g.fillArc(this.center.x - this.outerRadius, this.center.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, 45, 180);
        g.setColor(lineColor);
        g.drawArc(this.center.x - this.outerRadius, this.center.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, 225, 180);
        g.setColor(color.darker());
        g.drawArc(this.center.x - this.outerRadius, this.center.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, 45, 180);
        g.setColor(color);
        g.fillOval(this.center.x - this.innerRadius, this.center.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2);
        g.setColor(lineColor);
        g.drawArc(this.center.x - this.innerRadius, this.center.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2, 225, 180);
        g.setColor(color.darker());
        g.drawArc(this.center.x - this.innerRadius, this.center.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2, 45, 180);
        g.setColor(lineColor);
        g.drawLine(this.center.x, this.center.y, this.center.x + this.toX(this.actualWinkel, this.outerRadius), this.center.y + this.toY(this.actualWinkel, this.outerRadius));
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiControlDreh c = new UiControlDreh();
        c.setEnabled(true);
        c.setSnapToTicks(false);
        c.setDataRange(0.0, 1.5);
        c.setMajorTickSpacing(0.5);
        c.setMinorTickSpacing(0.1);
        c.setPaintTicks(true);
        p.add((Component)c, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
    }
}

