/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.graph.UiPlot;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.Color;

public abstract class UiPlot1D
extends UiPlot {
    protected Color xLabelColor = this.getBackground().darker();
    protected Color xAxisColor = this.getBackground().darker();
    protected boolean xLabelVisible = true;
    protected boolean xAxisVisible = true;
    public double xScaleMin = 0.0;
    public double xScaleMax = 50.0;
    public boolean xAutoScale = true;

    public void setXLabelColor(Color c) {
        this.xLabelColor = c;
        this.repaintPlot();
    }

    public Color getXLabelColor() {
        return this.xLabelColor;
    }

    public void setXAxisColor(Color c) {
        this.xAxisColor = c;
        this.repaintPlot();
    }

    public Color getXAxisColor() {
        return this.xAxisColor;
    }

    public void setXLabelVisible(boolean b) {
        this.xLabelVisible = b;
        this.repaintPlot();
    }

    public boolean getXLabelVisible() {
        return this.xLabelVisible;
    }

    public void setXAxisVisible(boolean b) {
        this.xAxisVisible = b;
        this.repaintPlot();
    }

    public boolean getXAxisVisible() {
        return this.xAxisVisible;
    }

    public void setXScale(double min, double max) {
        this.xAutoScale = false;
        this.xScaleMin = min;
        this.xScaleMax = max;
        if (this.xScaleMax <= this.xScaleMin) {
            this.xScaleMax = this.xScaleMin + 1.0;
        }
        this.repaintPlot();
    }

    public void setXAutoScale(boolean b) {
        this.xAutoScale = b;
        this.repaintPlot();
    }

    protected void doXAutoScale() {
        if (this.xAutoScale) {
            double d = Double.MAX_VALUE;
            int i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.min(d, (double)((int)((UiPlotModel)this.models.get(i)).getDataMin(0, this.pScaleMin, this.pScaleMax)));
                ++i;
            }
            this.xScaleMin = d;
            d = Double.MIN_VALUE;
            i = 0;
            while (i < this.getNumberOfModels()) {
                d = Math.max(d, (double)((int)((UiPlotModel)this.models.get(i)).getDataMax(0, this.pScaleMin, this.pScaleMax)));
                ++i;
            }
            this.xScaleMax = d;
        }
    }

    public void repaintPlot() {
        this.doPAutoScale();
        this.doXAutoScale();
        this.repaint();
    }
}

