/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.signal.UiSignalBool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UiSignalLed
extends UiSignalBool {
    private Color onColor = Color.green;
    private Color offColor = this.getBackground().darker();
    private UiPoint ledCenter = new UiPoint();
    private int borderRadius;
    private int ledRadius;
    private int reflexRadius1;
    private int reflexRadius2;

    public UiSignalLed() {
        this.setPreferredSize(new Dimension(27, 27));
        this.setMaximumSize(new Dimension(27, 27));
    }

    public void setOnColor(Color c) {
        this.onColor = c;
        this.repaint();
    }

    public void setOffColor(Color c) {
        this.offColor = c;
        this.repaint();
    }

    private Color dataToColor() {
        int red = 0xFF & (int)((double)this.onColor.getRed() * this.dataIst + (double)this.offColor.getRed() * (1.0 - this.dataIst));
        int green = 0xFF & (int)((double)this.onColor.getGreen() * this.dataIst + (double)this.offColor.getGreen() * (1.0 - this.dataIst));
        int blue = 0xFF & (int)((double)this.onColor.getBlue() * this.dataIst + (double)this.offColor.getBlue() * (1.0 - this.dataIst));
        return new Color(red << 16 | green << 8 | blue);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.ledCenter.x = this.getWidth() / 2;
        this.ledCenter.y = this.getHeight() / 2;
        this.borderRadius = this.ledCenter.x < this.ledCenter.y ? this.ledCenter.x * 9 / 10 : this.ledCenter.y * 9 / 10;
        this.ledRadius = this.borderRadius * 6 / 7;
        if (this.ledRadius < this.borderRadius - 3) {
            this.ledRadius = this.borderRadius - 3;
        }
        this.reflexRadius1 = this.borderRadius * 6 / 10;
        this.reflexRadius2 = this.borderRadius * 4 / 10;
        g.setColor(this.getBackground().darker());
        g.fillOval(this.ledCenter.x - this.borderRadius, this.ledCenter.y - this.borderRadius, this.borderRadius * 2, this.borderRadius * 2);
        g.setColor(this.dataToColor());
        g.fillOval(this.ledCenter.x - this.ledRadius, this.ledCenter.y - this.ledRadius, this.ledRadius * 2, this.ledRadius * 2);
        g.setColor(Color.black);
        g.drawOval(this.ledCenter.x - this.borderRadius, this.ledCenter.y - this.borderRadius, this.borderRadius * 2, this.borderRadius * 2);
        g.drawOval(this.ledCenter.x - this.ledRadius, this.ledCenter.y - this.ledRadius, this.ledRadius * 2, this.ledRadius * 2);
        g.setColor(this.getBackground().brighter());
        g.drawArc(this.ledCenter.x - this.reflexRadius1, this.ledCenter.y - this.reflexRadius1, this.reflexRadius1 * 2, this.reflexRadius1 * 2, 90, 90);
        g.drawArc(this.ledCenter.x - this.reflexRadius2, this.ledCenter.y - this.reflexRadius2, this.reflexRadius2 * 2, this.reflexRadius2 * 2, 90, 90);
    }

    public static void main(String[] arg) {
        new Test();
    }

    private static class Test
    implements ActionListener {
        private UiSignalLed led;
        private JButton on;
        private JButton off;
        private JTextField blinkPeriod;
        private JTextField transitionTime;
        private JTextField onColor;
        private JTextField offColor;

        public Test() {
            JFrame f = new JFrame();
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            this.led = new UiSignalLed();
            this.led.setOffColor(Color.red);
            this.led.setData(false);
            p.add((Component)this.led, "Center");
            JPanel sp = new JPanel();
            p.add((Component)sp, "South");
            this.on = new JButton("on");
            sp.add(this.on);
            this.on.addActionListener(this);
            this.off = new JButton("off");
            sp.add(this.off);
            this.off.addActionListener(this);
            sp.add(new JLabel("blink-period"));
            this.blinkPeriod = new JTextField(5);
            sp.add(this.blinkPeriod);
            this.blinkPeriod.addActionListener(this);
            sp.add(new JLabel("transition-time"));
            this.transitionTime = new JTextField(5);
            sp.add(this.transitionTime);
            this.transitionTime.addActionListener(this);
            sp.add(new JLabel("on-color"));
            this.onColor = new JTextField(5);
            sp.add(this.onColor);
            this.onColor.addActionListener(this);
            sp.add(new JLabel("off-color"));
            this.offColor = new JTextField(5);
            sp.add(this.offColor);
            this.offColor.addActionListener(this);
            f.getContentPane().add(p);
            f.setSize(new Dimension(100, 100));
            f.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.on) {
                this.led.setData(true);
            } else if (e.getSource() == this.off) {
                this.led.setData(false);
            } else if (e.getSource() == this.blinkPeriod) {
                this.led.setBlinkPeriod(Integer.parseInt(this.blinkPeriod.getText()));
            } else if (e.getSource() == this.transitionTime) {
                this.led.setTransitionTime(Integer.parseInt(this.transitionTime.getText()));
            } else if (e.getSource() == this.onColor) {
                this.led.setOnColor(new Color(Integer.valueOf(this.onColor.getText(), 16)));
            } else if (e.getSource() == this.offColor) {
                this.led.setOffColor(new Color(Integer.valueOf(this.offColor.getText(), 16)));
            }
        }
    }
}

