/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.stroke;

import ch.oli4.ui.stroke.UiStrokeEvent;
import ch.oli4.ui.stroke.UiStrokeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiStroke
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Color strokeColor;
    protected boolean enabled;
    protected int buttonMask;
    protected boolean tracing;
    private static final int mouseTraceSize = 1024;
    private int mouseTraceIndex;
    private int[] mouseTraceX;
    private int[] mouseTraceY;
    private int mouseTraceTop;
    private int mouseTraceBottom;
    private int mouseTraceLeft;
    private int mouseTraceRight;
    private int mouseTraceWidth;
    private int mouseTraceHeight;
    private int strokeGridWidth;
    private int strokeGridHeight;
    private static final int strokeGridSize = 3;
    private static final int strokeSequenceSize = 32;
    private int strokeSequenceIndex;
    private StringBuffer strokeSequence;
    private int lastGrid;
    private int actualGrid;
    private boolean debugMode;
    private int oldDragX = 0;
    private int oldDragY = 0;
    private Vector listenerList;
    public static final int UNKNOWN = 0;
    public static final int I_RIGHT = 1;
    public static final int I_LEFT = 2;
    public static final int I_UP = 3;
    public static final int I_DOWN = 4;
    public static final int L_UP = 11;
    public static final int L_DOWN = 12;
    public static final int L_MIRROR_UP = 13;
    public static final int L_MIRROR_DOWN = 14;
    public static final int S_UP = 21;
    public static final int S_DOWN = 22;
    public static final int S_MIRROR_UP = 23;
    public static final int S_MIRROR_DOWN = 24;
    public static final int N_LEFT = 31;
    public static final int N_RIGHT = 32;
    public static final int U_LEFT = 41;
    public static final int U_RIGHT = 42;
    public static final int B_DOWN = 51;
    public static final int D_DOWN = 61;
    public static final int P_UP = 71;
    public static final int O_UP = 81;
    public static final int O_DOWN = 82;
    public static final int C_UP = 91;
    public static final int C_DOWN = 92;
    public static final int C_MIRROR_UP = 93;
    public static final int C_MIRROR_DOWN = 94;
    public static final int F_UP = 101;
    public static final int F_DOWN = 102;
    public static final int F_MIRROR_UP = 103;
    public static final int F_MIRROR_DOWN = 104;

    public UiStroke() {
        this.setDebugMode(false);
        this.setEnabled(true);
        this.setStrokeColor(Color.red);
        this.strokeSequence = new StringBuffer();
        this.mouseTraceInit();
        this.setButtonMask(16);
        this.eventInit();
        this.setPreferredSize(new Dimension(200, 150));
    }

    public void setStrokeColor(Color c) {
        this.strokeColor = c;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setButtonMask(int m) {
        this.buttonMask = m;
    }

    public int getButtonMask() {
        return this.buttonMask;
    }

    private void mouseTraceInit() {
        this.tracing = false;
        this.mouseTraceX = new int[1024];
        this.mouseTraceY = new int[1024];
    }

    protected void mouseTraceStart(MouseEvent e) {
        this.mouseTraceIndex = 0;
        this.tracing = true;
        this.addTrace(e.getX(), e.getY());
    }

    private void mouseTraceDrag(MouseEvent e) {
        this.addTrace(e.getX(), e.getY());
    }

    protected void mouseTraceStop(MouseEvent e) {
        this.tracing = false;
        this.calculateGrid();
        this.recordStrokeSequence();
        this.processStrokeEvent(this.getStrokeSequence(), this.mouseTraceLeft, this.mouseTraceTop, this.mouseTraceWidth, this.mouseTraceHeight);
    }

    private void addTrace(int x, int y) {
        this.mouseTraceX[this.mouseTraceIndex] = x;
        this.mouseTraceY[this.mouseTraceIndex] = y;
        ++this.mouseTraceIndex;
    }

    private void calculateGrid() {
        this.mouseTraceTop = Integer.MAX_VALUE;
        this.mouseTraceBottom = Integer.MIN_VALUE;
        this.mouseTraceLeft = Integer.MAX_VALUE;
        this.mouseTraceRight = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.mouseTraceIndex) {
            if (this.mouseTraceX[i] < this.mouseTraceLeft) {
                this.mouseTraceLeft = this.mouseTraceX[i];
            }
            if (this.mouseTraceX[i] > this.mouseTraceRight) {
                this.mouseTraceRight = this.mouseTraceX[i];
            }
            if (this.mouseTraceY[i] < this.mouseTraceTop) {
                this.mouseTraceTop = this.mouseTraceY[i];
            }
            if (this.mouseTraceY[i] > this.mouseTraceBottom) {
                this.mouseTraceBottom = this.mouseTraceY[i];
            }
            ++i;
        }
        this.mouseTraceWidth = this.mouseTraceRight - this.mouseTraceLeft;
        this.mouseTraceHeight = this.mouseTraceBottom - this.mouseTraceTop;
        int sizeMin = 15;
        if (this.mouseTraceWidth < 15) {
            this.mouseTraceWidth = 15;
        }
        if (this.mouseTraceHeight < 15) {
            this.mouseTraceHeight = 15;
        }
        int distortionMax = 2;
        if (this.mouseTraceWidth / this.mouseTraceHeight > 2) {
            this.mouseTraceHeight = this.mouseTraceWidth / 2;
        }
        if (this.mouseTraceHeight / this.mouseTraceWidth > 2) {
            this.mouseTraceWidth = this.mouseTraceHeight / 2;
        }
        int centerX = (this.mouseTraceRight + this.mouseTraceLeft) / 2;
        int centerY = (this.mouseTraceBottom + this.mouseTraceTop) / 2;
        this.mouseTraceLeft = centerX - this.mouseTraceWidth / 2;
        this.mouseTraceRight = centerX + this.mouseTraceWidth / 2;
        this.mouseTraceTop = centerY - this.mouseTraceHeight / 2;
        this.mouseTraceBottom = centerY + this.mouseTraceHeight / 2;
        this.mouseTraceLeft -= this.mouseTraceWidth / 3 / 2;
        this.mouseTraceRight += this.mouseTraceWidth / 3 / 2;
        this.mouseTraceTop -= this.mouseTraceHeight / 3 / 2;
        this.mouseTraceBottom += this.mouseTraceHeight / 3 / 2;
        this.mouseTraceWidth = this.mouseTraceRight - this.mouseTraceLeft;
        this.mouseTraceHeight = this.mouseTraceBottom - this.mouseTraceTop;
        this.strokeGridWidth = this.mouseTraceWidth / 3;
        this.strokeGridHeight = this.mouseTraceHeight / 3;
    }

    private int XYtoStrokeGrid(int x, int y) {
        int i = 0;
        while (i < 3) {
            if (x < this.mouseTraceLeft + (i + 1) * this.strokeGridWidth) {
                int j = 0;
                while (j < 3) {
                    if (y < this.mouseTraceTop + (j + 1) * this.strokeGridHeight) {
                        return i + 1 + j * 3;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return 0;
    }

    private void recordStrokeSequence() {
        this.strokeSequence = new StringBuffer();
        this.strokeSequenceIndex = 0;
        int i = 0;
        while (i < this.mouseTraceIndex) {
            this.actualGrid = this.XYtoStrokeGrid(this.mouseTraceX[i], this.mouseTraceY[i]);
            if (this.strokeSequenceIndex == 0) {
                this.lastGrid = this.actualGrid;
                this.strokeSequence.append(Integer.toString(this.actualGrid));
                ++this.strokeSequenceIndex;
            } else if (this.actualGrid != this.lastGrid) {
                this.lastGrid = this.actualGrid;
                if (this.strokeSequenceIndex < 32) {
                    this.strokeSequence.append(Integer.toString(this.actualGrid));
                    ++this.strokeSequenceIndex;
                } else {
                    if (this.debugMode) {
                        System.out.println("maximum stroke-length reached");
                    }
                    return;
                }
            }
            ++i;
        }
        if (this.debugMode) {
            System.out.println(this.extremasToString());
            System.out.println(this.strokeSequenceToString());
        }
    }

    public String getStrokeSequence() {
        return this.strokeSequence.toString();
    }

    public void setDebugMode(boolean b) {
        this.debugMode = b;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    private String strokeSequenceToString() {
        return "stroke=" + this.strokeSequence.toString();
    }

    private String extremasToString() {
        return "extremas={ top=" + this.mouseTraceTop + ", bottom=" + this.mouseTraceBottom + ", left=" + this.mouseTraceLeft + ", right=" + this.mouseTraceRight + ", width=" + this.mouseTraceWidth + ", height=" + this.mouseTraceHeight + "}";
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this && (e.getModifiers() & this.buttonMask) != 0 && this.enabled) {
            this.mouseTraceStart(e);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this && (e.getModifiers() & this.buttonMask) != 0 && this.enabled) {
            this.mouseTraceStop(e);
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & this.buttonMask) != 0 && this.enabled) {
            this.mouseTraceDrag(e);
            if (this.mouseTraceIndex >= 2) {
                int x = e.getX();
                int y = e.getY();
                this.repaint(Math.min(x, this.oldDragX) - 10, Math.min(y, this.oldDragY) - 10, Math.abs(x - this.oldDragX) + 20, Math.abs(y - this.oldDragY) + 20);
                this.oldDragX = x;
                this.oldDragY = y;
            } else {
                this.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void addStrokeListener(UiStrokeListener l) {
        this.listenerList.add(l);
    }

    public void removeStrokeListener(UiStrokeListener l) {
        this.listenerList.remove(l);
    }

    private void processStrokeEvent(String result, int x, int y, int w, int h) {
        Object[] sl = this.listenerList.toArray();
        UiStrokeEvent se = new UiStrokeEvent(this, result, x, y, w, h);
        int i = 0;
        while (i < sl.length) {
            ((UiStrokeListener)sl[i]).onStroke(se);
            ++i;
        }
    }

    private void eventInit() {
        this.listenerList = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static int toStroke(String stroke) {
        switch (stroke.length()) {
            case 3: {
                if (stroke.compareTo("456") == 0) {
                    return 1;
                }
                if (stroke.compareTo("654") == 0) {
                    return 2;
                }
                if (stroke.compareTo("258") == 0) {
                    return 4;
                }
                if (stroke.compareTo("852") == 0) {
                    return 3;
                }
                return 0;
            }
            case 5: {
                if (stroke.compareTo("98741") == 0) {
                    return 11;
                }
                if (stroke.compareTo("14789") == 0) {
                    return 12;
                }
                if (stroke.compareTo("78963") == 0) {
                    return 13;
                }
                if (stroke.compareTo("36987") == 0) {
                    return 14;
                }
                if (stroke.compareTo("74123") == 0) {
                    return 101;
                }
                if (stroke.compareTo("32147") == 0) {
                    return 102;
                }
                if (stroke.compareTo("96321") == 0) {
                    return 103;
                }
                if (stroke.compareTo("12369") == 0) {
                    return 104;
                }
                return 0;
            }
            case 7: {
                if (stroke.compareTo("7412369") == 0) {
                    return 32;
                }
                if (stroke.compareTo("9632147") == 0) {
                    return 31;
                }
                if (stroke.compareTo("1478963") == 0) {
                    return 42;
                }
                if (stroke.compareTo("3698741") == 0) {
                    return 41;
                }
                if (stroke.compareTo("9874123") == 0) {
                    return 91;
                }
                if (stroke.compareTo("3214789") == 0) {
                    return 92;
                }
                if (stroke.compareTo("7896321") == 0) {
                    return 93;
                }
                if (stroke.compareTo("1236987") == 0) {
                    return 94;
                }
                return 0;
            }
            case 8: {
                if (stroke.compareTo("14789654") == 0) {
                    return 51;
                }
                if (stroke.compareTo("36987456") == 0) {
                    return 61;
                }
                if (stroke.compareTo("74123654") == 0) {
                    return 71;
                }
                return 0;
            }
            case 9: {
                if (stroke.compareTo("789654123") == 0) {
                    return 21;
                }
                if (stroke.compareTo("321456987") == 0) {
                    return 22;
                }
                if (stroke.compareTo("987456321") == 0) {
                    return 23;
                }
                if (stroke.compareTo("123654789") == 0) {
                    return 24;
                }
                if (stroke.compareTo("741236987") == 0) {
                    return 81;
                }
                if (stroke.compareTo("147896321") == 0) {
                    return 82;
                }
                return 0;
            }
        }
        return 0;
    }

    protected void paintComponent(Graphics g) {
        if (this.enabled) {
            int i;
            super.paintComponent(g);
            g.setColor(this.strokeColor);
            int borderAbstand = 8;
            g.drawRect(8, 8, this.getWidth() - 16, this.getHeight() - 16);
            if (this.debugMode) {
                g.setColor(this.getBackground().brighter());
                g.fillRect(this.mouseTraceLeft, this.mouseTraceTop, this.mouseTraceWidth, this.mouseTraceHeight);
            }
            if (this.tracing || this.debugMode) {
                i = 1;
                while (i < this.mouseTraceIndex) {
                    g.setColor(this.strokeColor);
                    g.drawLine(this.mouseTraceX[i - 1], this.mouseTraceY[i - 1], this.mouseTraceX[i], this.mouseTraceY[i]);
                    ++i;
                }
            }
            if (this.debugMode) {
                g.setColor(this.getBackground().darker());
                i = 0;
                while (i <= 3) {
                    g.drawLine(this.mouseTraceLeft + this.strokeGridWidth * i, this.mouseTraceTop, this.mouseTraceLeft + this.strokeGridWidth * i, this.mouseTraceBottom);
                    ++i;
                }
                i = 0;
                while (i <= 3) {
                    g.drawLine(this.mouseTraceLeft, this.mouseTraceTop + this.strokeGridHeight * i, this.mouseTraceRight, this.mouseTraceTop + this.strokeGridHeight * i);
                    ++i;
                }
            }
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiStroke s = new UiStroke();
        s.setDebugMode(true);
        s.setStrokeColor(Color.pink);
        s.setButtonMask(16);
        p.add((Component)s, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(300, 200));
        f.setVisible(true);
    }
}

