/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.system.Log;
import java.io.Serializable;

public final class PlayThread
extends Thread
implements Serializable {
    private static final long serialVersionUID = 3546401588411431506L;
    private final transient Mixer currentMixer;
    private final PlayThreadEventListener listener;
    private volatile boolean isRunning;
    private volatile boolean finishedNormaly;

    public PlayThread(Mixer mixer, PlayThreadEventListener playThreadEventListener) {
        if (mixer == null) {
            throw new IllegalArgumentException("Provided Mixer was NULL");
        }
        this.currentMixer = mixer;
        this.isRunning = false;
        this.finishedNormaly = false;
        this.listener = playThreadEventListener;
        this.setName("PlayThread");
        this.setDaemon(true);
        this.setPriority(10);
    }

    private void informListener() {
        this.listener.playThreadEventOccured(this);
    }

    public void stopMod() {
        if (this.isRunning) {
            this.currentMixer.stopPlayback();
            while (this.isRunning) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void pausePlay() {
        if (this.isRunning) {
            this.currentMixer.pausePlayback();
        }
        this.informListener();
    }

    public Mixer getCurrentMixer() {
        return this.currentMixer;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean getHasFinishedNormaly() {
        return this.finishedNormaly;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.finishedNormaly = false;
        this.informListener();
        try {
            this.getCurrentMixer().startPlayback();
        }
        catch (Throwable throwable) {
            Log.error("[MainForm::run]", throwable);
        }
        this.isRunning = false;
        this.finishedNormaly = this.getCurrentMixer().hasFinished();
        this.informListener();
    }
}

